/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.storage.i18n.I18nUtil;
import com.vmware.vsphere.client.storage.sioc.Constants;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageSiocPropertyProvider
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(StorageSiocPropertyProvider.class);
    private final DataService _dataService;

    public StorageSiocPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public void setDataServiceExtensionRegistry(DataServiceExtensionRegistry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("DataServiceExtensionRegistry null reference provided.");
        }
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = VirtualMachine.class.getSimpleName();
        ti.properties = Constants.ALL_PROPERTIES;
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Map<ManagedObjectReference, VirtualDisk[]> disksByVmRef;
        Validate.notNull((Object)propertyRequest);
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        if (objects == null || properties == null || properties.length == 0) {
            _logger.error((Object)"Empty objects or properties set.");
            return null;
        }
        ArrayList<ManagedObjectReference> vmRefs = new ArrayList<ManagedObjectReference>();
        for (Object obj : objects) {
            if (!(obj instanceof ManagedObjectReference)) {
                _logger.warn((Object)("ManagedObjectReference expected but found: " + obj));
                continue;
            }
            ManagedObjectReference moRef = (ManagedObjectReference)obj;
            if (!VirtualMachine.class.equals((Object)ManagedObjectUtil.getType((ManagedObjectReference)moRef))) {
                _logger.warn((Object)("Expected VirtualMachine moRef but got: " + moRef));
                continue;
            }
            vmRefs.add(moRef);
        }
        if (vmRefs.isEmpty()) {
            _logger.warn((Object)"No objects left after filtering.");
            return null;
        }
        HashMap<String, Object> requestedProperties = new HashMap<String, Object>();
        for (PropertySpec propSpec : properties) {
            ParameterSpec[] params;
            for (String propName : propSpec.propertyNames) {
                if (!Constants.ALL_PROPERTIES_SET.contains(propName)) continue;
                requestedProperties.put(propName, null);
            }
            for (ParameterSpec param : params = propSpec.parameters) {
                if (!requestedProperties.containsKey(param.propertyName)) continue;
                requestedProperties.put(param.propertyName, param.parameter);
            }
        }
        if (requestedProperties.isEmpty()) {
            _logger.warn((Object)"No properties left after filtering.");
            return null;
        }
        ManagedObjectReference datastoreRef = StorageSiocPropertyProvider.getSingleDatastoreParameter(requestedProperties);
        if (datastoreRef == null) {
            _logger.warn((Object)"No Datastore context object provided.");
            return null;
        }
        Long datastoreSharesValue = null;
        if (requestedProperties.containsKey("sioc.datastorePercentShares")) {
            datastoreSharesValue = this.getDatastoreShares(datastoreRef);
        }
        if ((disksByVmRef = this.getVmDisks(vmRefs)) == null || disksByVmRef.isEmpty()) {
            _logger.warn((Object)"No VirtualDisk data to collect.");
            return null;
        }
        List<ResultItem> items = this.computeProperties(vmRefs, requestedProperties, disksByVmRef, datastoreRef, datastoreSharesValue);
        ResultSet result = new ResultSet();
        result.items = items.toArray(new ResultItem[0]);
        disksByVmRef.clear();
        vmRefs.clear();
        requestedProperties.clear();
        return result;
    }

    private static ManagedObjectReference getSingleDatastoreParameter(Map<String, Object> requestedProperties) {
        ManagedObjectReference datastoreRef = null;
        for (Object parameter : requestedProperties.values()) {
            if (parameter == null || !(parameter instanceof ManagedObjectReference) || !ManagedObjectUtil.getType((ManagedObjectReference)((ManagedObjectReference)parameter)).equals(Datastore.class)) continue;
            if (datastoreRef == null) {
                datastoreRef = (ManagedObjectReference)parameter;
                continue;
            }
            if (ManagedObjectUtil.areEqual((ManagedObjectReference)datastoreRef, (ManagedObjectReference)((ManagedObjectReference)parameter)).booleanValue()) continue;
            _logger.warn((Object)"Expected a single context object but found another one.");
            datastoreRef = null;
            break;
        }
        return datastoreRef;
    }

    private List<ResultItem> computeProperties(List<ManagedObjectReference> vmRefs, Map<String, Object> requestedProperties, Map<ManagedObjectReference, VirtualDisk[]> disksByVmRef, ManagedObjectReference datastoreRef, Long datastoreShares) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        for (ManagedObjectReference vmRef : vmRefs) {
            VirtualDisk[] disks = disksByVmRef.get(vmRef);
            ArrayList<PropertyValue> propValues = new ArrayList<PropertyValue>();
            if (requestedProperties.containsKey("sioc.sharesValue")) {
                long vmShares = StorageSiocPropertyProvider.calculateVmShares(disks, datastoreRef);
                propValues.add(StorageUtil.createPropValue((String)"sioc.sharesValue", (Object)vmShares, (Object)vmRef));
            }
            if (requestedProperties.containsKey("sioc.limitIOPs")) {
                String limitIOPs = StorageSiocPropertyProvider.calculateLimitIOPs(disks, datastoreRef);
                propValues.add(StorageUtil.createPropValue((String)"sioc.limitIOPs", (Object)limitIOPs, (Object)vmRef));
            }
            if (requestedProperties.containsKey("sioc.datastorePercentShares")) {
                double dsPercentShares = StorageSiocPropertyProvider.calculateDsPercentShares(disks, datastoreRef, datastoreShares);
                propValues.add(StorageUtil.createPropValue((String)"sioc.datastorePercentShares", (Object)dsPercentShares, (Object)vmRef));
            }
            ResultItem ri = new ResultItem();
            ri.resourceObject = vmRef;
            ri.properties = propValues.toArray(new PropertyValue[0]);
            items.add(ri);
        }
        return items;
    }

    private static double calculateDsPercentShares(VirtualDisk[] virtualDisks, ManagedObjectReference datastoreRef, Long datastoreShares) {
        long vmShares = StorageSiocPropertyProvider.calculateVmShares(virtualDisks, datastoreRef);
        double vmDsPercentShares = -1.0;
        vmDsPercentShares = datastoreShares != null && (double)datastoreShares.longValue() != 0.0 ? (double)vmShares / datastoreShares.doubleValue() * 100.0 : vmDsPercentShares;
        return vmDsPercentShares;
    }

    private static String calculateLimitIOPs(VirtualDisk[] virtualDisks, ManagedObjectReference datastoreRef) {
        long vmLimitIOPs = 0L;
        Boolean vmIOPsSupported = true;
        Boolean vmIOpsUnlimited = false;
        for (VirtualDisk vDisk : virtualDisks) {
            if (!StorageSiocPropertyProvider.isValidDisk(vDisk, datastoreRef)) continue;
            if (vDisk.storageIOAllocation == null) {
                vmIOPsSupported = false;
                continue;
            }
            if (vDisk.storageIOAllocation.limit == -1L) {
                vmIOpsUnlimited = true;
                continue;
            }
            vmLimitIOPs += vDisk.storageIOAllocation.limit.longValue();
        }
        String vmIOPsLimitText = vmIOPsSupported == false ? I18nUtil.getLocalizedString("sioc.iopsLimitNotSupported") : (vmIOpsUnlimited != false ? I18nUtil.getLocalizedString("sioc.iopsLimitUnlimited") : String.valueOf(vmLimitIOPs));
        return vmIOPsLimitText;
    }

    private static long calculateVmShares(VirtualDisk[] virtualDisks, ManagedObjectReference datastoreRef) {
        long vmShares = 0L;
        for (VirtualDisk vDisk : virtualDisks) {
            if (!StorageSiocPropertyProvider.isValidDisk(vDisk, datastoreRef)) continue;
            if (vDisk.storageIOAllocation != null && vDisk.storageIOAllocation.shares != null) {
                vmShares += (long)vDisk.storageIOAllocation.shares.shares;
                continue;
            }
            if (vDisk.shares == null) continue;
            vmShares += (long)vDisk.shares.shares;
        }
        return vmShares;
    }

    private static boolean isValidDisk(VirtualDisk virtualDisk, ManagedObjectReference datastoreRef) {
        if (virtualDisk == null || datastoreRef == null) {
            return false;
        }
        VirtualDevice.BackingInfo fileBackingInfo = virtualDisk.backing;
        return fileBackingInfo != null && fileBackingInfo instanceof VirtualDevice.FileBackingInfo && ManagedObjectUtil.areEqual((ManagedObjectReference)((VirtualDevice.FileBackingInfo)virtualDisk.backing).datastore, (ManagedObjectReference)datastoreRef) != false;
    }

    private Map<ManagedObjectReference, VirtualDisk[]> getVmDisks(List<ManagedObjectReference> vmRefs) {
        HashMap<ManagedObjectReference, VirtualDisk[]> disksByVmRef = null;
        if (CollectionUtils.isNotEmpty(vmRefs)) {
            PropertyValue[] vmDisks = null;
            try {
                vmDisks = QueryUtil.getProperty((DataService)this._dataService, (Object[])vmRefs.toArray(), (String)"virtualDisks");
            }
            catch (Exception e) {
                _logger.error((Object)("Property retrieval failed for objects: " + vmRefs), (Throwable)e);
            }
            if (vmDisks != null && vmDisks.length > 0) {
                disksByVmRef = new HashMap<ManagedObjectReference, VirtualDisk[]>(vmDisks.length);
                for (PropertyValue propValue : vmDisks) {
                    if (propValue == null || propValue.value == null) {
                        _logger.warn((Object)"Unexpected null property value retrieved.");
                        continue;
                    }
                    if (!(propValue.value instanceof VirtualDevice[])) {
                        _logger.warn((Object)("Expected VirtualDevice array but got: " + propValue.value.getClass()));
                        continue;
                    }
                    VirtualDevice[] vDevices = (VirtualDevice[])propValue.value;
                    VirtualDisk[] disks = new VirtualDisk[vDevices.length];
                    for (int i = 0; i < vDevices.length; ++i) {
                        VirtualDevice vDevice = vDevices[i];
                        if (!(vDevice instanceof VirtualDisk)) {
                            _logger.warn((Object)("Expected VirtualDisk but got: " + vDevice));
                            continue;
                        }
                        disks[i] = (VirtualDisk)vDevice;
                    }
                    disksByVmRef.put((ManagedObjectReference)propValue.resourceObject, disks);
                }
            }
        }
        return disksByVmRef;
    }

    private Long getDatastoreShares(ManagedObjectReference datastoreRef) {
        Long shares = null;
        try {
            shares = (Long)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)"sharesValue");
        }
        catch (Exception e) {
            _logger.error((Object)("Could not retrieve property for object: " + datastoreRef), (Throwable)e);
        }
        return shares;
    }
}

