/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.util.internal;

import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.host.DatastoreBrowser;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.common.storage.FileSpec;
import com.vmware.vsphere.client.storage.util.internal.DatastorePathUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreBrowserUtil {
    private static final Log _logger = LogFactory.getLog(DatastoreBrowserUtil.class);

    public static OperationResult queryFiles(TaskMonitor taskMonitor, ManagedObjectReference moRef, FileSpec spec) throws Exception {
        EnvironmentBrowser envBrowser;
        ManagedObjectReference envBrowserRef;
        DatastorePathUtil.escapeDatastoreNameInFileSpec(spec);
        String errorMessage = null;
        ManagedObjectReference dsBrowserRef = null;
        OperationResult opResult = new OperationResult();
        opResult.entity = moRef;
        ManagedObject managedObject = ManagedObjectUtil.getManagedObject((ManagedObjectReference)moRef);
        if (managedObject instanceof DatastoreBrowser) {
            dsBrowserRef = moRef;
        } else if (managedObject instanceof HostSystem) {
            dsBrowserRef = ((HostSystem)managedObject).getDatastoreBrowser();
        } else if (managedObject instanceof Datastore) {
            dsBrowserRef = ((Datastore)managedObject).getBrowser();
        } else if (managedObject instanceof ComputeResource) {
            envBrowserRef = ((ComputeResource)managedObject).getEnvironmentBrowser();
            envBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)envBrowserRef);
            dsBrowserRef = envBrowser.getDatastoreBrowser();
        } else if (managedObject instanceof VirtualMachine) {
            envBrowserRef = ((VirtualMachine)managedObject).getEnvironmentBrowser();
            envBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)envBrowserRef);
            dsBrowserRef = envBrowser.getDatastoreBrowser();
        } else {
            errorMessage = ResourceUtil.getString((String)"StorageService", (String)"error.invalidManagedObject", (ClassLoader)DatastoreBrowserUtil.class.getClassLoader());
            throw new IllegalArgumentException(errorMessage);
        }
        DatastoreBrowser dsBrowser = (DatastoreBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dsBrowserRef);
        try {
            ManagedObjectReference taskRef = null;
            taskRef = spec.subFolders ? dsBrowser.searchSubFolders(spec.datastorePath, spec.searchSpec) : dsBrowser.search(spec.datastorePath, spec.searchSpec);
            TaskInfo info = taskMonitor.monitorTask(taskRef);
            opResult.task = taskRef;
            DatastorePathUtil.unescapeDatastoreNameInSearchResults(info.result);
            opResult.result = info.result;
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to query files.", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }
}

