/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.backend.impl;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.network.backend.DistributedVirtualSwitchManagerFactory;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DistributedVirtualSwitchManagerFactoryImpl
implements DistributedVirtualSwitchManagerFactory {
    private static final Log LOG = LogFactory.getLog(DistributedVirtualSwitchManagerFactoryImpl.class);

    @Override
    public DistributedVirtualSwitchManager getDistributedVirtualSwitchManager(String serviceGuid) {
        ServiceInstanceContent sic;
        Validate.notNull((Object)serviceGuid);
        DistributedVirtualSwitchManager manager = null;
        VcService service = VimSessionUtil.getService((String)serviceGuid);
        if (service != null && (sic = service.getServiceInstanceContent()) != null) {
            try {
                manager = (DistributedVirtualSwitchManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sic.getDvSwitchManager());
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to get DistributedVirtualSwitchManager for vcenter " + serviceGuid));
                throw new RuntimeException(e);
            }
        }
        if (manager == null) {
            String errorMessage = "Failed to get DistributedVirtualSwitchManager for vcenter " + serviceGuid;
            LOG.error((Object)errorMessage);
            throw new RuntimeException(errorMessage);
        }
        return manager;
    }
}

