/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.impl;

import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vsphere.client.dvpg.api.DvPortgroupPortProperties;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.DvPortgroupPolicyParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgFailoverPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgMiscPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgMonitoringPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgResourceAllocationPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgSecurityPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgTrafficShapingPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgVlanPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.EditDvPortgroupDialogData;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.EditDvPortgroupDialogProperties;
import java.util.ArrayList;

public class EditDvPortgroupParser {
    public static EditDvPortgroupDialogProperties getDvPortgroupDialogProperties(EditDvPortgroupDialogData dvPortgroupData) {
        EditDvPortgroupDialogProperties properties = new EditDvPortgroupDialogProperties();
        properties.name = dvPortgroupData.name;
        properties.configVersion = dvPortgroupData.configVersion;
        properties.description = dvPortgroupData.description;
        properties.isDvsNetworkOffloadEnabled = dvPortgroupData.isDvsNetworkOffloadEnabled != null && dvPortgroupData.isDvsNetworkOffloadEnabled != false;
        EditDvPortgroupParser.setNetworkResourcePool(dvPortgroupData, properties);
        properties.numPorts = dvPortgroupData.numPorts;
        properties.maxNumPorts = dvPortgroupData.numPorts > 8192 ? dvPortgroupData.numPorts : 8192;
        properties.isUplink = dvPortgroupData.isUplink;
        EditDvPortgroupParser.setPortBindingProperties(dvPortgroupData, properties);
        EditDvPortgroupParser.setPortAllocationProperties(dvPortgroupData, properties);
        EditDvPortgroupParser.setVlanSettings(dvPortgroupData, properties);
        EditDvPortgroupParser.setSecurityPolicy(dvPortgroupData, properties);
        EditDvPortgroupParser.setTeamingAndFailoverPolicy(dvPortgroupData, properties);
        EditDvPortgroupParser.setTrafficShapingPolicy(dvPortgroupData, properties);
        EditDvPortgroupParser.setIpfixPolicy(dvPortgroupData, properties);
        EditDvPortgroupParser.setPortBlockedPolicy(dvPortgroupData, properties);
        properties.dvPortgroupPortProperties = new DvPortgroupPortProperties();
        DvPortgroupPolicyParser.setAdvancedPortPolicies(dvPortgroupData.policy, dvPortgroupData.isUplink, properties.isDvsNetworkOffloadEnabled, dvPortgroupData.dvsCapability, dvPortgroupData.niocVersion, properties.dvPortgroupPortProperties);
        return properties;
    }

    private static void setPortBindingProperties(EditDvPortgroupDialogData dvPortgroupData, EditDvPortgroupDialogProperties properties) {
        if (dvPortgroupData == null || properties == null) {
            return;
        }
        if (dvPortgroupData.type.equals(DistributedVirtualPortgroup.PortgroupType.lateBinding.toString())) {
            properties.showDynamicPortBindingWarning = true;
            properties.type = DistributedVirtualPortgroup.PortgroupType.earlyBinding.toString();
        } else {
            properties.type = dvPortgroupData.type;
            properties.showDynamicPortBindingWarning = false;
        }
    }

    private static void setPortAllocationProperties(EditDvPortgroupDialogData dvPortgroupData, EditDvPortgroupDialogProperties properties) {
        if (dvPortgroupData == null || properties == null) {
            return;
        }
        properties.autoExpand = dvPortgroupData.isUplink == false && dvPortgroupData.type != null && !dvPortgroupData.type.equals(DistributedVirtualPortgroup.PortgroupType.earlyBinding.toString()) ? true : dvPortgroupData.autoExpand;
    }

    private static void setVlanSettings(EditDvPortgroupDialogData dvPortgroupData, EditDvPortgroupDialogProperties properties) {
        if (properties == null || dvPortgroupData == null || dvPortgroupData.defaultPortConfig == null || !(dvPortgroupData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)) {
            return;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortgroupData.defaultPortConfig;
        DvpgVlanPolicyModel vlanPolicyModel = DvPortgroupPolicyParser.getVlanPolicyModel(defaultPortConfig, dvPortgroupData.pvlanConfig);
        properties.vlanType = vlanPolicyModel.vlanType;
        properties.vlanId = vlanPolicyModel.vlanId;
        properties.vlanTrunkRanges = vlanPolicyModel.vlanTrunkRanges;
        properties.vlanTrunkNumericRanges = vlanPolicyModel.vlanTrunkNumericRanges;
        properties.pvlanId = vlanPolicyModel.pvlanId;
        properties.pvlanConfig = vlanPolicyModel.pvlanConfig;
    }

    private static void setSecurityPolicy(EditDvPortgroupDialogData dvPortgroupData, EditDvPortgroupDialogProperties properties) {
        if (properties == null || dvPortgroupData == null || dvPortgroupData.isUplink.booleanValue() || dvPortgroupData.defaultPortConfig == null || !(dvPortgroupData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)) {
            return;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortgroupData.defaultPortConfig;
        VmwareDistributedVirtualSwitch.FeatureCapability capability = dvPortgroupData.dvsCapability != null ? (VmwareDistributedVirtualSwitch.FeatureCapability)dvPortgroupData.dvsCapability.featuresSupported : null;
        boolean macLearningSupported = capability != null && capability.macLearningSupported != null && capability.macLearningSupported != false;
        DvpgSecurityPolicyModel securityPolicyModel = DvPortgroupPolicyParser.getSecurityPolicyModel(defaultPortConfig, macLearningSupported);
        properties.allowPromiscuous = securityPolicyModel.allowPromiscuous;
        properties.forgedTransmits = securityPolicyModel.forgedTransmits;
        properties.macChanges = securityPolicyModel.macChanges;
        properties.macLearningEnabled = securityPolicyModel.macLearningEnabled;
        properties.allowUnicastFlooding = securityPolicyModel.allowUnicastFlooding;
        properties.limit = securityPolicyModel.limit;
        properties.limitPolicy = securityPolicyModel.limitPolicy;
        properties.macLearningSupported = securityPolicyModel.macLearningSupported;
    }

    private static void setTeamingAndFailoverPolicy(EditDvPortgroupDialogData dvPortgroupData, EditDvPortgroupDialogProperties properties) {
        if (properties == null || dvPortgroupData == null || dvPortgroupData.isUplink.booleanValue() || dvPortgroupData.defaultPortConfig == null || !(dvPortgroupData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)) {
            return;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortgroupData.defaultPortConfig;
        DvpgFailoverPolicyModel failoverPolicyModel = DvPortgroupPolicyParser.getTeamingAndFailoverPolicy(defaultPortConfig, dvPortgroupData.uplinkPortNames, dvPortgroupData.lacpGroupConfigs, dvPortgroupData.loadBalancingModes);
        properties.failoverOrder = failoverPolicyModel.failoverOrder;
        properties.loadBalancing = failoverPolicyModel.loadBalancing;
        properties.loadBalancingModes = failoverPolicyModel.loadBalancingModes;
        properties.beaconProbing = failoverPolicyModel.beaconProbing;
        properties.notifySwitches = failoverPolicyModel.notifySwitches;
        properties.rollingOrder = failoverPolicyModel.rollingOrder;
    }

    private static void setTrafficShapingPolicy(EditDvPortgroupDialogData dvPortgroupData, EditDvPortgroupDialogProperties properties) {
        if (properties == null || dvPortgroupData == null || dvPortgroupData.isUplink.booleanValue() || properties.isDvsNetworkOffloadEnabled || dvPortgroupData.defaultPortConfig == null || !(dvPortgroupData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)) {
            return;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortgroupData.defaultPortConfig;
        DvpgTrafficShapingPolicyModel trafficShapingPolicyModel = DvPortgroupPolicyParser.getTrafficShapingPolicies(defaultPortConfig);
        properties.inShapingPolicy = trafficShapingPolicyModel.inShapingPolicy;
        properties.outShapingPolicy = trafficShapingPolicyModel.outShapingPolicy;
    }

    private static void setIpfixPolicy(EditDvPortgroupDialogData dvPortgroupData, EditDvPortgroupDialogProperties properties) {
        if (properties == null || dvPortgroupData == null || dvPortgroupData.defaultPortConfig == null || !(dvPortgroupData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)) {
            return;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortgroupData.defaultPortConfig;
        DvpgMonitoringPolicyModel monitoringPolicyModel = DvPortgroupPolicyParser.getIpfixPolicy(defaultPortConfig, dvPortgroupData.ipfixCapability);
        properties.ipfixSupported = monitoringPolicyModel.ipfixSupported;
        properties.ipfixEnabled = monitoringPolicyModel.ipfixEnabled;
    }

    private static void setNetworkResourcePool(EditDvPortgroupDialogData dvPortgroupData, EditDvPortgroupDialogProperties properties) {
        boolean networkResourceManagementSupported;
        if (properties == null) {
            return;
        }
        boolean bl = networkResourceManagementSupported = dvPortgroupData.dvsCapability != null && dvPortgroupData.dvsCapability.featuresSupported != null && dvPortgroupData.dvsCapability.featuresSupported.networkResourceManagementSupported;
        if (networkResourceManagementSupported) {
            DvpgResourceAllocationPolicyModel resAllocPolicyModel = DvPortgroupPolicyParser.getResourceAllocationModel(dvPortgroupData.defaultPortConfig, dvPortgroupData.isUplink, dvPortgroupData.niocVersion, dvPortgroupData.vmVnicNetworkResourcePoolKey, dvPortgroupData.vmVnicNetworkResourcePools, dvPortgroupData.networkResourcePools);
            properties.isNetworkResourcePoolSupported = resAllocPolicyModel.isNetworkResourcePoolSupported;
            properties.isVmVnicResourcePoolSupported = resAllocPolicyModel.isVmVnicResourcePoolSupported;
            properties.networkResourcePoolKey = resAllocPolicyModel.networkResourcePoolKey;
            properties.networkResourcePools = resAllocPolicyModel.networkResourcePools;
        } else {
            properties.isNetworkResourcePoolSupported = false;
            properties.isVmVnicResourcePoolSupported = false;
            properties.networkResourcePoolKey = "-1";
            properties.networkResourcePools = new ArrayList();
        }
    }

    private static void setPortBlockedPolicy(EditDvPortgroupDialogData dvPortgroupData, EditDvPortgroupDialogProperties properties) {
        if (dvPortgroupData == null || properties == null || dvPortgroupData.defaultPortConfig == null || !(dvPortgroupData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)) {
            return;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortgroupData.defaultPortConfig;
        DvpgMiscPolicyModel miscPolicyModel = DvPortgroupPolicyParser.getPortBlockedPolicyModel(defaultPortConfig);
        properties.arePortsBlocked = miscPolicyModel.arePortsBlocked;
    }
}

