/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.ConfigSpecOperation;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.TrafficRule;
import com.vmware.vim.binding.vim.dvs.TrafficRuleset;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.EntitySpecPair;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgAddTrafficRuleSpec;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgCloneTrafficRulesSpec;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgEditRuleSequenceSpec;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgEditTrafficFilterSpec;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgEditTrafficRuleSpec;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgRemoveTrafficRuleSpec;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.DvpgTrafficFilterData;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.impl.DvpgTrafficFilterParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.impl.DvpgTrafficRuleBuilder;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.impl.DvpgTrafficRuleModelBuilder;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class DvpgTrafficFilterMutationProvider
implements MutationProvider {
    private final MutationService _mutationService;
    private final QueryBindingService _queryBindingService;

    public DvpgTrafficFilterMutationProvider(MutationService mutationService, QueryBindingService queryBindingService) {
        this._mutationService = mutationService;
        this._queryBindingService = queryBindingService;
    }

    public OperationResult apply(ManagedObjectReference dvpgRef, DvpgEditTrafficFilterSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = dvpgRef;
        DvpgTrafficFilterData trafficFilterData = (DvpgTrafficFilterData)this._queryBindingService.prepare(DvpgTrafficFilterData.class).fetch((Object)dvpgRef);
        DistributedVirtualPort.TrafficFilterConfig existingFilterConfig = DvpgTrafficRuleModelBuilder.getGenericFilterConfig(trafficFilterData.filterPolicy);
        TrafficRule[] existingRules = null;
        if (existingFilterConfig != null && existingFilterConfig.trafficRuleset != null) {
            existingRules = existingFilterConfig.trafficRuleset.rules;
        }
        DvpgEditRuleSequenceSpec[] modifiedRuleSpecs = spec.rules;
        DistributedVirtualPortgroup.ConfigSpec configSpec = this.createTrafficRulesConfigSpec(trafficFilterData, spec.isTrafficRulesetEnabled, DvpgTrafficFilterParser.updateRulesSequence(existingRules, modifiedRuleSpecs));
        return this._mutationService.apply((Object)dvpgRef, (Object)configSpec);
    }

    public OperationResult apply(ManagedObjectReference dvpgRef, DvpgCloneTrafficRulesSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = dvpgRef;
        HashSet<ManagedObjectReference> dvpgRefs = new HashSet<ManagedObjectReference>();
        dvpgRefs.add(dvpgRef);
        dvpgRefs.addAll(Arrays.asList(spec.portgroups));
        Collection trafficFilterModels = this._queryBindingService.prepare(DvpgTrafficFilterData.class).fetch(Arrays.asList(dvpgRefs.toArray(new ManagedObjectReference[dvpgRefs.size()])));
        HashMap<ManagedObjectReference, DvpgTrafficFilterData> dvpgRefToTrafficRuleModel = new HashMap<ManagedObjectReference, DvpgTrafficFilterData>();
        for (DvpgTrafficFilterData trafficFilterModel : trafficFilterModels) {
            dvpgRefToTrafficRuleModel.put((ManagedObjectReference)trafficFilterModel.provider, trafficFilterModel);
        }
        DvpgTrafficFilterData dvpgTrafficFilterModel = (DvpgTrafficFilterData)dvpgRefToTrafficRuleModel.get(dvpgRef);
        TrafficRule[] trafficRulesForCloning = null;
        boolean trafficRulesetEnabled = false;
        if (dvpgTrafficFilterModel != null) {
            trafficRulesForCloning = DvpgTrafficFilterParser.getTrafficRules(dvpgTrafficFilterModel.filterPolicy);
            trafficRulesetEnabled = DvpgTrafficFilterParser.getIsTrafficRulesetEnabled(dvpgTrafficFilterModel.filterPolicy);
        }
        ArrayList<EntitySpecPair> enitySpecPairs = new ArrayList<EntitySpecPair>();
        if (trafficRulesForCloning != null) {
            DvpgTrafficFilterParser.resetTrafficRulesKeys(trafficRulesForCloning);
            dvpgRefToTrafficRuleModel.remove(dvpgRef);
            for (Map.Entry dvpgModel : dvpgRefToTrafficRuleModel.entrySet()) {
                EntitySpecPair entitySpecPair = new EntitySpecPair();
                entitySpecPair.entity = dvpgModel.getKey();
                entitySpecPair.spec = this.createTrafficRulesConfigSpec((DvpgTrafficFilterData)dvpgModel.getValue(), trafficRulesetEnabled, trafficRulesForCloning);
                enitySpecPairs.add(entitySpecPair);
            }
        } else {
            return result;
        }
        OperationResult[] operationResults = null;
        if (!enitySpecPairs.isEmpty()) {
            operationResults = this._mutationService.applyMulti(enitySpecPairs.toArray(new EntitySpecPair[enitySpecPairs.size()]));
        }
        if (operationResults != null && operationResults.length > 0) {
            for (OperationResult operationResult : operationResults) {
                if (operationResult.error == null) continue;
                result.error = operationResult.error;
                return result;
            }
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference dvpgRef, DvpgAddTrafficRuleSpec spec) {
        DvpgTrafficFilterData trafficFilterData = (DvpgTrafficFilterData)this._queryBindingService.prepare(DvpgTrafficFilterData.class).fetch((Object)dvpgRef);
        DistributedVirtualPort.TrafficFilterConfig existingFilterConfig = DvpgTrafficRuleModelBuilder.getGenericFilterConfig(trafficFilterData.filterPolicy);
        TrafficRule[] existingRules = null;
        boolean isTrafficRulesetEnabled = false;
        if (existingFilterConfig != null && existingFilterConfig.trafficRuleset != null) {
            existingRules = existingFilterConfig.trafficRuleset.rules;
            boolean bl = isTrafficRulesetEnabled = existingFilterConfig.trafficRuleset.enabled != null && existingFilterConfig.trafficRuleset.enabled != false;
        }
        if (spec.newRule != null) {
            spec.newRule.sequence = DvpgTrafficRuleBuilder.getNextAvailableSequenceNumber(existingRules);
        }
        TrafficRule newTrafficRule = DvpgTrafficRuleBuilder.createTrafficRule(spec.newRule);
        TrafficRule[] rules = DvpgTrafficFilterParser.addTrafficRuleToExistingRules(existingRules, newTrafficRule);
        DistributedVirtualPortgroup.ConfigSpec configSpec = this.createTrafficRulesConfigSpec(trafficFilterData, isTrafficRulesetEnabled, rules);
        return this._mutationService.apply((Object)dvpgRef, (Object)configSpec);
    }

    public OperationResult apply(ManagedObjectReference dvpgRef, DvpgEditTrafficRuleSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = dvpgRef;
        if (spec.editedRule == null) {
            result.error = MixedUtil.getMethodFault((Throwable)new Exception(NetworkStringUtil.getString("trafficFilter.rulesList.noSpec")));
            return result;
        }
        DvpgTrafficFilterData trafficFilterData = (DvpgTrafficFilterData)this._queryBindingService.prepare(DvpgTrafficFilterData.class).fetch((Object)dvpgRef);
        DistributedVirtualPort.TrafficFilterConfig existingFilterConfig = DvpgTrafficRuleModelBuilder.getGenericFilterConfig(trafficFilterData.filterPolicy);
        if (existingFilterConfig == null || existingFilterConfig.trafficRuleset == null) {
            result.error = MixedUtil.getMethodFault((Throwable)new Exception(NetworkStringUtil.getString("trafficFilter.rulesList.noConfig")));
            return result;
        }
        boolean isTrafficRulesetEnabled = existingFilterConfig.trafficRuleset.enabled != null && existingFilterConfig.trafficRuleset.enabled != false;
        TrafficRule editedTrafficRule = DvpgTrafficRuleBuilder.createTrafficRule(spec.editedRule);
        TrafficRule[] rules = DvpgTrafficFilterParser.editTrafficRuleInExistingRules(existingFilterConfig.trafficRuleset.rules, editedTrafficRule);
        DistributedVirtualPortgroup.ConfigSpec configSpec = this.createTrafficRulesConfigSpec(trafficFilterData, isTrafficRulesetEnabled, rules);
        return this._mutationService.apply((Object)dvpgRef, (Object)configSpec);
    }

    public OperationResult apply(ManagedObjectReference dvpgRef, DvpgRemoveTrafficRuleSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = dvpgRef;
        DvpgTrafficFilterData trafficFilterData = (DvpgTrafficFilterData)this._queryBindingService.prepare(DvpgTrafficFilterData.class).fetch((Object)dvpgRef);
        if (trafficFilterData.filterPolicy == null || ArrayUtils.isEmpty((Object[])trafficFilterData.filterPolicy.filterConfig) || trafficFilterData.configVersion == null) {
            result.error = MixedUtil.getMethodFault((Throwable)new Exception(NetworkStringUtil.getString("trafficFilter.rulesList.noConfig")));
            return result;
        }
        DistributedVirtualPortgroup.ConfigSpec configSpec = new DistributedVirtualPortgroup.ConfigSpec();
        configSpec.configVersion = trafficFilterData.configVersion;
        configSpec.defaultPortConfig = new DistributedVirtualPort.Setting();
        DistributedVirtualPort.FilterPolicy existingFilterPolicy = trafficFilterData.filterPolicy;
        DistributedVirtualPort.TrafficFilterConfig existingFilterConfig = DvpgTrafficRuleModelBuilder.getGenericFilterConfig(trafficFilterData.filterPolicy);
        if (existingFilterConfig == null || existingFilterConfig.trafficRuleset == null) {
            result.error = MixedUtil.getMethodFault((Throwable)new Exception(NetworkStringUtil.getString("trafficFilter.rulesList.noConfig")));
            return result;
        }
        TrafficRuleset ruleSet = existingFilterConfig.trafficRuleset;
        ruleSet.rules = DvpgTrafficFilterParser.removeTrafficRuleFromExistingRules(existingFilterConfig.trafficRuleset.rules, spec.key);
        boolean isFilterConfigNeeded = existingFilterConfig.trafficRuleset.enabled != null && existingFilterConfig.trafficRuleset.enabled != false || !ArrayUtils.isEmpty((Object[])ruleSet.rules);
        String operationType = isFilterConfigNeeded ? ConfigSpecOperation.edit.name() : ConfigSpecOperation.remove.name();
        DistributedVirtualPort.TrafficFilterConfigSpec filterConfigSpec = DvpgTrafficFilterParser.createGenericFilterConfigSpec(existingFilterConfig.key, operationType, ruleSet);
        int filterConfigIndex = DvpgTrafficFilterParser.getGenericFilterConfigIndex(trafficFilterData.filterPolicy.filterConfig);
        existingFilterPolicy.filterConfig[filterConfigIndex] = filterConfigSpec;
        configSpec.defaultPortConfig.filterPolicy = existingFilterPolicy;
        return this._mutationService.apply((Object)dvpgRef, (Object)configSpec);
    }

    private DistributedVirtualPortgroup.ConfigSpec createTrafficRulesConfigSpec(DvpgTrafficFilterData trafficFilterData, boolean trafficRulesetEnabled, TrafficRule[] trafficRules) {
        DistributedVirtualPort.TrafficFilterConfig existingFilterConfig;
        if (trafficFilterData.configVersion == null) {
            return null;
        }
        String filterConfigKey = null;
        String filterConfigOperation = ConfigSpecOperation.add.name();
        int existingFilterConfigIndex = -1;
        DistributedVirtualPortgroup.ConfigSpec configSpec = new DistributedVirtualPortgroup.ConfigSpec();
        configSpec.configVersion = trafficFilterData.configVersion;
        configSpec.defaultPortConfig = new DistributedVirtualPort.Setting();
        DistributedVirtualPort.FilterPolicy existingFilterPolicy = trafficFilterData.filterPolicy;
        if (existingFilterPolicy == null) {
            existingFilterPolicy = new DistributedVirtualPort.FilterPolicy();
        }
        if (ArrayUtils.isEmpty((Object[])existingFilterPolicy.filterConfig)) {
            existingFilterPolicy.filterConfig = new DistributedVirtualPort.TrafficFilterConfig[0];
        }
        if ((existingFilterConfig = DvpgTrafficRuleModelBuilder.getGenericFilterConfig(existingFilterPolicy)) != null) {
            existingFilterConfigIndex = DvpgTrafficFilterParser.getGenericFilterConfigIndex(existingFilterPolicy.filterConfig);
            filterConfigKey = existingFilterConfig.key;
            filterConfigOperation = ConfigSpecOperation.edit.name();
        }
        TrafficRuleset ruleSet = existingFilterConfig == null || existingFilterConfig.trafficRuleset == null ? new TrafficRuleset() : existingFilterConfig.trafficRuleset;
        ruleSet.enabled = trafficRulesetEnabled;
        ruleSet.rules = trafficRules;
        DistributedVirtualPort.TrafficFilterConfigSpec filterConfigSpec = DvpgTrafficFilterParser.createGenericFilterConfigSpec(filterConfigKey, filterConfigOperation, ruleSet);
        if (existingFilterConfigIndex == -1) {
            existingFilterPolicy.filterConfig = new DistributedVirtualPort.FilterConfig[]{filterConfigSpec};
        } else {
            existingFilterPolicy.filterConfig[existingFilterConfigIndex] = filterConfigSpec;
        }
        existingFilterPolicy.inherited = false;
        configSpec.defaultPortConfig.filterPolicy = existingFilterPolicy;
        return configSpec;
    }
}

