/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.network.dvs.model.DvsConfigDetails;
import com.vmware.vsphere.client.h5.network.dvs.model.DvsConfigDetailsData;
import com.vmware.vsphere.client.h5.network.util.NetworkOffloadUtil;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsConfigPropertyProvider
implements PropertyProviderBean {
    private QueryBindingService _queryBindingService;
    private final QueryService _queryService;
    private static final Log _logger = LogFactory.getLog(DvsConfigPropertyProvider.class);

    public DvsConfigPropertyProvider(QueryBindingService queryBindingService, QueryService queryService) {
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="dvswitchproperties", property="configDataByUuid")
    public DvsConfigDetails getConfigDataByUuid(ManagedObjectReference hostRef, String switchUuid) {
        ResultSet dvsRefResult = this._queryService.select(new String[0]).from(new String[]{"AnyDistributedVirtualSwitch"}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("uuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)switchUuid), new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef.getServerGuid())}).fetch();
        if (dvsRefResult == null || dvsRefResult.getItems() == null || dvsRefResult.getItems().size() != 1) {
            return null;
        }
        ResourceItem dvpgItem = (ResourceItem)dvsRefResult.getItems().get(0);
        ManagedObjectReference dvsRef = (ManagedObjectReference)dvpgItem.getKey();
        return this.getDistributedSwitchConfigDetails(dvsRef);
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvswitchproperties", property="configdata")
    public DvsConfigDetails getDistributedSwitchConfigDetails(ManagedObjectReference dvsMor) {
        if (dvsMor == null) {
            return null;
        }
        DvsConfigDetailsData dvsData = null;
        try {
            dvsData = (DvsConfigDetailsData)this._queryBindingService.prepare(DvsConfigDetailsData.class).fetch((Object)dvsMor);
        }
        catch (Exception ex) {
            Throwable e = ExceptionUtils.getRootCause((Throwable)ex);
            if (e instanceof ManagedObjectNotFound) {
                _logger.error((Object)"Exception while trying to get dvsConfigDetailsData.Entity might have been deleted.", e);
            }
            throw ex;
        }
        if (dvsData == null) {
            return null;
        }
        DvsConfigDetails dvsDetails = new DvsConfigDetails();
        dvsDetails.name = dvsData.name;
        if (dvsData.description != null && dvsData.description.length() != 0) {
            dvsDetails.description = dvsData.description;
        }
        if (dvsData.productInfo != null) {
            dvsDetails.productVendor = dvsData.productInfo.getVendor();
            dvsDetails.productVersion = dvsData.productInfo.getVersion();
            if (!ManagedObjectUtil.isOfType((ManagedObjectReference)dvsMor, VmwareDistributedVirtualSwitch.class)) {
                dvsDetails.productBuildNumber = dvsData.productInfo.getBuild();
            }
        }
        if (dvsData.uplinkPortNames != null) {
            dvsDetails.uplinkPorts = dvsData.uplinkPortNames.length;
        }
        dvsDetails.numberOfPorts = dvsData.numberOfPorts;
        boolean isNetworkOffloadEnabled = NetworkOffloadUtil.isNetworkOffloadEnabled(dvsData.dpuCapability, dvsData.networkOffloadSpecId);
        if (isNetworkOffloadEnabled) {
            dvsDetails.networkOffloadSpecId = dvsData.networkOffloadSpecId;
        }
        if (dvsData.networkResourceManagementSupported) {
            dvsDetails.networkResourceManagementEnabled = dvsData.networkResourceManagementEnabled;
            dvsDetails.networkResourceManagementSupported = dvsData.networkResourceManagementSupported;
        }
        dvsDetails.maxMtu = dvsData.maxMtu;
        if (dvsData.multicastSnoopingSupported) {
            dvsDetails.multicastSnoopingSupported = dvsData.multicastSnoopingSupported;
            dvsDetails.multicastFilteringMode = dvsData.multicastFilteringMode;
        }
        dvsDetails.dvsCapabilities = dvsData.dvsCapability;
        if (dvsData.dvsCapability != null && dvsData.dvsCapability.defaultMaxNumPortsSupported) {
            dvsDetails.defaultProxySwitchMaxNumPorts = dvsData.defaultProxySwitchMaxNumPorts;
        }
        if (dvsData.linkDiscoveryProtocolConfig != null) {
            dvsDetails.linkDiscoveryProtocolType = dvsData.linkDiscoveryProtocolConfig.getProtocol();
            dvsDetails.linkDiscoveryProtocolOperation = dvsData.linkDiscoveryProtocolConfig.getOperation();
        }
        if (dvsData.contactInfo != null) {
            dvsDetails.contactName = dvsData.contactInfo.getName();
            dvsDetails.contact = dvsData.contactInfo.getContact();
        }
        return dvsDetails;
    }
}

