/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualE1000;
import com.vmware.vim.binding.vim.vm.device.VirtualE1000e;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualPCNet32;
import com.vmware.vim.binding.vim.vm.device.VirtualSriovEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet2;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet3;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vsphere.client.h5.network.dvs.addhost.DvsAddHostWizardUtil;
import com.vmware.vsphere.client.h5.network.dvs.addhost.data.DvsAddManageHostMigrateVmData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.data.DvsAddManageHostVmVnicData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.data.DvsAddManageHostVnicOnAllVmsData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsAddHostHostVmsModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsAddHostVmModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsVmOpaqueNetworkModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.VmDvPortgroupModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.VmVnicSettingsData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.queries.VmVnicSettingsQueryModel;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DvsAddHostVmParser {
    private static final String DIGIT_REGEX = "[0-9]";
    private static final String NON_NUMBER_REGEX = "\\D+";

    public static DvsAddManageHostMigrateVmData parseHostVms(Collection<DvsAddHostHostVmsModel> hostVmsModels) {
        if (hostVmsModels == null) {
            return new DvsAddManageHostMigrateVmData();
        }
        Object[] hostVmModelsArray = hostVmsModels.toArray(new DvsAddHostHostVmsModel[hostVmsModels.size()]);
        if (org.apache.commons.lang3.ArrayUtils.isEmpty((Object[])hostVmModelsArray)) {
            return new DvsAddManageHostMigrateVmData();
        }
        Map<String, String> portgroupNamesMap = DvsAddHostVmParser.createPortgroupNamesMap(hostVmsModels);
        DvsAddHostVmParser.sortHostsAndVms((DvsAddHostHostVmsModel[])hostVmModelsArray);
        HashMap<String, DvsAddManageHostVnicOnAllVmsData> vnicOnAllVms = new HashMap<String, DvsAddManageHostVnicOnAllVmsData>();
        ArrayList<DvsAddManageHostVmVnicData> vmVnicsList = new ArrayList<DvsAddManageHostVmVnicData>();
        for (Object hostVmsModel : hostVmModelsArray) {
            if (hostVmsModel == null || org.apache.commons.lang3.ArrayUtils.isEmpty((Object[])((DvsAddHostHostVmsModel)hostVmsModel).vm) || ((DvsAddHostHostVmsModel)hostVmsModel).provider == null) continue;
            for (DvsAddHostVmModel vmModel : ((DvsAddHostHostVmsModel)hostVmsModel).vm) {
                Object[] virtualEthernetCards;
                if (vmModel == null || vmModel.isTemplate || DvsAddHostWizardUtil.isSecondaryVm(vmModel.role) || org.apache.commons.lang3.ArrayUtils.isEmpty((Object[])(virtualEthernetCards = vmModel.getVirtualEthernetCards())) || hostVmsModel == null || ((DvsAddHostHostVmsModel)hostVmsModel).provider == null || !(((DvsAddHostHostVmsModel)hostVmsModel).provider instanceof ManagedObjectReference) || StringUtils.isEmpty((CharSequence)((DvsAddHostHostVmsModel)hostVmsModel).name)) continue;
                Arrays.sort(virtualEthernetCards, new Comparator<VirtualEthernetCard>(){

                    @Override
                    public int compare(VirtualEthernetCard a1, VirtualEthernetCard a2) {
                        if (a1.deviceInfo == null || a2.deviceInfo == null || StringUtils.isEmpty((CharSequence)a1.deviceInfo.label) || StringUtils.isEmpty((CharSequence)a2.deviceInfo.label)) {
                            return 0;
                        }
                        boolean compareLexicographically = false;
                        int nic1 = 0;
                        int nic2 = 0;
                        String nic1Prefix = a1.deviceInfo.label.replaceAll(DvsAddHostVmParser.DIGIT_REGEX, "");
                        String nic2Prefix = a2.deviceInfo.label.replaceAll(DvsAddHostVmParser.DIGIT_REGEX, "");
                        String nic1IndexString = a1.deviceInfo.label.replaceAll(DvsAddHostVmParser.NON_NUMBER_REGEX, "");
                        String nic2IndexString = a2.deviceInfo.label.replaceAll(DvsAddHostVmParser.NON_NUMBER_REGEX, "");
                        if (StringUtils.isEmpty((CharSequence)nic1Prefix) || StringUtils.isEmpty((CharSequence)nic2Prefix)) {
                            compareLexicographically = true;
                        } else {
                            int prefixComparison = nic1Prefix.compareTo(nic2Prefix);
                            if (prefixComparison != 0) {
                                compareLexicographically = true;
                            } else {
                                try {
                                    nic1 = Integer.parseInt(nic1IndexString);
                                    nic2 = Integer.parseInt(nic2IndexString);
                                }
                                catch (NumberFormatException nfe) {
                                    compareLexicographically = true;
                                }
                            }
                        }
                        if (compareLexicographically) {
                            return a1.deviceInfo.label.compareTo(a2.deviceInfo.label);
                        }
                        return nic1 < nic2 ? -1 : (nic1 == nic2 ? 0 : 1);
                    }
                });
                for (Object virtualEthernetCard : virtualEthernetCards) {
                    DvsAddManageHostVmVnicData vmVnicData = DvsAddHostVmParser.createVnicItem(vmModel, (VirtualEthernetCard)virtualEthernetCard, (ManagedObjectReference)((DvsAddHostHostVmsModel)hostVmsModel).provider, portgroupNamesMap);
                    if (vmVnicData == null) continue;
                    vmVnicsList.add(vmVnicData);
                    if (!vnicOnAllVms.containsKey(((VirtualEthernetCard)virtualEthernetCard).deviceInfo.label)) {
                        vnicOnAllVms.put(((VirtualEthernetCard)virtualEthernetCard).deviceInfo.label, new DvsAddManageHostVnicOnAllVmsData(((VirtualEthernetCard)virtualEthernetCard).deviceInfo.label));
                    }
                    if (vmVnicData.showWarning) {
                        ((DvsAddManageHostVnicOnAllVmsData)vnicOnAllVms.get((Object)((VirtualEthernetCard)virtualEthernetCard).deviceInfo.label)).showWarning = true;
                    }
                    ++((DvsAddManageHostVnicOnAllVmsData)vnicOnAllVms.get((Object)((VirtualEthernetCard)virtualEthernetCard).deviceInfo.label)).vnicsNumber;
                    ++((DvsAddManageHostVnicOnAllVmsData)vnicOnAllVms.get((Object)((VirtualEthernetCard)virtualEthernetCard).deviceInfo.label)).vmsNumber;
                }
            }
        }
        DvsAddManageHostMigrateVmData migrateVmData = new DvsAddManageHostMigrateVmData();
        migrateVmData.vmVnics = vmVnicsList.toArray(new DvsAddManageHostVmVnicData[vmVnicsList.size()]);
        DvsAddManageHostVnicOnAllVmsData[] vnicOnAllVmsArray = new DvsAddManageHostVnicOnAllVmsData[vnicOnAllVms.size()];
        int index = 0;
        Iterator iterator = vnicOnAllVms.values().iterator();
        while (iterator.hasNext()) {
            DvsAddManageHostVnicOnAllVmsData value;
            vnicOnAllVmsArray[index] = value = (DvsAddManageHostVnicOnAllVmsData)iterator.next();
            ++index;
        }
        migrateVmData.vnicOnAllVms = vnicOnAllVmsArray;
        return migrateVmData;
    }

    public static List<VmVnicSettingsData> parseVmVnicsSettings(VmVnicSettingsQueryModel vmVnicSettingsQueryModel) {
        ArrayList<VmVnicSettingsData> vmVnicSettingsDataItems = new ArrayList<VmVnicSettingsData>();
        if (vmVnicSettingsQueryModel != null && !ArrayUtils.isEmpty((Object[])vmVnicSettingsQueryModel.device)) {
            for (VirtualDevice device : vmVnicSettingsQueryModel.device) {
                if (!(device instanceof VirtualEthernetCard)) continue;
                VirtualEthernetCard virtualEthernetCard = (VirtualEthernetCard)device;
                VmVnicSettingsData vmVnicSettingsData = new VmVnicSettingsData();
                vmVnicSettingsData.key = device.key;
                if (virtualEthernetCard.deviceInfo != null) {
                    vmVnicSettingsData.adapterName = virtualEthernetCard.deviceInfo.label;
                }
                vmVnicSettingsData.macAddress = virtualEthernetCard.macAddress;
                vmVnicSettingsData.adapterType = DvsAddHostVmParser.getAdapterType(virtualEthernetCard);
                vmVnicSettingsData.sriovInfo = DvsAddHostVmParser.getSriovInfo(virtualEthernetCard);
                HashMap<String, String> portgroupsNameMap = new HashMap<String, String>();
                DvsAddHostVmParser.addPortgroupsToMap(portgroupsNameMap, vmVnicSettingsQueryModel.distributedPortgroups);
                vmVnicSettingsData.portgroupName = DvsAddHostVmParser.getPortgroupName(virtualEthernetCard, portgroupsNameMap, vmVnicSettingsQueryModel.opaqueNetworks);
                vmVnicSettingsDataItems.add(vmVnicSettingsData);
            }
        }
        return vmVnicSettingsDataItems;
    }

    private static VmVnicSettingsData.SriovInfo getSriovInfo(VirtualEthernetCard device) {
        VmVnicSettingsData.SriovInfo sriovInfo = null;
        if (device instanceof VirtualSriovEthernetCard) {
            sriovInfo = new VmVnicSettingsData.SriovInfo();
            VirtualSriovEthernetCard sriovEthernetCard = (VirtualSriovEthernetCard)device;
            sriovInfo.allowGuestOsMtuChange = sriovEthernetCard.allowGuestOSMtuChange;
            VirtualSriovEthernetCard.SriovBackingInfo sriovBacking = sriovEthernetCard.sriovBacking;
            if (sriovEthernetCard.sriovBacking != null) {
                if (sriovBacking.virtualFunctionBacking != null && sriovBacking.virtualFunctionBacking.id != null) {
                    sriovInfo.virtualFunctionId = sriovBacking.virtualFunctionBacking.id;
                }
                if (sriovBacking.physicalFunctionBacking != null) {
                    sriovInfo.physicalFunctionDeviceId = sriovBacking.physicalFunctionBacking.deviceId;
                    sriovInfo.physicalFunctionId = sriovBacking.physicalFunctionBacking.id;
                }
            }
        }
        return sriovInfo;
    }

    private static String getAdapterType(VirtualEthernetCard adapter) {
        String adapterType = adapter instanceof VirtualVmxnet ? (adapter instanceof VirtualVmxnet3 ? NetworkStringUtil.getString("VnicType.vmxnet3") : (adapter instanceof VirtualVmxnet2 ? NetworkStringUtil.getString("VnicType.vmxnet2") : NetworkStringUtil.getString("VnicType.vmxnet"))) : (adapter instanceof VirtualE1000 ? NetworkStringUtil.getString("VnicType.e1000") : (adapter instanceof VirtualPCNet32 ? NetworkStringUtil.getString("VnicType.pcNet32") : (adapter instanceof VirtualE1000e ? NetworkStringUtil.getString("VnicType.e1000e") : (adapter instanceof VirtualSriovEthernetCard ? NetworkStringUtil.getString("VnicType.sriovPassthru") : NetworkStringUtil.getString("VnicType.unrecognized")))));
        return adapterType;
    }

    private static Map<String, String> createPortgroupNamesMap(Collection<DvsAddHostHostVmsModel> hostVmsModels) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (DvsAddHostHostVmsModel hostVmsModel : hostVmsModels) {
            if (hostVmsModel == null || hostVmsModel.vm == null) continue;
            for (DvsAddHostVmModel vmModel : hostVmsModel.vm) {
                if (vmModel == null) continue;
                DvsAddHostVmParser.addPortgroupsToMap(result, vmModel.distributedPortgroups);
            }
        }
        return result;
    }

    private static void addPortgroupsToMap(Map<String, String> portgroupNamesMap, VmDvPortgroupModel[] distributedPortgroups) {
        if (distributedPortgroups != null) {
            for (VmDvPortgroupModel portgroupModel : distributedPortgroups) {
                if (portgroupModel == null || portgroupModel.dvsUuid == null || portgroupModel.key == null) continue;
                String uniquePortgroupKey = DvsAddHostVmParser.getUniquePortgroupKey(portgroupModel.key, portgroupModel.dvsUuid);
                portgroupNamesMap.put(uniquePortgroupKey, portgroupModel.name);
            }
        }
    }

    private static String getUniquePortgroupKey(String portgroupKey, String dvsUuid) {
        if (portgroupKey == null || dvsUuid == null) {
            return null;
        }
        return dvsUuid + portgroupKey;
    }

    private static DvsAddManageHostVmVnicData createVnicItem(DvsAddHostVmModel vmModel, VirtualEthernetCard virtualEthernetCard, ManagedObjectReference hostRef, Map<String, String> portgroupNamesMap) {
        if (virtualEthernetCard == null || virtualEthernetCard.deviceInfo == null || StringUtils.isEmpty((CharSequence)virtualEthernetCard.deviceInfo.label)) {
            return null;
        }
        String sourcePortgroupName = DvsAddHostVmParser.getPortgroupName(virtualEthernetCard, portgroupNamesMap, vmModel.opaqueNetworks);
        return new DvsAddManageHostVmVnicData(virtualEthernetCard.deviceInfo.label, vmModel.name, sourcePortgroupName, vmModel.changeVersion, virtualEthernetCard.key, (ManagedObjectReference)vmModel.provider, hostRef, DvsAddHostWizardUtil.isPrimaryVm(vmModel.role));
    }

    private static String getPortgroupName(VirtualEthernetCard virtualEthernetCard, Map<String, String> portgroupNamesMap, DvsVmOpaqueNetworkModel[] opaqueNetworkModels) {
        String sourcePortgroupName = null;
        if (virtualEthernetCard.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) {
            VirtualEthernetCard.DistributedVirtualPortBackingInfo dvPortBacking = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)virtualEthernetCard.backing;
            if (dvPortBacking.port != null) {
                if (StringUtils.isNotEmpty((CharSequence)dvPortBacking.port.portgroupKey)) {
                    String pgKey = dvPortBacking.port.portgroupKey;
                    String switchUuid = dvPortBacking.port.switchUuid;
                    String uniquePortgroupKey = DvsAddHostVmParser.getUniquePortgroupKey(pgKey, switchUuid);
                    sourcePortgroupName = portgroupNamesMap.get(uniquePortgroupKey);
                } else if (StringUtils.isNotEmpty((CharSequence)dvPortBacking.port.portKey)) {
                    sourcePortgroupName = NetworkStringUtil.getString("SelectVirtualMachinesPage.portId", dvPortBacking.port.portKey);
                }
            }
        } else if (virtualEthernetCard.backing instanceof VirtualEthernetCard.NetworkBackingInfo) {
            VirtualEthernetCard.NetworkBackingInfo networkBackingInfo = (VirtualEthernetCard.NetworkBackingInfo)virtualEthernetCard.backing;
            sourcePortgroupName = networkBackingInfo.deviceName;
        } else if (virtualEthernetCard.backing instanceof VirtualEthernetCard.OpaqueNetworkBackingInfo) {
            VirtualEthernetCard.OpaqueNetworkBackingInfo opaqueNetworkBackingInfo = (VirtualEthernetCard.OpaqueNetworkBackingInfo)virtualEthernetCard.backing;
            sourcePortgroupName = DvsAddHostVmParser.getOpaqueNetworkName(opaqueNetworkBackingInfo, opaqueNetworkModels);
        }
        return sourcePortgroupName;
    }

    private static String getOpaqueNetworkName(VirtualEthernetCard.OpaqueNetworkBackingInfo vnicBacking, DvsVmOpaqueNetworkModel[] opaqueNetworks) {
        String name = null;
        if (vnicBacking == null || opaqueNetworks == null) {
            return name;
        }
        for (DvsVmOpaqueNetworkModel dvsVmOpaqueNetworkModel : opaqueNetworks) {
            if (dvsVmOpaqueNetworkModel == null || vnicBacking.opaqueNetworkId == null || !vnicBacking.opaqueNetworkId.equals(dvsVmOpaqueNetworkModel.opaqueNetworkId) || vnicBacking.opaqueNetworkType == null || !vnicBacking.opaqueNetworkType.equals(dvsVmOpaqueNetworkModel.opaqueNetworkType)) continue;
            name = dvsVmOpaqueNetworkModel.name;
            break;
        }
        return name;
    }

    private static void sortHostsAndVms(DvsAddHostHostVmsModel[] hostVmsModelsArray) {
        Arrays.sort(hostVmsModelsArray, new Comparator<DvsAddHostHostVmsModel>(){

            @Override
            public int compare(DvsAddHostHostVmsModel host1, DvsAddHostHostVmsModel host2) {
                if (host1 == null || host2 == null) {
                    return 0;
                }
                return ObjectUtil.compare((Comparable)((Object)host1.name), (Comparable)((Object)host2.name));
            }
        });
        for (DvsAddHostHostVmsModel hostVmsModel : hostVmsModelsArray) {
            if (hostVmsModel == null || hostVmsModel.vm == null) continue;
            Arrays.sort(hostVmsModel.vm, new Comparator<DvsAddHostVmModel>(){

                @Override
                public int compare(DvsAddHostVmModel vm1, DvsAddHostVmModel vm2) {
                    if (vm1 == null || vm2 == null) {
                        return 0;
                    }
                    return ObjectUtil.compare((Comparable)((Object)vm1.name), (Comparable)((Object)vm2.name));
                }
            });
        }
    }
}

