/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.create;

import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsCreateCommandSpec;
import com.vmware.vsphere.client.h5.network.dvs.create.DvsCreateWizardSpecBuilder;
import com.vmware.vsphere.client.h5.network.dvs.create.model.DvsCreateWizardMutationSpec;
import java.util.ArrayList;

public class DvsCreateWizardMutationProvider
implements MutationProvider {
    private final MutationService _mutationService;

    public DvsCreateWizardMutationProvider(MutationService mutationService) {
        this._mutationService = mutationService;
    }

    public OperationResult add(DvsCreateWizardMutationSpec spec) {
        if (spec.parentEntityMor == null) {
            throw new IllegalArgumentException("Parent entity not provided");
        }
        if (spec.uniqueDvsName == null) {
            throw new IllegalArgumentException("DVS name not provided");
        }
        if (spec.selectedVersion == null) {
            throw new IllegalArgumentException("DVS version not provided");
        }
        if (spec.numberOfUplinks < 1 || spec.numberOfUplinks > 32) {
            throw new IllegalArgumentException("The number of uplinks must be between 1 and 32");
        }
        DvsCreateWizardSpecBuilder specBuilder = new DvsCreateWizardSpecBuilder();
        DvsCreateCommandSpec dvsCreateCommandSpec = specBuilder.buildDvsCreateCommandSpec(spec);
        ArrayList<Object> dependentSpecs = new ArrayList<Object>(2);
        if (spec.niocEnabled) {
            dependentSpecs.add(specBuilder.buildDvsChangeResMgmtCommandSpec());
        }
        if (spec.createDefaultPortgroup) {
            dependentSpecs.add(specBuilder.buildDvsCreatePortgroupCommandSpec(spec.defaultPortgroupName));
        }
        if (!dependentSpecs.isEmpty()) {
            dvsCreateCommandSpec.dependentSpecs = dependentSpecs.toArray(new BaseCommandSpec[dependentSpecs.size()]);
        }
        return this._mutationService.add((Object)dvsCreateCommandSpec);
    }
}

