/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.create;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.ProductSpec;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vsphere.client.dvs.api.spec.DvsChangeResMgmtCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsCreateCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsCreatePortgroupCommandSpec;
import com.vmware.vsphere.client.h5.network.dvs.create.model.DvsCreateWizardMutationSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;

public class DvsCreateWizardSpecBuilder {
    private static final String DEFAULT_PORT_BINDING = DistributedVirtualPortgroup.PortgroupType.earlyBinding.toString();
    private static final int DEFAULT_NUMBER_OF_PORTS = 8;

    public DvsCreateCommandSpec buildDvsCreateCommandSpec(DvsCreateWizardMutationSpec spec) {
        DvsCreateCommandSpec dvsCreateCommandSpec = new DvsCreateCommandSpec();
        dvsCreateCommandSpec.mor = spec.parentEntityMor;
        dvsCreateCommandSpec.createSpec = new DistributedVirtualSwitch.CreateSpec();
        dvsCreateCommandSpec.createSpec.productInfo = new ProductSpec();
        dvsCreateCommandSpec.createSpec.productInfo.version = spec.selectedVersion;
        dvsCreateCommandSpec.createSpec.configSpec = new VmwareDistributedVirtualSwitch.ConfigSpec();
        dvsCreateCommandSpec.createSpec.configSpec.name = spec.uniqueDvsName;
        if (spec.networkOffloadSpecId != null) {
            ((VmwareDistributedVirtualSwitch.ConfigSpec)dvsCreateCommandSpec.createSpec.configSpec).networkOffloadSpecId = spec.networkOffloadSpecId;
        }
        dvsCreateCommandSpec.createSpec.configSpec.networkResourceControlVersion = this.getNiocVersion(spec.selectedVersion);
        ((VmwareDistributedVirtualSwitch.ConfigSpec)dvsCreateCommandSpec.createSpec.configSpec).lacpApiVersion = this.getLacpApiVersion(spec.selectedVersion);
        dvsCreateCommandSpec.createSpec.configSpec.uplinkPortPolicy = this.getUplinkPortPolicy(spec.numberOfUplinks);
        return dvsCreateCommandSpec;
    }

    public DvsChangeResMgmtCommandSpec buildDvsChangeResMgmtCommandSpec() {
        DvsChangeResMgmtCommandSpec spec = new DvsChangeResMgmtCommandSpec();
        spec.isResMgmtEnabled = true;
        return spec;
    }

    public DvsCreatePortgroupCommandSpec buildDvsCreatePortgroupCommandSpec(String name) {
        DvsCreatePortgroupCommandSpec spec = new DvsCreatePortgroupCommandSpec();
        spec.configSpec = new DistributedVirtualPortgroup.ConfigSpec();
        spec.configSpec.name = name;
        spec.configSpec.type = DEFAULT_PORT_BINDING;
        spec.configSpec.autoExpand = true;
        spec.configSpec.numPorts = 8;
        return spec;
    }

    private String getNiocVersion(String dvsVersion) {
        VersionComparator comparator = new VersionComparator(dvsVersion);
        if (comparator.isGreaterThanOrEqualTo("5.0.0") && comparator.isLesserThanOrEqualTo("5.5.0")) {
            return DistributedVirtualSwitch.NetworkResourceControlVersion.version2.toString();
        }
        if (comparator.isGreaterThanOrEqualTo("6.0.0")) {
            return DistributedVirtualSwitch.NetworkResourceControlVersion.version3.toString();
        }
        return null;
    }

    private String getLacpApiVersion(String dvsVersion) {
        VersionComparator comparator = new VersionComparator(dvsVersion);
        if (comparator.isEqualTo("5.1.0")) {
            return VmwareDistributedVirtualSwitch.LacpApiVersion.singleLag.toString();
        }
        if (comparator.isGreaterThanOrEqualTo("5.5.0")) {
            return VmwareDistributedVirtualSwitch.LacpApiVersion.multipleLag.toString();
        }
        return null;
    }

    private DistributedVirtualSwitch.UplinkPortPolicy getUplinkPortPolicy(int numberOfUplinks) {
        ArrayList<String> uplinkPortNames = new ArrayList<String>(numberOfUplinks);
        String uplinkNameTemplate = NetworkStringUtil.getString("dvs.uplink.nameTemplate");
        for (int i = 0; i < numberOfUplinks; ++i) {
            uplinkPortNames.add(i, uplinkNameTemplate.replaceAll("\\{0\\}", Integer.toString(i + 1)));
        }
        DistributedVirtualSwitch.NameArrayUplinkPortPolicy policy = new DistributedVirtualSwitch.NameArrayUplinkPortPolicy();
        policy.uplinkPortName = uplinkPortNames.toArray(new String[uplinkPortNames.size()]);
        return policy;
    }

    private class VersionComparator {
        private String _version;

        VersionComparator(String version) {
            if (version == null) {
                throw new IllegalArgumentException("Version cannot be null");
            }
            this._version = version;
        }

        boolean isGreaterThanOrEqualTo(String target) {
            return this.compare(this._version, target) >= 0;
        }

        boolean isLesserThanOrEqualTo(String target) {
            return this.compare(this._version, target) <= 0;
        }

        boolean isEqualTo(String target) {
            return this.compare(this._version, target) == 0;
        }

        private int compare(String a, String b) {
            String splitter = "\\.";
            String[] aParts = a.split(splitter);
            String[] bParts = b.split(splitter);
            for (int i = 0; i < Math.min(aParts.length, bParts.length); ++i) {
                if (Integer.valueOf(aParts[i]) < Integer.valueOf(bParts[i])) {
                    return -1;
                }
                if (Integer.valueOf(aParts[i]) <= Integer.valueOf(bParts[i])) continue;
                return 1;
            }
            if (aParts.length == bParts.length) {
                return 0;
            }
            return aParts.length > bParts.length ? 1 : -1;
        }
    }
}

