/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.diagram;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwitchDiagramVmsFilterBuilder
implements QueryFilterBuilder {
    static final String PROPERTY_DVS = "dvs";
    private static final Log _logger = LogFactory.getLog(SwitchDiagramVmsFilterBuilder.class);
    private final ObjectReferenceService _objectReferenceService;

    public SwitchDiagramVmsFilterBuilder(ObjectReferenceService objectReferenceService) {
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="dvsVmsRelatedObjectsFilter")
    public Filter dvsVmsRelatedObjectsFilter(String objectId) {
        Validate.notNull((Object)objectId);
        Object dvsRef = this.getRef(objectId);
        if (dvsRef == null) {
            return null;
        }
        PropertyPredicate vmsConnectedToDvsPredicate = new PropertyPredicate(PROPERTY_DVS, PropertyPredicate.ComparisonOperator.EQUAL, dvsRef);
        List<PropertyPredicate> predicateList = Arrays.asList(vmsConnectedToDvsPredicate);
        return new Filter(predicateList);
    }

    @QueryFilter(value="dvsVmsRelatedObjectsExcludedFilter")
    public Filter dvsVmsRelatedObjectsExcludedFilter(String dvsId, String[] vmsIds) {
        Validate.notNull((Object)dvsId);
        Validate.notNull((Object)vmsIds);
        Validate.isTrue((vmsIds.length == 0 || StringUtils.isNoneBlank((CharSequence[])vmsIds) ? 1 : 0) != 0);
        Object dvsRef = this._objectReferenceService.getReference(dvsId, true);
        if (dvsRef == null) {
            return null;
        }
        PropertyPredicate vmsConnectedToDvsPredicate = new PropertyPredicate(PROPERTY_DVS, PropertyPredicate.ComparisonOperator.EQUAL, dvsRef);
        ArrayList<Object> vmObjects = new ArrayList<Object>(vmsIds.length);
        for (String vmObjectId : vmsIds) {
            vmObjects.add(this._objectReferenceService.getReference(vmObjectId, true));
        }
        PropertyPredicate excludedVmsPredicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.NOT_IN, vmObjects);
        List<PropertyPredicate> predicateList = Arrays.asList(vmsConnectedToDvsPredicate, excludedVmsPredicate);
        return new Filter(predicateList);
    }

    private Object getRef(String objectId) {
        Object objectRef = this._objectReferenceService.getReference(objectId, true);
        if (objectRef == null) {
            _logger.warn((Object)"No valid object ref found for filter");
            return null;
        }
        return objectRef;
    }
}

