/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.healthcheck;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.model.DvsHealthCheckSettingsData;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.model.DvsHealthCheckSettingsQueryBinding;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import org.apache.commons.lang.ArrayUtils;

public class DvsHealthCheckManagePropertyProvider
implements PropertyProviderBean {
    private QueryBindingService _queryBindingService;

    public DvsHealthCheckManagePropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsHealthCheckManage", property="dvsHealthCheckSettingsData")
    public DvsHealthCheckSettingsData getDvsHealthCheckSettingsData(ManagedObjectReference dvsMor) {
        DvsHealthCheckSettingsQueryBinding dvsHealthCheckSettingsQueryBinding = (DvsHealthCheckSettingsQueryBinding)this._queryBindingService.prepare(DvsHealthCheckSettingsQueryBinding.class).fetch((Object)dvsMor);
        DvsHealthCheckSettingsData dvsHealthCheckSettingsData = new DvsHealthCheckSettingsData();
        if (dvsHealthCheckSettingsQueryBinding != null && ArrayUtils.isNotEmpty((Object[])dvsHealthCheckSettingsQueryBinding.healthCheckConfig) && dvsHealthCheckSettingsQueryBinding.name != null) {
            dvsHealthCheckSettingsData.name = dvsHealthCheckSettingsQueryBinding.name;
            for (DistributedVirtualSwitch.HealthCheckConfig config : dvsHealthCheckSettingsQueryBinding.healthCheckConfig) {
                if (config == null || config.enable == null) continue;
                if (config instanceof VmwareDistributedVirtualSwitch.VlanMtuHealthCheckConfig) {
                    dvsHealthCheckSettingsData.vlanMtuEnabled = config.enable;
                    dvsHealthCheckSettingsData.vlanMtuEnabledLabel = config.enable != false ? NetworkStringUtil.getString("enabled") : NetworkStringUtil.getString("disabled");
                    dvsHealthCheckSettingsData.vlanMtuInterval = config.interval;
                }
                if (!(config instanceof VmwareDistributedVirtualSwitch.TeamingHealthCheckConfig)) continue;
                dvsHealthCheckSettingsData.teamingAndFailoverEnabled = config.enable;
                dvsHealthCheckSettingsData.teamingAndFailoverEnabledLabel = config.enable != false ? NetworkStringUtil.getString("enabled") : NetworkStringUtil.getString("disabled");
                dvsHealthCheckSettingsData.teamingAndFailoverInterval = config.interval;
            }
        }
        dvsHealthCheckSettingsData.vlanMtuEnabledLabel = dvsHealthCheckSettingsData.vlanMtuEnabledLabel != null ? dvsHealthCheckSettingsData.vlanMtuEnabledLabel : NetworkStringUtil.getString("na");
        dvsHealthCheckSettingsData.teamingAndFailoverEnabledLabel = dvsHealthCheckSettingsData.teamingAndFailoverEnabledLabel != null ? dvsHealthCheckSettingsData.teamingAndFailoverEnabledLabel : NetworkStringUtil.getString("na");
        return dvsHealthCheckSettingsData;
    }
}

