/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.lacp;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.vim.binding.vim.ConfigSpecOperation;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vsphere.client.h5.network.dvs.lacp.spec.LacpConfigSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Arrays;

public class LacpMutationProvider
implements MutationProvider {
    private static final String LACP_GROUP_CONFIG_PROPERTY = "config.lacpGroupConfig";
    private QueryService queryService;

    public LacpMutationProvider(QueryService queryService) {
        this.queryService = queryService;
    }

    public ValidationResult validate(ManagedObjectReference dvsRef, LacpConfigSpec spec) {
        ArrayList<String> errors;
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = dvsRef;
        validationResult.result = errors = new ArrayList<String>();
        VmwareDistributedVirtualSwitch.LacpGroupConfig[] lacpGroupConfigs = (VmwareDistributedVirtualSwitch.LacpGroupConfig[])((ResourceItem)this.queryService.select(new String[]{LACP_GROUP_CONFIG_PROPERTY}).from(new String[]{dvsRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsRef)}).fetch().getItems().get(0)).get(LACP_GROUP_CONFIG_PROPERTY);
        if (this.isNameDuplicate(lacpGroupConfigs, spec.groups[0])) {
            errors.add(NetworkStringUtil.getString("lag.name.nameDuplicate"));
        }
        return validationResult;
    }

    private boolean isNameDuplicate(VmwareDistributedVirtualSwitch.LacpGroupConfig[] lacpGroupConfigs, final VmwareDistributedVirtualSwitch.LacpGroupSpec lagSpec) {
        if (lacpGroupConfigs == null) {
            lacpGroupConfigs = new VmwareDistributedVirtualSwitch.LacpGroupConfig[]{};
        }
        Iterable<Object> lacpGroupConfigList = Arrays.asList(lacpGroupConfigs);
        if (lagSpec.operation.equals(ConfigSpecOperation.edit.name())) {
            lacpGroupConfigList = Iterables.filter(lacpGroupConfigList, (Predicate)new Predicate<VmwareDistributedVirtualSwitch.LacpGroupConfig>(){

                public boolean apply(VmwareDistributedVirtualSwitch.LacpGroupConfig lacpGroupConfig) {
                    return !lagSpec.lacpGroupConfig.key.equals(lacpGroupConfig.key);
                }
            });
        }
        return Iterables.any(lacpGroupConfigList, (Predicate)new Predicate<VmwareDistributedVirtualSwitch.LacpGroupConfig>(){

            public boolean apply(VmwareDistributedVirtualSwitch.LacpGroupConfig lacpGroupConfig) {
                return lagSpec.lacpGroupConfig.name.equals(lacpGroupConfig.name);
            }
        });
    }
}

