/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.offloads;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vsphere.client.h5.network.dvs.offloads.DvpgOffloadsData;
import com.vmware.vsphere.client.h5.network.util.NetworkOffloadUtil;

public class NetworkOffloadsPropertyProvider {
    public static final String OFFLOAD_SPEC_ID_NONE = "NONE";
    private final QueryBindingService _queryBindingService;

    public NetworkOffloadsPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @DerivedProperty(value="VmwareDistributedVirtualSwitch/networkOffloadsEnabled")
    public static boolean networkOffloadsEnabled(@SourceProperty(value="VmwareDistributedVirtualSwitch/config/networkOffloadSpecId") String networkOffloadSpecId, @SourceProperty(value="VmwareDistributedVirtualSwitch/capability/featuresSupported/dpuCapability") VmwareDistributedVirtualSwitch.DpuFeatureCapability dpuCapability) {
        return NetworkOffloadUtil.isNetworkOffloadEnabled(dpuCapability, networkOffloadSpecId);
    }

    @PropertyProvider(value="DistributedVirtualPortgroup/dvsNetworkOffloadsEnabled")
    public boolean dvsNetworkOffloadsEnabled(Object dvpgRef) {
        DvpgOffloadsData offloadsData = (DvpgOffloadsData)((Object)this._queryBindingService.prepare(DvpgOffloadsData.class).fetch(dvpgRef));
        if (offloadsData != null && offloadsData.networkOffloadsEnabled != null) {
            return offloadsData.networkOffloadsEnabled;
        }
        return false;
    }
}

