/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.portmirroring;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationOperationSpec;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvs.api.spec.DvsConfigSpec;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.wizard.DvsAddSpanSessionSpec;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.wizard.DvsSpanSessionNameSpec;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.wizard.DvsSpanSessionsQueryBinding;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.io.UnsupportedEncodingException;

public class DvsAddSpanSessionWizardMutationProvider
implements MutationProvider {
    private static final String UTF_8 = "UTF-8";
    private static final int NAME_MAX_LENGTH_BYTES = 254;
    private static final String PROPERTY_CONFIG_VERSION = "config.configVersion";
    private final MutationService _mutationService;
    private final QueryBindingService _queryBindingService;
    private final QueryExecutor _queryExecutor;

    public DvsAddSpanSessionWizardMutationProvider(MutationService mutationService, QueryBindingService queryBindingService, QueryExecutor queryExecutor) {
        this._mutationService = mutationService;
        this._queryExecutor = queryExecutor;
        this._queryBindingService = queryBindingService;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsAddSpanSessionSpec spec) throws Exception {
        String configVersion = (String)this._queryExecutor.getProperty((Object)dvsRef, PROPERTY_CONFIG_VERSION);
        DvsConfigSpec dvsConfigSpec = new DvsConfigSpec();
        dvsConfigSpec.configSpec = new VmwareDistributedVirtualSwitch.ConfigSpec();
        dvsConfigSpec.configSpec.configVersion = configVersion;
        VmwareDistributedVirtualSwitch.VspanSession newSession = new VmwareDistributedVirtualSwitch.VspanSession();
        newSession.name = spec.sessionName;
        newSession.sessionType = spec.sessionType;
        newSession.enabled = spec.enabled;
        newSession.mirroredPacketLength = spec.mirroredPacketLength;
        newSession.samplingRate = spec.samplingRate;
        newSession.description = spec.description;
        if (VmwareDistributedVirtualSwitch.VspanSessionType.encapsulatedRemoteMirrorSource.name().equals(spec.sessionType)) {
            this.setL3SourceSessionProperties(newSession, spec);
        }
        if (VmwareDistributedVirtualSwitch.VspanSessionType.remoteMirrorSource.name().equals(spec.sessionType)) {
            this.setRemoteSourceSessionProperties(newSession, spec);
        }
        if (VmwareDistributedVirtualSwitch.VspanSessionType.dvPortMirror.name().equals(spec.sessionType)) {
            this.setDvPortSessionProperties(newSession, spec);
        }
        if (VmwareDistributedVirtualSwitch.VspanSessionType.remoteMirrorDest.name().equals(spec.sessionType)) {
            this.setRemoteDestSessionProperties(newSession, spec);
        }
        VmwareDistributedVirtualSwitch.VspanConfigSpec vspanConfigSpec = new VmwareDistributedVirtualSwitch.VspanConfigSpec();
        vspanConfigSpec.vspanSession = newSession;
        vspanConfigSpec.operation = MutationOperationSpec.Operation.add.toString();
        dvsConfigSpec.configSpec.vspanConfigSpec = new VmwareDistributedVirtualSwitch.VspanConfigSpec[]{vspanConfigSpec};
        return this._mutationService.apply((Object)dvsRef, (Object)dvsConfigSpec);
    }

    public ValidationResult validate(ManagedObjectReference dvsRef, DvsSpanSessionNameSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = dvsRef;
        if (spec.name == null) {
            return validationResult;
        }
        byte[] byteArray = null;
        try {
            byteArray = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.name).getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return validationResult;
        }
        if (byteArray != null && byteArray.length > 254) {
            validationResult.result = NetworkStringUtil.getString("dvsPortMirror.name.tooLong");
            return validationResult;
        }
        DvsSpanSessionsQueryBinding queryBinding = (DvsSpanSessionsQueryBinding)this._queryBindingService.prepare(DvsSpanSessionsQueryBinding.class).fetch((Object)dvsRef);
        if (queryBinding != null && !this.isNameUnique(spec.name, queryBinding.vspanSessions)) {
            validationResult.result = NetworkStringUtil.getString("dvsPortMirror.name.duplicate");
        }
        return validationResult;
    }

    private void setL3SourceSessionProperties(VmwareDistributedVirtualSwitch.VspanSession session, DvsAddSpanSessionSpec spec) {
        session.encapType = spec.encapsulationType;
        session.netstack = spec.tcpIpStack;
        if (!VmwareDistributedVirtualSwitch.VspanSessionEncapType.gre.equals((Object)VmwareDistributedVirtualSwitch.VspanSessionEncapType.valueOf((String)spec.encapsulationType))) {
            session.erspanId = spec.sessionId;
        }
        session.sourcePortReceived = new VmwareDistributedVirtualSwitch.VspanPorts();
        session.sourcePortReceived.portKey = spec.sourcePortsIngress;
        session.sourcePortTransmitted = new VmwareDistributedVirtualSwitch.VspanPorts();
        session.sourcePortTransmitted.portKey = spec.sourcePortsEgress;
        session.destinationPort = new VmwareDistributedVirtualSwitch.VspanPorts();
        session.destinationPort.ipAddress = spec.destinationIps;
    }

    private void setRemoteSourceSessionProperties(VmwareDistributedVirtualSwitch.VspanSession session, DvsAddSpanSessionSpec spec) {
        session.encapsulationVlanId = spec.encapsulationVlanId == 0 ? 1 : spec.encapsulationVlanId;
        session.stripOriginalVlan = !spec.preserveOriginalVlan;
        session.normalTrafficAllowed = spec.normalTrafficAllowed;
        session.sourcePortReceived = new VmwareDistributedVirtualSwitch.VspanPorts();
        session.sourcePortReceived.portKey = spec.sourcePortsIngress;
        session.sourcePortTransmitted = new VmwareDistributedVirtualSwitch.VspanPorts();
        session.sourcePortTransmitted.portKey = spec.sourcePortsEgress;
        session.destinationPort = new VmwareDistributedVirtualSwitch.VspanPorts();
        session.destinationPort.uplinkPortName = spec.destinationUplinks;
    }

    private void setDvPortSessionProperties(VmwareDistributedVirtualSwitch.VspanSession session, DvsAddSpanSessionSpec spec) {
        session.normalTrafficAllowed = spec.normalTrafficAllowed;
        session.sourcePortReceived = new VmwareDistributedVirtualSwitch.VspanPorts();
        session.sourcePortReceived.portKey = spec.sourcePortsIngress;
        session.sourcePortTransmitted = new VmwareDistributedVirtualSwitch.VspanPorts();
        session.sourcePortTransmitted.portKey = spec.sourcePortsEgress;
        session.destinationPort = new VmwareDistributedVirtualSwitch.VspanPorts();
        session.destinationPort.portKey = spec.destinationPorts;
    }

    private void setRemoteDestSessionProperties(VmwareDistributedVirtualSwitch.VspanSession session, DvsAddSpanSessionSpec spec) {
        session.normalTrafficAllowed = spec.normalTrafficAllowed;
        session.sourcePortReceived = new VmwareDistributedVirtualSwitch.VspanPorts();
        session.sourcePortReceived.vlans = spec.sourceVlanIds;
        session.destinationPort = new VmwareDistributedVirtualSwitch.VspanPorts();
        session.destinationPort.portKey = spec.destinationPorts;
    }

    private boolean isNameUnique(String name, VmwareDistributedVirtualSwitch.VspanSession[] vspanSessions) {
        if (vspanSessions != null) {
            for (VmwareDistributedVirtualSwitch.VspanSession vspanSession : vspanSessions) {
                if (vspanSession.name == null || !vspanSession.name.equals(name)) continue;
                return false;
            }
        }
        return true;
    }
}

