/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.portmirroring;

import com.vmware.vim.binding.vim.dvs.PortConnectee;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vsphere.client.dvs.api.spec.GenericVlanSpec;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.portbrowser.DvsSpanSessionPortBrowserPortData;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.portlist.DvsSpanSessionPortListItemData;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.HashMap;
import java.util.Map;

public class DvsAddSpanSessionWizardPortParser {
    private static final String DVPORT_KEY = "key";
    private static final String DVPORT_NAME = "name";
    private static final String DVPORT_CONN_ENTITY = "connectedEntityName";
    private static final String DVPORT_CONNECTEE = "connectee";
    private static final String DVPORT_MAC = "macAddress";
    private static final String DVPORT_PGNAME = "portgroupName";
    private static final String DVPORT_PORTSTATE = "portState";
    private static final String DVPORT_VLAN = "vlanInfo";
    private static final String DVPORT_PROXYHOST = "proxyHostName";

    public static DvsSpanSessionPortBrowserPortData parsePortBrowserPortData(ResultItem ri) {
        DvsSpanSessionPortBrowserPortData portData = new DvsSpanSessionPortBrowserPortData();
        HashMap<String, Object> portProperties = new HashMap<String, Object>();
        if (ri != null && ri.properties != null) {
            for (PropertyValue prop : ri.properties) {
                portProperties.put(prop.propertyName, prop.value);
            }
        }
        PropertyValue[] propertyValueArray = portProperties.keySet().iterator();
        while (propertyValueArray.hasNext()) {
            String key;
            switch (key = (String)propertyValueArray.next()) {
                case "key": {
                    portData.portId = (String)DvsAddSpanSessionWizardPortParser.getPropertyValue(key, portProperties);
                    break;
                }
                case "name": {
                    portData.name = (String)DvsAddSpanSessionWizardPortParser.getPropertyValue(key, portProperties);
                    break;
                }
                case "connectee": 
                case "connectedEntityName": {
                    PortConnectee connectee = (PortConnectee)DvsAddSpanSessionWizardPortParser.getPropertyValue(DVPORT_CONNECTEE, portProperties);
                    String connecteeName = (String)DvsAddSpanSessionWizardPortParser.getPropertyValue(DVPORT_CONN_ENTITY, portProperties);
                    if (connectee == null) break;
                    portData.connectedEntity = PortConnectee.ConnecteeType.vmVnic.equals((Object)PortConnectee.ConnecteeType.valueOf((String)connectee.type)) ? connecteeName : connectee.nicKey;
                    portData.connectedEntityType = connectee.type;
                    break;
                }
                case "proxyHostName": {
                    portData.host = (String)DvsAddSpanSessionWizardPortParser.getPropertyValue(key, portProperties);
                    break;
                }
                case "macAddress": {
                    portData.mac = (String)DvsAddSpanSessionWizardPortParser.getPropertyValue(key, portProperties);
                    break;
                }
                case "portgroupName": {
                    portData.portgroup = (String)DvsAddSpanSessionWizardPortParser.getPropertyValue(key, portProperties);
                    break;
                }
                case "portState": {
                    portData.state = (String)DvsAddSpanSessionWizardPortParser.getPropertyValue(key, portProperties);
                    break;
                }
                case "vlanInfo": {
                    GenericVlanSpec vlanSpec = (GenericVlanSpec)DvsAddSpanSessionWizardPortParser.getPropertyValue(key, portProperties);
                    portData.vlan = NetworkUtil.getVlanIdBySpec(vlanSpec.vlanSpec, new VmwareDistributedVirtualSwitch.PvlanMapEntry[]{vlanSpec.matchingPvlanMapEntry});
                }
            }
        }
        return portData;
    }

    public static DvsSpanSessionPortListItemData parsePortListPortData(ResultItem ri) {
        DvsSpanSessionPortListItemData portData = new DvsSpanSessionPortListItemData();
        HashMap<String, Object> portProperties = new HashMap<String, Object>();
        if (ri != null && ri.properties != null) {
            for (PropertyValue prop : ri.properties) {
                portProperties.put(prop.propertyName, prop.value);
            }
        }
        PropertyValue[] propertyValueArray = portProperties.keySet().iterator();
        while (propertyValueArray.hasNext()) {
            String key;
            switch (key = (String)propertyValueArray.next()) {
                case "key": {
                    portData.portId = (String)DvsAddSpanSessionWizardPortParser.getPropertyValue(key, portProperties);
                    break;
                }
                case "connectee": 
                case "connectedEntityName": {
                    PortConnectee connectee = (PortConnectee)DvsAddSpanSessionWizardPortParser.getPropertyValue(DVPORT_CONNECTEE, portProperties);
                    String connecteeName = (String)DvsAddSpanSessionWizardPortParser.getPropertyValue(DVPORT_CONN_ENTITY, portProperties);
                    if (connectee == null) break;
                    portData.connectee = PortConnectee.ConnecteeType.vmVnic.equals((Object)PortConnectee.ConnecteeType.valueOf((String)connectee.type)) ? connecteeName : connectee.nicKey;
                    portData.connecteeType = connectee.type;
                    break;
                }
                case "proxyHostName": {
                    portData.host = (String)DvsAddSpanSessionWizardPortParser.getPropertyValue(key, portProperties);
                }
            }
        }
        return portData;
    }

    private static <T> T getPropertyValue(String key, Map<String, Object> properties) {
        Object value = properties.get(key);
        try {
            Object castedValue = value;
            return (T)castedValue;
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

