/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.portmirroring;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.DvsPortMirroringQueryBinding;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.dialog.DvsEditSpanSessionDialogData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DvsEditSpanSessionDialogPropertyProvider
implements PropertyProviderBean {
    private static final String VSPAN_DVS_UPLINKS = "config/uplinkPortPolicy/uplinkPortName";
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;

    public DvsEditSpanSessionDialogPropertyProvider(QueryBindingService queryBindingService, QueryService queryService) {
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvswitchportmirroring", property="editSpanSessionDialogData")
    public DvsEditSpanSessionDialogData getEditSpanSessionDialogData(ManagedObjectReference dvsMor, String sessionKey) {
        DvsPortMirroringQueryBinding spanSessionsQueryBinding = (DvsPortMirroringQueryBinding)this._queryBindingService.prepare(DvsPortMirroringQueryBinding.class).fetch((Object)dvsMor);
        DvsEditSpanSessionDialogData dialogData = new DvsEditSpanSessionDialogData();
        if (sessionKey != null && spanSessionsQueryBinding != null && spanSessionsQueryBinding.vspanSessions != null) {
            if (spanSessionsQueryBinding.vspanCapabilities != null) {
                dialogData.erspanSupported = spanSessionsQueryBinding.vspanCapabilities.erspanProtocolSupported;
                dialogData.mirrorNetstackSupported = spanSessionsQueryBinding.vspanCapabilities.mirrorNetstackSupported;
            }
            dialogData.dvsName = MixedUtil.unescapeVimEntityNameSpecialChars((String)spanSessionsQueryBinding.dvsName);
            for (VmwareDistributedVirtualSwitch.VspanSession session : spanSessionsQueryBinding.vspanSessions) {
                if (!sessionKey.equals(session.key)) continue;
                dialogData.key = sessionKey;
                dialogData.sessionName = session.name;
                dialogData.sessionType = session.sessionType;
                dialogData.description = session.description;
                dialogData.enabled = session.enabled;
                dialogData.samplingRate = session.samplingRate;
                dialogData.mirroredPacketLengthEnabled = session.mirroredPacketLength != null && session.mirroredPacketLength > -1;
                if (dialogData.mirroredPacketLengthEnabled.booleanValue()) {
                    dialogData.mirroredPacketLength = session.mirroredPacketLength;
                }
                dialogData.encapsulationType = session.encapType;
                dialogData.sessionId = session.erspanId;
                dialogData.tcpIpStack = session.netstack;
                dialogData.preserveOriginalVlan = !session.stripOriginalVlan;
                dialogData.encapsulationVlanId = session.encapsulationVlanId;
                dialogData.normalTrafficAllowed = session.normalTrafficAllowed;
                if (session.sourcePortTransmitted != null) {
                    dialogData.sourcePortsEgress = session.sourcePortTransmitted.getPortKey();
                }
                if (session.sourcePortReceived != null) {
                    dialogData.sourcePortsIngress = session.sourcePortReceived.getPortKey();
                    dialogData.sourceVlans = session.sourcePortReceived.vlans;
                }
                if (session.destinationPort != null) {
                    dialogData.destinationAddresses = session.destinationPort.ipAddress;
                    dialogData.destinationPorts = session.destinationPort.portKey;
                }
                if (session.destinationPort == null || session.destinationPort.uplinkPortName == null) break;
                dialogData.uplinkPortsSelected = session.destinationPort.uplinkPortName;
                List<String> allExistingUplinks = this.getDvsUplinksForEditSpanSession(dvsMor);
                allExistingUplinks.removeAll(Arrays.asList(dialogData.uplinkPortsSelected));
                dialogData.uplinkPortsExisting = new String[allExistingUplinks.size()];
                dialogData.uplinkPortsExisting = allExistingUplinks.toArray(dialogData.uplinkPortsExisting);
                break;
            }
        }
        return dialogData;
    }

    public List<String> getDvsUplinksForEditSpanSession(ManagedObjectReference dvsMor) {
        ResultSet resultSet = this._queryService.select(new String[]{VSPAN_DVS_UPLINKS}).from(new String[]{dvsMor.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
        List resultItems = resultSet.getItems();
        ArrayList<String> uplinksData = null;
        if (resultItems != null && !resultItems.isEmpty()) {
            uplinksData = new ArrayList<String>();
            for (ResourceItem resultItem : resultItems) {
                String[] uplinkNames;
                for (String name : uplinkNames = (String[])resultItem.get(VSPAN_DVS_UPLINKS)) {
                    uplinksData.add(name);
                }
            }
        }
        return uplinksData;
    }
}

