/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.dvs.VmVnicNetworkResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.dvs.api.info.DvsResControlStatistics;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp.model.DvsNetworkResourcePoolDialogData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class DvsNetworkResourcePoolDialogPropertyProvider
implements PropertyProviderBean {
    private static final String NETWORK_RESOURCE_POOLS_NAMES_PROPERTY = "vmVnicResourcePoolNames";
    private static final String RESOURCE_POOL_CONFIG_PROPERTY = "vmVnicResourcePoolConfig";
    private static final String RES_CONTROL_STATS_PROPERTY = "resControlStatistics";
    private final QueryService _queryService;

    public DvsNetworkResourcePoolDialogPropertyProvider(QueryService queryService) {
        this._queryService = queryService;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsresmgmt", property="networkResourcePoolCreateDialogData")
    public DvsNetworkResourcePoolDialogData getNetworkResourcePoolCreateDialogData(ManagedObjectReference dvsMor) {
        ResultSet resultSet = this._queryService.select(new String[]{RES_CONTROL_STATS_PROPERTY, NETWORK_RESOURCE_POOLS_NAMES_PROPERTY}).from(new String[]{dvsMor.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
        DvsNetworkResourcePoolDialogData data = new DvsNetworkResourcePoolDialogData();
        data.name = "";
        data.description = "";
        data.reservationQuota = 0L;
        data.limit = 0L;
        List resourceItems = resultSet.getItems();
        if (CollectionUtils.isNotEmpty((Collection)resourceItems)) {
            DvsResControlStatistics stats = (DvsResControlStatistics)((ResourceItem)resourceItems.get(0)).get(RES_CONTROL_STATS_PROPERTY);
            if (stats != null) {
                data.limit = Math.max(0L, stats.totalVmVnicPoolBandwidth - stats.reservedVmVnicPoolBandwidth - stats.aggregatedVmBandwidthReservation);
            }
            String[] resPoolNames = (String[])((ResourceItem)resourceItems.get(0)).get(NETWORK_RESOURCE_POOLS_NAMES_PROPERTY);
            data.name = this.generateUniqueResourcePoolName(resPoolNames);
        }
        return data;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsresmgmt", property="networkResourcePoolEditDialogData")
    public DvsNetworkResourcePoolDialogData getNetworkResourcePoolEditDialogData(ManagedObjectReference dvsMor, String resourcePoolKey) {
        if (resourcePoolKey == null) {
            throw new IllegalArgumentException("Resource pool key cannot be null");
        }
        ResultSet resultSet = this._queryService.select(new String[]{RES_CONTROL_STATS_PROPERTY, RESOURCE_POOL_CONFIG_PROPERTY}).from(new String[]{dvsMor.getType()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("vmVnicResourcePoolConfig/@param", PropertyPredicate.ComparisonOperator.EQUAL, (Object)resourcePoolKey), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
        DvsNetworkResourcePoolDialogData data = new DvsNetworkResourcePoolDialogData();
        data.name = "";
        data.description = "";
        data.reservationQuota = 0L;
        data.limit = 0L;
        List resourceItems = resultSet.getItems();
        if (CollectionUtils.isNotEmpty((Collection)resourceItems)) {
            DvsResControlStatistics stats;
            VmVnicNetworkResourcePool rp = (VmVnicNetworkResourcePool)((ResourceItem)resourceItems.get(0)).get(RESOURCE_POOL_CONFIG_PROPERTY);
            if (rp != null) {
                data.name = rp.name;
                data.description = rp.description;
                if (rp.allocationInfo != null) {
                    data.reservationQuota = rp.allocationInfo.reservationQuota;
                }
            }
            if ((stats = (DvsResControlStatistics)((ResourceItem)resourceItems.get(0)).get(RES_CONTROL_STATS_PROPERTY)) != null) {
                data.limit = Math.max(0L, stats.totalVmVnicPoolBandwidth - stats.reservedVmVnicPoolBandwidth - stats.aggregatedVmBandwidthReservation + data.reservationQuota);
            }
        }
        return data;
    }

    private String generateUniqueResourcePoolName(String[] existingNames) {
        int index = 1;
        String candidateName = NetworkStringUtil.getString("NetworkResourcePool.defaultNameFormat", String.valueOf(index));
        if (!ArrayUtils.isEmpty((Object[])existingNames)) {
            List<String> namesList = Arrays.asList(existingNames);
            while (namesList.contains(candidateName)) {
                candidateName = NetworkStringUtil.getString("NetworkResourcePool.defaultNameFormat", String.valueOf(++index));
            }
        }
        return candidateName;
    }
}

