/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp;

import com.vmware.vim.binding.vim.SharesInfo;
import com.vmware.vim.binding.vim.vm.ConfigSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vsphere.client.common.compositecommand.api.spec.DummyCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.VmVnicSpec;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.nrp.model.DvsVmVnicResourceSettingsSpec;
import com.vmware.vsphere.client.network.vm.api.spec.VmReconfigureCommandSpec;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public class DvsVmVnicResourceSettingsDialogMutationProvider
implements MutationProvider {
    private final MutationService _mutationService;

    public DvsVmVnicResourceSettingsDialogMutationProvider(MutationService mutationService) {
        this._mutationService = mutationService;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsVmVnicResourceSettingsSpec spec) {
        DummyCommandSpec rootCommandSpec = new DummyCommandSpec();
        rootCommandSpec.mor = dvsRef;
        rootCommandSpec.dependentSpecs = this.getVmCommandSpecs(spec);
        return this._mutationService.apply((Object)dvsRef, (Object)rootCommandSpec);
    }

    private VmReconfigureCommandSpec[] getVmCommandSpecs(DvsVmVnicResourceSettingsSpec spec) {
        ArrayList<VmReconfigureCommandSpec> commandSpecs = new ArrayList<VmReconfigureCommandSpec>();
        if (spec != null && !ArrayUtils.isEmpty((Object[])spec.vnicSpecs)) {
            VirtualEthernetCard.ResourceAllocation resourceAllocation = new VirtualEthernetCard.ResourceAllocation();
            resourceAllocation.share = new SharesInfo();
            resourceAllocation.share.shares = spec.sharesValue;
            try {
                resourceAllocation.share.level = SharesInfo.Level.valueOf((String)spec.sharesLevel);
            }
            catch (IllegalArgumentException ex) {
                resourceAllocation.share.level = null;
            }
            resourceAllocation.reservation = spec.reservation;
            resourceAllocation.limit = spec.limit;
            for (VmVnicSpec vnicSpec : spec.vnicSpecs) {
                if (vnicSpec == null || !vnicSpec.deviceEditingAllowed || ArrayUtils.isEmpty((Object[])vnicSpec.networkAdapters)) continue;
                VmReconfigureCommandSpec commandSpec = new VmReconfigureCommandSpec();
                commandSpec.mor = vnicSpec.vmRef;
                ConfigSpec configSpec = new ConfigSpec();
                configSpec.changeVersion = vnicSpec.changeVersion;
                ArrayList<VirtualDeviceSpec> deviceSpecs = new ArrayList<VirtualDeviceSpec>();
                for (VirtualEthernetCard virtualEthernetCard : vnicSpec.networkAdapters) {
                    virtualEthernetCard.resourceAllocation = resourceAllocation;
                    VirtualDeviceSpec deviceSpec = new VirtualDeviceSpec();
                    deviceSpec.operation = VirtualDeviceSpec.Operation.edit;
                    deviceSpec.device = virtualEthernetCard;
                    deviceSpecs.add(deviceSpec);
                }
                configSpec.deviceChange = deviceSpecs.toArray(new VirtualDeviceSpec[deviceSpecs.size()]);
                commandSpec.configSpec = configSpec;
                commandSpecs.add(commandSpec);
            }
        }
        return commandSpecs.toArray(new VmReconfigureCommandSpec[commandSpecs.size()]);
    }
}

