/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.upgrade;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.dvs.upgrade.model.UpgradeLacpActionData;
import com.vmware.vsphere.client.h5.network.dvs.upgrade.model.UpgradeLacpDvsData;

public class DvsUpgradeLacpPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;
    private static final String LACP_VERSION_SINGLE_LAG = "singleLag";

    public DvsUpgradeLacpPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="lacpupgrade", property="actionAvailable")
    public Boolean getDvsUpgradeLacpActionAvailable(ManagedObjectReference dvsRef) {
        UpgradeLacpActionData upgradeLacpData = (UpgradeLacpActionData)this._queryBindingService.prepare(UpgradeLacpActionData.class).fetch((Object)dvsRef);
        return upgradeLacpData.dvsOperationSupported && upgradeLacpData.multiLacpGroupSupported && LACP_VERSION_SINGLE_LAG.equals(upgradeLacpData.lacpApiVersion);
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="lacpupgrade", property="wizardData")
    public UpgradeLacpDvsData getDvsUpgradeLacpWizardData(ManagedObjectReference dvsRef) {
        UpgradeLacpDvsData upgradeLacpData = (UpgradeLacpDvsData)this._queryBindingService.prepare(UpgradeLacpDvsData.class).fetch((Object)dvsRef);
        return upgradeLacpData;
    }
}

