/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.managepnic;

import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import java.util.LinkedList;
import org.apache.commons.collections4.CollectionUtils;

public class ManagePnicParser {
    public static VirtualSwitch.Specification buildVSwitchSpec(VirtualSwitch virtualSwitch, String[] activeNic, String[] standbyNic, String[] unusedNic) {
        VirtualSwitch.Specification vSwitchSpec = null;
        if (virtualSwitch != null && activeNic != null && standbyNic != null && unusedNic != null) {
            vSwitchSpec = virtualSwitch.spec;
            if (vSwitchSpec == null) {
                vSwitchSpec = new VirtualSwitch.Specification();
            }
            if (vSwitchSpec.policy == null) {
                vSwitchSpec.policy = new NetworkPolicy();
            }
            if (vSwitchSpec.policy.nicTeaming == null) {
                vSwitchSpec.policy.nicTeaming = new NetworkPolicy.NicTeamingPolicy();
            }
            if (vSwitchSpec.policy.nicTeaming.nicOrder == null) {
                vSwitchSpec.policy.nicTeaming.nicOrder = new NetworkPolicy.NicOrderPolicy();
            }
            vSwitchSpec.policy.nicTeaming.nicOrder.activeNic = activeNic;
            vSwitchSpec.policy.nicTeaming.nicOrder.standbyNic = standbyNic;
            LinkedList allPnics = new LinkedList();
            CollectionUtils.addAll(allPnics, (Object[])activeNic);
            CollectionUtils.addAll(allPnics, (Object[])standbyNic);
            CollectionUtils.addAll(allPnics, (Object[])unusedNic);
            if (!allPnics.isEmpty()) {
                VirtualSwitch.BondBridge bondBridge = new VirtualSwitch.BondBridge();
                bondBridge.nicDevice = allPnics.toArray(new String[allPnics.size()]);
                vSwitchSpec.bridge = bondBridge;
            } else {
                vSwitchSpec.bridge = null;
            }
        }
        return vSwitchSpec;
    }
}

