/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.pnic;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.SriovInfo;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vsphere.client.h5.network.host.HostNetworkingService;
import com.vmware.vsphere.client.h5.network.host.pnic.PnicParser;
import com.vmware.vsphere.client.h5.network.host.pnic.model.EditHostPnicData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.EditHostPnicModel;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicDetailsData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicItem;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicSwitchData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicsWithDetailsModel;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.network.host.api.HostPnicDetailsItem;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostPnicPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(HostPnicPropertyProvider.class);
    private final QueryBindingService _queryBindingService;
    private final HostNetworkingService _hostNetworkingService;

    public HostPnicPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory, HostNetworkingService hostNetworkingService) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._hostNetworkingService = hostNetworkingService;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="pnic", property="physicalAdapterItems")
    public HostPnicItem[] getPhysicalAdapterItems(ManagedObjectReference hostRef) {
        List<HostPnicItem> pnicItems = new LinkedList<HostPnicItem>();
        HostPnicData pnicData = (HostPnicData)this._queryBindingService.prepare(HostPnicData.class).fetch((Object)hostRef);
        PhysicalNic[] physicalNics = null;
        if (pnicData != null && pnicData.networkInfo != null) {
            physicalNics = pnicData.networkInfo.getPnic();
        }
        if (physicalNics != null) {
            for (PhysicalNic pnic : physicalNics) {
                HostPnicItem item = new HostPnicItem();
                item.device = pnic.device;
                if (pnic.linkSpeed != null) {
                    item.actualSpeed = pnic.linkSpeed.speedMb;
                }
                if (pnic.spec != null && pnic.spec.linkSpeed != null) {
                    item.configuredSpeed = pnic.spec.linkSpeed.speedMb;
                }
                item.mac = pnic.mac;
                item.dpuId = pnic.dpuId;
                item.wakeOnLanSupported = pnic.wakeOnLanSupported;
                item.virtualSwitch = PnicParser.getVirtualSwitch(pnic, pnicData.networkInfo);
                item.networkHint = PnicParser.getNetworkHint(pnic.device, pnicData.networkInfo.ipV6Enabled, pnicData.networkHints);
                SriovInfo pnicSriovInfo = NetworkUtil.getSriovByPnic(pnic.pci, pnicData.sriovInfo);
                item.sriovInfo = PnicParser.assignSriovInfoItem(pnicSriovInfo, false);
                pnicItems.add(item);
            }
            pnicItems = PnicParser.sortPnicsByDeviceNumerically(pnicItems);
        }
        return pnicItems.toArray(new HostPnicItem[pnicItems.size()]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="pnic", property="physicalAdapterItemDetails")
    public HostPnicDetailsItem getPhysicalAdapterItemDetails(ManagedObjectReference hostRef, String device) {
        HostPnicDetailsData pnicDetailsData = (HostPnicDetailsData)this._queryBindingService.prepare(HostPnicDetailsData.class).fetch((Object)hostRef);
        PhysicalNic pnic = NetworkUtil.getPnicByName(device, pnicDetailsData.pnics);
        if (pnic == null) {
            _logger.error((Object)String.format("No physical adapter with key '%s' found in host '%s'", device, hostRef.toString()));
            return null;
        }
        return PnicParser.createHostPnicDetailsItem(pnic, pnicDetailsData);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="pnic", property="unclaimedPhysicalAdapters")
    public HostPnicsWithDetailsModel getUnclaimedPhysicalAdapters(ManagedObjectReference hostRef) {
        HostPnicSwitchData pnicSwitchData = (HostPnicSwitchData)this._queryBindingService.prepare(HostPnicSwitchData.class).fetch((Object)hostRef);
        return PnicParser.getUnclaimedPhysicalAdaptersWithDetails(pnicSwitchData);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="pnic", property="physicalAdaptersWithDetails")
    public HostPnicsWithDetailsModel getPhysicalAdaptersWithDetails(ManagedObjectReference hostRef, String vSwitchName) {
        HostPnicSwitchData pnicSwitchData = (HostPnicSwitchData)this._queryBindingService.prepare(HostPnicSwitchData.class).fetch((Object)hostRef);
        VirtualSwitch virtualSwitch = NetworkUtil.getVswitchByName(vSwitchName, pnicSwitchData.vSwitches);
        if (virtualSwitch == null || virtualSwitch.spec.policy == null || virtualSwitch.spec.policy.nicTeaming == null) {
            return null;
        }
        return PnicParser.getFailOverPnicsWithDetails(pnicSwitchData, virtualSwitch.spec.policy.nicTeaming.nicOrder, virtualSwitch);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="pnic", property="editPhysicalAdapterModel")
    public EditHostPnicModel getEditPhysicalAdapterModel(ManagedObjectReference hostRef, String device) {
        EditHostPnicData editHostPnicData = (EditHostPnicData)this._queryBindingService.prepare(EditHostPnicData.class).fetch((Object)hostRef);
        PhysicalNic pnic = NetworkUtil.getPnicByName(device, editHostPnicData.pnics);
        if (pnic == null) {
            _logger.error((Object)String.format("No physical adapter with key '%s' found in host '%s'", device, hostRef.toString()));
            return null;
        }
        SriovInfo pnicSriovInfo = NetworkUtil.getSriovByPnic(pnic.pci, editHostPnicData.sriovInfo);
        return PnicParser.createEditPnicModel(pnic, pnicSriovInfo);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="pnic", property="networkHints")
    public PhysicalNic.NetworkHint[] getNetworkHintsProperty(ManagedObjectReference hostRef) {
        PhysicalNic.NetworkHint[] networkHints = new PhysicalNic.NetworkHint[]{};
        try {
            NetworkSystem networkSystem = this._hostNetworkingService.getNetworkSystem(hostRef);
            if (networkSystem != null) {
                networkHints = networkSystem.queryNetworkHint(null);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)ExceptionUtil.getStackTrace((Throwable)ex));
        }
        return networkHints;
    }
}

