/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.portgroup;

import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.host.portgroup.model.EditPortgroupDialogData;
import com.vmware.vsphere.client.h5.network.host.portgroup.model.PortGroupRemoveSpec;
import com.vmware.vsphere.client.h5.network.model.NetworkPolicyData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.modules.api.network.PortGroupEditSpec;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostPortGroupMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(HostPortGroupMutationProvider.class);
    private static final String NETWORK_SYSTEM = "networkSystem";
    private static final String NETWORK_INFO = "config.network";
    private final QueryExecutor _queryExecutor;
    private final MutationService _mutationService;

    public HostPortGroupMutationProvider(QueryExecutor queryExecutor, MutationService mutationService) {
        this._queryExecutor = queryExecutor;
        this._mutationService = mutationService;
    }

    public OperationResult apply(ManagedObjectReference host, EditPortgroupDialogData spec) {
        PortGroupEditSpec portGroupEditSpec = new PortGroupEditSpec();
        portGroupEditSpec.portGroupName = spec.properties.oldPortgroupName;
        portGroupEditSpec.spec = new PortGroup.Specification();
        portGroupEditSpec.spec.policy = new NetworkPolicy();
        portGroupEditSpec.spec.policy.security = this.createSecurityPolicy(spec);
        portGroupEditSpec.spec.policy.shapingPolicy = this.createShapingPolicy(spec);
        portGroupEditSpec.spec.policy.nicTeaming = this.createNicTeamingPolicy(spec.teamingAndFailover);
        portGroupEditSpec.spec.name = spec.properties.portgroupName;
        portGroupEditSpec.spec.vswitchName = spec.properties.vswitchName;
        portGroupEditSpec.spec.vlanId = spec.properties.portgroupVlanId;
        return this._mutationService.apply((Object)host, (Object)portGroupEditSpec);
    }

    public OperationResult apply(ManagedObjectReference mor, PortGroupRemoveSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = mor;
        if (spec == null) {
            _logger.error((Object)"PortGroupRemoveSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        try {
            PropertyValue[] propertiesResults;
            ManagedObjectReference networkSystemRef = null;
            NetworkInfo networkInfo = null;
            for (PropertyValue pVal : propertiesResults = this._queryExecutor.getProperties((Object)mor, new String[]{NETWORK_SYSTEM, NETWORK_INFO})) {
                if (pVal.propertyName.equals(NETWORK_SYSTEM)) {
                    networkSystemRef = (ManagedObjectReference)pVal.value;
                    continue;
                }
                if (!pVal.propertyName.equals(NETWORK_INFO)) continue;
                networkInfo = (NetworkInfo)pVal.value;
            }
            NetworkSystem networkSystem = (NetworkSystem)ManagedObjectUtil.getManagedObject(networkSystemRef);
            if (networkInfo != null) {
                VirtualNic virtualNic = NetworkUtil.getVirtualNicByPortGroupName(spec.portgroupName, networkInfo.vnic);
                if (virtualNic != null) {
                    networkSystem.removeVirtualNic(virtualNic.device);
                }
                if (StringUtils.isNotEmpty((CharSequence)spec.portgroupName)) {
                    networkSystem.removePortGroup(spec.portgroupName);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when removing port group: " + ex.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    public ValidationResult validate(ManagedObjectReference objRef, PortGroupRemoveSpec spec) throws Exception {
        VirtualNic vnic;
        NetworkInfo networkInfo;
        ValidationResult validationResult = new ValidationResult();
        if (spec != null && spec.portgroupName != null && (networkInfo = (NetworkInfo)this._queryExecutor.getProperty((Object)objRef, NETWORK_INFO)) != null && (vnic = NetworkUtil.getVirtualNicByPortGroupName(spec.portgroupName, networkInfo.getVnic())) != null && NetworkUtil.isLastManagementVmnic(networkInfo, vnic.device)) {
            validationResult.result = NetworkStringUtil.getString("removePortgroup.managementVmkernelError");
        }
        return validationResult;
    }

    private NetworkPolicy.SecurityPolicy createSecurityPolicy(EditPortgroupDialogData spec) {
        Validate.notNull((Object)spec.securityPolicies);
        NetworkPolicy.SecurityPolicy securityPolicy = new NetworkPolicy.SecurityPolicy();
        if (spec.securityPolicies.isPromiscuousModeOverriden) {
            securityPolicy.allowPromiscuous = spec.securityPolicies.allowPromiscuousMode;
        }
        if (spec.securityPolicies.isMacChangesOverriden) {
            securityPolicy.macChanges = spec.securityPolicies.macChanges;
        }
        if (spec.securityPolicies.isForgedTransmitsOverriden) {
            securityPolicy.forgedTransmits = spec.securityPolicies.forgedTransmits;
        }
        return securityPolicy;
    }

    private NetworkPolicy.TrafficShapingPolicy createShapingPolicy(EditPortgroupDialogData spec) {
        Validate.notNull((Object)spec.trafficShapingPolicies);
        NetworkPolicy.TrafficShapingPolicy shapingPolicy = new NetworkPolicy.TrafficShapingPolicy();
        if (spec.trafficShapingPolicies.overridden) {
            shapingPolicy.enabled = spec.trafficShapingPolicies.enabled;
        }
        if (Boolean.TRUE.equals(shapingPolicy.enabled)) {
            shapingPolicy.averageBandwidth = spec.trafficShapingPolicies.averageBandwidth * 1000L;
            shapingPolicy.peakBandwidth = spec.trafficShapingPolicies.peakBandwidth * 1000L;
            shapingPolicy.burstSize = spec.trafficShapingPolicies.burstSize * 1024L;
        }
        return shapingPolicy;
    }

    private NetworkPolicy.NicTeamingPolicy createNicTeamingPolicy(NetworkPolicyData.TeamingAndFailover teamingAndFailover) {
        Validate.notNull((Object)teamingAndFailover);
        NetworkPolicy.NicTeamingPolicy nicTeamingPolicy = new NetworkPolicy.NicTeamingPolicy();
        if (teamingAndFailover.loadBalancingOverridden) {
            nicTeamingPolicy.policy = teamingAndFailover.loadBalancing;
        }
        if (teamingAndFailover.notifySwitchesOverridden) {
            nicTeamingPolicy.notifySwitches = teamingAndFailover.notifySwitches;
        }
        if (teamingAndFailover.failbackOverridden) {
            nicTeamingPolicy.rollingOrder = teamingAndFailover.rollingOrder;
        }
        nicTeamingPolicy.failureCriteria = this.createFailureCriteria(teamingAndFailover);
        nicTeamingPolicy.nicOrder = this.createNicOrderPolicy(teamingAndFailover);
        return nicTeamingPolicy;
    }

    private NetworkPolicy.NicFailureCriteria createFailureCriteria(NetworkPolicyData.TeamingAndFailover teamingAndFailover) {
        NetworkPolicy.NicFailureCriteria failureCriteria = null;
        if (teamingAndFailover.failureDetectionOverridden) {
            failureCriteria = new NetworkPolicy.NicFailureCriteria();
            failureCriteria.checkBeacon = teamingAndFailover.checkBeacon;
        }
        return failureCriteria;
    }

    private NetworkPolicy.NicOrderPolicy createNicOrderPolicy(NetworkPolicyData.TeamingAndFailover teamingAndFailover) {
        NetworkPolicy.NicOrderPolicy nicOrderPolicy = null;
        if (teamingAndFailover.failoverOrderOverridden) {
            nicOrderPolicy = new NetworkPolicy.NicOrderPolicy();
            if (teamingAndFailover.pnics != null && teamingAndFailover.pnics.active != null) {
                nicOrderPolicy.activeNic = teamingAndFailover.pnics.active.toArray(new String[0]);
            }
            if (teamingAndFailover.pnics != null && teamingAndFailover.pnics.standby != null) {
                nicOrderPolicy.standbyNic = teamingAndFailover.pnics.standby.toArray(new String[0]);
            }
        }
        return nicOrderPolicy;
    }
}

