/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.proxyswitch;

import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vsphere.client.h5.network.host.pnic.PnicParser;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicDetailsData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicSwitchData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicsWithDetailsModel;
import com.vmware.vsphere.client.h5.network.host.proxyswitch.model.DvsUplinkPortgroupData;
import com.vmware.vsphere.client.h5.network.host.proxyswitch.model.ProxySwitchUplinkData;
import com.vmware.vsphere.client.h5.network.host.proxyswitch.model.UplinkPortMapping;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProxySwitchParser {
    public static ProxySwitchUplinkData buildDvsUplinkData(HostPnicSwitchData pnicSwitchData, DvsUplinkPortgroupData dvpgData, String proxySwitchKey, List<String> compatiblePnics) {
        HostProxySwitch hostProxySwitch;
        ProxySwitchUplinkData proxySwitchUplinkData = new ProxySwitchUplinkData();
        boolean bl = proxySwitchUplinkData.isNetworkOffloadEnabled = dvpgData != null && dvpgData.isNetworkOffloadEnabled != null && dvpgData.isNetworkOffloadEnabled != false;
        if (proxySwitchUplinkData.isNetworkOffloadEnabled) {
            proxySwitchUplinkData.networkOffloadCompatiblePnics = compatiblePnics;
        }
        if (pnicSwitchData != null && pnicSwitchData.proxySwitches != null && proxySwitchKey != null && (hostProxySwitch = ProxySwitchParser.getProxySwitchByKey(proxySwitchKey, pnicSwitchData.proxySwitches)) != null) {
            if (dvpgData != null && dvpgData.uplinkPortgroups != null) {
                proxySwitchUplinkData.uplinkPortgroups = dvpgData.uplinkPortgroups;
            }
            HostPnicsWithDetailsModel unclaimedPhysicalAdaptersWithDetails = PnicParser.getUnclaimedPhysicalAdaptersWithDetails(pnicSwitchData);
            proxySwitchUplinkData.unclaimedPnics.addAll(unclaimedPhysicalAdaptersWithDetails.unclaimed);
            proxySwitchUplinkData.pnicDetails.putAll(unclaimedPhysicalAdaptersWithDetails.pnicDetails);
            if (hostProxySwitch.spec.backing instanceof HostMember.PnicBacking) {
                KeyValue[] uplinkPorts;
                HostMember.PnicSpec[] pnicSpecs = ((HostMember.PnicBacking)hostProxySwitch.spec.backing).pnicSpec;
                for (KeyValue keyValue : uplinkPorts = hostProxySwitch.uplinkPort) {
                    UplinkPortMapping.UplinkPort uplinkPort = new UplinkPortMapping.UplinkPort();
                    uplinkPort.key = keyValue.getKey();
                    uplinkPort.name = keyValue.getValue();
                    UplinkPortMapping uplinkPortMapping = new UplinkPortMapping();
                    uplinkPortMapping.uplinkPort = uplinkPort;
                    HostMember.PnicSpec pnicSpec = ProxySwitchParser.getPnicSpecForUplinkPort(pnicSpecs, keyValue.getKey());
                    proxySwitchUplinkData.uplinkPortMapping.add(uplinkPortMapping);
                    if (pnicSpec == null) continue;
                    uplinkPortMapping.pnicName = pnicSpec.pnicDevice;
                    UplinkPortMapping.UplinkPortgroup uplinkPortgroup = ProxySwitchParser.getUplinkPortgroupByKey(proxySwitchUplinkData.uplinkPortgroups, pnicSpec.uplinkPortgroupKey);
                    if (uplinkPortgroup != null) {
                        uplinkPortMapping.uplinkPortgroup = uplinkPortgroup;
                    }
                    PhysicalNic pnic = NetworkUtil.getPnicByName(pnicSpec.pnicDevice, pnicSwitchData.pnics);
                    proxySwitchUplinkData.pnicDetails.put(pnicSpec.pnicDevice, PnicParser.createHostPnicDetailsItem(pnic, (HostPnicDetailsData)pnicSwitchData));
                }
                proxySwitchUplinkData.lagMapping = ProxySwitchParser.getLagUplinkMapping(hostProxySwitch.hostLag);
            }
        }
        return proxySwitchUplinkData;
    }

    private static UplinkPortMapping.UplinkPortgroup getUplinkPortgroupByKey(UplinkPortMapping.UplinkPortgroup[] uplinkPortgroups, String uplinkPortgroupKey) {
        if (uplinkPortgroups != null && uplinkPortgroupKey != null) {
            for (UplinkPortMapping.UplinkPortgroup uplinkPortgroup : uplinkPortgroups) {
                if (!uplinkPortgroup.key.equals(uplinkPortgroupKey)) continue;
                return uplinkPortgroup;
            }
        }
        return null;
    }

    private static Map<String, List<String>> getLagUplinkMapping(HostProxySwitch.HostLagConfig[] hostLag) {
        HashMap<String, List<String>> lagMapping = new HashMap<String, List<String>>();
        if (hostLag != null) {
            for (HostProxySwitch.HostLagConfig lag : hostLag) {
                if (lag.lagName == null) continue;
                lagMapping.put(lag.lagName, new ArrayList());
                if (lag.uplinkPort == null) continue;
                for (KeyValue keyValue : lag.uplinkPort) {
                    ((List)lagMapping.get(lag.lagName)).add(keyValue.getValue());
                }
            }
        }
        return lagMapping;
    }

    private static HostMember.PnicSpec getPnicSpecForUplinkPort(HostMember.PnicSpec[] pnicSpecs, String uplinkPortKey) {
        if (uplinkPortKey != null && pnicSpecs != null) {
            for (HostMember.PnicSpec pnicSpec : pnicSpecs) {
                if (!uplinkPortKey.equals(pnicSpec.uplinkPortKey)) continue;
                return pnicSpec;
            }
        }
        return null;
    }

    private static HostProxySwitch getProxySwitchByKey(String proxySwitchKey, HostProxySwitch[] proxySwitches) {
        if (proxySwitchKey == null || proxySwitches == null || proxySwitches.length == 0) {
            return null;
        }
        for (HostProxySwitch hps : proxySwitches) {
            if (!hps.key.equals(proxySwitchKey)) continue;
            return hps;
        }
        return null;
    }
}

