/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.virtualswitch;

import com.vmware.vim.binding.vim.fault.HostConfigFault;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.fault.ResourceInUse;
import com.vmware.vim.binding.vim.host.ConfigChange;
import com.vmware.vim.binding.vim.host.NetworkConfig;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.host.HostNetworkingService;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.HostVirtualSwitchParser;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.EditStandardSwitchDialogData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.spec.RemoveVirtualSwitchSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostVirtualSwitchMutationProvider
implements MutationProvider {
    private static final String CONFIG_NETWORK = "config.network";
    private final QueryExecutor queryExecutor;
    private final HostNetworkingService hostNetworkingService;
    private static final Log _logger = LogFactory.getLog(HostVirtualSwitchMutationProvider.class);

    public HostVirtualSwitchMutationProvider(QueryExecutor queryExecutor, HostNetworkingService hostNetworkingService) {
        this.queryExecutor = queryExecutor;
        this.hostNetworkingService = hostNetworkingService;
    }

    public OperationResult apply(ManagedObjectReference host, RemoveVirtualSwitchSpec spec) throws Exception {
        OperationResult result = new OperationResult();
        result.entity = host;
        NetworkInfo networkInfo = (NetworkInfo)this.queryExecutor.getProperty((Object)host, CONFIG_NETWORK);
        NetworkConfig newConfig = this.getRemovePortgroupsConfig(spec.vSwitchName, networkInfo);
        NetworkSystem networkSystem = this.hostNetworkingService.getNetworkSystem(host);
        networkSystem.updateNetworkConfig(newConfig, ConfigChange.Mode.modify.name());
        networkSystem.removeVirtualSwitch(spec.vSwitchName);
        return result;
    }

    public OperationResult apply(ManagedObjectReference host, EditStandardSwitchDialogData dialogData) {
        NetworkSystem networkSystem;
        OperationResult result = new OperationResult();
        result.entity = host;
        if (dialogData == null) {
            _logger.error((Object)"EditStandardSwitchDialogData cannot be null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            networkSystem = this.hostNetworkingService.getNetworkSystem(host);
        }
        catch (Exception ex) {
            result.error = ex;
            return result;
        }
        VirtualSwitch[] virtualSwitches = networkSystem.getNetworkInfo().getVswitch();
        VirtualSwitch virtualSwitch = NetworkUtil.getVswitchByName(dialogData.propertiesData.name, virtualSwitches);
        if (virtualSwitch == null) {
            _logger.error((Object)String.format("Virtual switch with name '%s' does not exist", dialogData.propertiesData.name));
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        VirtualSwitch.Specification vSwitchSpec = HostVirtualSwitchParser.buildVSwitchSpec(virtualSwitch, dialogData);
        try {
            networkSystem.updateVirtualSwitch(dialogData.propertiesData.name, vSwitchSpec);
        }
        catch (HostConfigFault | NotFound | ResourceInUse ex) {
            _logger.error((Object)String.format("Virtual switch with name '%s' could no be updated", dialogData.propertiesData.name));
            result.error = ex;
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference host, RemoveVirtualSwitchSpec spec) throws Exception {
        VirtualNic[] defaultNetStackVnics;
        Validate.notNull((Object)spec);
        Validate.notNull((Object)spec.vSwitchName);
        ValidationResult validationResult = new ValidationResult();
        NetworkInfo networkInfo = (NetworkInfo)this.queryExecutor.getProperty((Object)host, CONFIG_NETWORK);
        if (networkInfo != null && NetworkUtil.areAllVnicsBelongingTo(spec.vSwitchName, networkInfo, defaultNetStackVnics = NetworkUtil.getDefaultNetStackVnics(networkInfo))) {
            validationResult.result = NetworkStringUtil.getString("removeVirtualSwitch.managementVmkernelError");
        }
        return validationResult;
    }

    private NetworkConfig getRemovePortgroupsConfig(String virtualSwitchName, NetworkInfo networkInfo) {
        NetworkConfig networkConfig = new NetworkConfig();
        PortGroup[] portgroups = NetworkUtil.getVswitchPortgroups(virtualSwitchName, networkInfo);
        ArrayList<PortGroup.Config> portgroupConfigs = new ArrayList<PortGroup.Config>();
        ArrayList<VirtualNic.Config> vnicConfigs = new ArrayList<VirtualNic.Config>();
        for (PortGroup portgroup : portgroups) {
            PortGroup.Config portgroupConfig = new PortGroup.Config();
            portgroupConfig.spec = portgroup.spec;
            portgroupConfig.changeOperation = ConfigChange.Operation.remove.name();
            portgroupConfigs.add(portgroupConfig);
            for (VirtualNic vnic : networkInfo.vnic) {
                if (!portgroup.spec.name.equalsIgnoreCase(vnic.portgroup)) continue;
                VirtualNic.Config vnicConfig = new VirtualNic.Config();
                vnicConfig.portgroup = portgroup.spec.name;
                vnicConfig.device = vnic.device;
                vnicConfig.changeOperation = ConfigChange.Operation.remove.name();
                vnicConfigs.add(vnicConfig);
            }
        }
        networkConfig.vnic = vnicConfigs.toArray(new VirtualNic.Config[vnicConfigs.size()]);
        networkConfig.portgroup = portgroupConfigs.toArray(new PortGroup.Config[portgroupConfigs.size()]);
        return networkConfig;
    }
}

