/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic.impl;

import com.vmware.vim.binding.vim.host.DnsConfig;
import com.vmware.vim.binding.vim.host.IpConfig;
import com.vmware.vim.binding.vim.host.IpRouteConfig;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.RuntimeInfo;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.h5.network.host.netstack.NetStackUtil;
import com.vmware.vsphere.client.h5.network.host.vnic.impl.EditHostVnicQueryBinding;
import com.vmware.vsphere.client.h5.network.host.vnic.impl.IpSettingsOption;
import com.vmware.vsphere.client.h5.network.host.vnic.impl.VnicMtuQueryBinding;
import com.vmware.vsphere.client.h5.network.host.vnic.impl.VnicParser;
import com.vmware.vsphere.client.h5.network.host.vnic.impl.VnicUtils;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditBindToPnicPageModel;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditIpv4PageModel;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditIpv6PageModel;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditPortPropertiesPageModel;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.Ipv6ListItem;
import com.vmware.vsphere.client.h5.network.util.IpUtil;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class EditHostVnicModelAdapter {
    private static final int DEFAULT_MTU = 1500;
    private static final String VIRTUAL_NIC_IS_NULL = "virtualNic is null";
    private static final String VIRTUAL_NIC_SPEC_IS_NULL = "virtualNic specification is null";
    private static final String VNIC_IS_NOT_FOUND = "Vnic is not found";
    private static final String EDIT_HOST_VNIC_QUERY_BINDING_IS_NULL = "editHostVnicQueryBinding is null";

    public static EditPortPropertiesPageModel createEditPortPropertiesPageModel(EditHostVnicQueryBinding editHostVnicQueryBinding, VnicMtuQueryBinding vnicMtuQueryBinding, VirtualNic virtualNic) {
        Validate.notNull((Object)((Object)editHostVnicQueryBinding), (String)EDIT_HOST_VNIC_QUERY_BINDING_IS_NULL);
        Validate.notNull((Object)virtualNic, (String)VIRTUAL_NIC_IS_NULL);
        EditPortPropertiesPageModel editPortPropertiesPageModel = new EditPortPropertiesPageModel();
        editPortPropertiesPageModel.isVmotionConfigurable = EditHostVnicModelAdapter.isTrafficConfigurableOnNetStack(editHostVnicQueryBinding.isTcpIpStackSupported, virtualNic.spec.netStackInstanceKey, editHostVnicQueryBinding.netStackInstanceRuntimeInfos, NetStackInstance.SystemStackKey.vmotion.name());
        editPortPropertiesPageModel.isProvisioningConfigurable = EditHostVnicModelAdapter.isTrafficConfigurableOnNetStack(editHostVnicQueryBinding.isTcpIpStackSupported, virtualNic.spec.netStackInstanceKey, editHostVnicQueryBinding.netStackInstanceRuntimeInfos, NetStackInstance.SystemStackKey.vSphereProvisioning.name());
        editPortPropertiesPageModel.isVsanSupported = editHostVnicQueryBinding.hostNetworkCapability.vsanSupported;
        editPortPropertiesPageModel.isProvisioningNfcTrafficSupported = editHostVnicQueryBinding.isProvisioningNfcTrafficSupported;
        editPortPropertiesPageModel.isVrTrafficSupported = editHostVnicQueryBinding.isVrTrafficSupported;
        editPortPropertiesPageModel.isVrNfcTrafficSupported = editHostVnicQueryBinding.isVrNfcTrafficSupported;
        editPortPropertiesPageModel.isTcpIpStackSupported = editHostVnicQueryBinding.isTcpIpStackSupported;
        editPortPropertiesPageModel.isVsphereBackupNfcTrafficSupported = VnicParser.isVsphereBackupNfcTrafficSupported(editHostVnicQueryBinding.vnicManagerInfo);
        editPortPropertiesPageModel.isNvmeTcpTrafficSupported = VnicParser.isNvmeTcpTrafficSupported(editHostVnicQueryBinding.vnicManagerInfo);
        editPortPropertiesPageModel.isNvmeRdmaTrafficSupported = VnicParser.isNvmeRdmaTrafficSupported(editHostVnicQueryBinding.vnicManagerInfo);
        if (editPortPropertiesPageModel.isTcpIpStackSupported) {
            editPortPropertiesPageModel.isTcpIpStackTheDefaultOne = VnicUtils.isDefaultNetStackInstance(virtualNic.spec.netStackInstanceKey);
            editPortPropertiesPageModel.tcpIpStackName = NetStackUtil.getNetStackInstanceName(NetStackUtil.getNetStackInstanceByKey(virtualNic.spec.netStackInstanceKey, editHostVnicQueryBinding.netStackInstance));
        }
        if (editHostVnicQueryBinding.vnicManagerInfo != null) {
            String vnicKey = virtualNic.key;
            VirtualNicManager.NetConfig[] netConfigs = editHostVnicQueryBinding.vnicManagerInfo.netConfig;
            editPortPropertiesPageModel.isVmotionEnabled = VnicUtils.isTrafficEnabled(vnicKey, VirtualNicManager.NicType.vmotion, netConfigs);
            editPortPropertiesPageModel.isProvisioningNfcTrafficEnabled = VnicUtils.isTrafficEnabled(vnicKey, VirtualNicManager.NicType.vSphereProvisioning, netConfigs);
            editPortPropertiesPageModel.isFtEnabled = VnicUtils.isTrafficEnabled(vnicKey, VirtualNicManager.NicType.faultToleranceLogging, netConfigs);
            editPortPropertiesPageModel.isHaEnabled = VnicUtils.isTrafficEnabled(vnicKey, VirtualNicManager.NicType.management, netConfigs);
            editPortPropertiesPageModel.isVRTrafficEnabled = VnicUtils.isTrafficEnabled(vnicKey, VirtualNicManager.NicType.vSphereReplication, netConfigs);
            editPortPropertiesPageModel.isVrNfcTrafficEnabled = VnicUtils.isTrafficEnabled(vnicKey, VirtualNicManager.NicType.vSphereReplicationNFC, netConfigs);
            editPortPropertiesPageModel.isVsanEnabled = VnicUtils.isTrafficEnabled(vnicKey, VirtualNicManager.NicType.vsan, netConfigs);
            editPortPropertiesPageModel.isVsphereBackupNfcTrafficEnabled = VnicUtils.isTrafficEnabled(vnicKey, VirtualNicManager.NicType.vSphereBackupNFC, netConfigs);
            editPortPropertiesPageModel.isNvmeTcpTrafficEnabled = VnicUtils.isTrafficEnabled(vnicKey, VirtualNicManager.NicType.nvmeTcp, netConfigs);
            editPortPropertiesPageModel.isNvmeRdmaTrafficEnabled = VnicUtils.isTrafficEnabled(vnicKey, VirtualNicManager.NicType.nvmeRdma, netConfigs);
        }
        editPortPropertiesPageModel.mtuInBytes = EditHostVnicModelAdapter.getMtu(virtualNic.spec.mtu);
        if (vnicMtuQueryBinding != null && vnicMtuQueryBinding.mtuCapability != null) {
            editPortPropertiesPageModel.maxMtuSupported = vnicMtuQueryBinding.mtuCapability.maxMtuSupported;
            editPortPropertiesPageModel.minMtuSupported = vnicMtuQueryBinding.mtuCapability.minMtuSupported;
        }
        return editPortPropertiesPageModel;
    }

    public static EditIpv4PageModel createIpv4PageModel(EditHostVnicQueryBinding editHostVnicQueryBinding, VirtualNic virtualNic) {
        Validate.notNull((Object)((Object)editHostVnicQueryBinding), (String)EDIT_HOST_VNIC_QUERY_BINDING_IS_NULL);
        Validate.notNull((Object)virtualNic, (String)VIRTUAL_NIC_IS_NULL);
        Validate.notNull((Object)virtualNic.spec, (String)VIRTUAL_NIC_SPEC_IS_NULL);
        EditIpv4PageModel ipv4page = new EditIpv4PageModel();
        ipv4page.ipSettingsOption = EditHostVnicModelAdapter.toIpSettingsOption(virtualNic.spec.ip);
        if (virtualNic.spec.ip != null) {
            ipv4page.ipAddress = virtualNic.spec.ip.ipAddress;
            ipv4page.subnetMask = virtualNic.spec.ip.subnetMask;
        }
        ipv4page.ipv6Enabled = editHostVnicQueryBinding.isIpv6Enabled;
        String netStackInstanceKey = virtualNic.spec.netStackInstanceKey != null ? virtualNic.spec.netStackInstanceKey : NetStackInstance.SystemStackKey.defaultTcpipStack.toString();
        ipv4page.defaultGateway = EditHostVnicModelAdapter.getIpv4Gateway(editHostVnicQueryBinding, netStackInstanceKey, virtualNic.spec.ipRouteSpec);
        if (virtualNic.spec.ipRouteSpec != null && virtualNic.spec.ipRouteSpec.ipRouteConfig != null && virtualNic.spec.ipRouteSpec.ipRouteConfig.defaultGateway != null) {
            ipv4page.isGatewayOverriden = true;
        }
        ipv4page.dnsServers = EditHostVnicModelAdapter.getDnsServers(editHostVnicQueryBinding, netStackInstanceKey);
        ipv4page.isGatewayFeatureSupported = editHostVnicQueryBinding.isGatewayFeatureSupported;
        return ipv4page;
    }

    public static EditIpv6PageModel createIpv6PageModel(EditHostVnicQueryBinding editHostVnicQueryBinding, VirtualNic virtualNic) {
        Validate.notNull((Object)((Object)editHostVnicQueryBinding), (String)EDIT_HOST_VNIC_QUERY_BINDING_IS_NULL);
        Validate.notNull((Object)virtualNic, (String)VIRTUAL_NIC_IS_NULL);
        Validate.notNull((Object)virtualNic.spec, (String)VIRTUAL_NIC_SPEC_IS_NULL);
        EditIpv6PageModel ipv6PageModel = new EditIpv6PageModel();
        if (virtualNic.spec.ip != null && virtualNic.spec.ip.ipV6Config != null) {
            IpConfig.IpV6AddressConfiguration ipv6Config = virtualNic.spec.ip.ipV6Config;
            ipv6PageModel.dhcpEnabled = ipv6Config.dhcpV6Enabled;
            ipv6PageModel.autoConfigEnabled = ipv6Config.autoConfigurationEnabled;
            Object[] ipV6Address = ipv6Config.ipV6Address;
            ArrayList<Ipv6ListItem> ipV6AddressList = new ArrayList<Ipv6ListItem>();
            if (!ArrayUtils.isEmpty((Object[])ipV6Address)) {
                for (int i = 0; i < ipV6Address.length; ++i) {
                    if (!IpConfig.IpV6AddressConfigType.manual.name().equals(((IpConfig.IpV6Address)ipV6Address[i]).origin)) continue;
                    Ipv6ListItem ipv6ListItem = new Ipv6ListItem();
                    ipv6ListItem.address = ((IpConfig.IpV6Address)ipV6Address[i]).ipAddress;
                    ipv6ListItem.prefixLength = String.valueOf(((IpConfig.IpV6Address)ipV6Address[i]).prefixLength);
                    ipV6AddressList.add(ipv6ListItem);
                }
            }
            ipv6PageModel.staticIpv6Addresses = ipV6AddressList.toArray(new Ipv6ListItem[ipV6AddressList.size()]);
        }
        if (virtualNic.spec.ipRouteSpec != null && virtualNic.spec.ipRouteSpec.ipRouteConfig != null && virtualNic.spec.ipRouteSpec.ipRouteConfig.ipV6DefaultGateway != null) {
            ipv6PageModel.isGatewayOverridden = true;
        }
        ipv6PageModel.staticIpEnabled = !ArrayUtils.isEmpty((Object[])ipv6PageModel.staticIpv6Addresses);
        ipv6PageModel.defaultGateway = EditHostVnicModelAdapter.getIpv6Gateway(editHostVnicQueryBinding, virtualNic.spec.netStackInstanceKey, virtualNic.spec.ipRouteSpec);
        ipv6PageModel.hostIpAddresses = VnicUtils.getHostIpAddresses(editHostVnicQueryBinding.virtualNics);
        return ipv6PageModel;
    }

    public static VirtualNic findVirtualNicOrThrow(EditHostVnicQueryBinding editHostVnicQueryBinding, String vnicDevice) {
        VirtualNic virtualNic = VnicUtils.getVnicByDevice(editHostVnicQueryBinding.virtualNics, vnicDevice);
        Validate.notNull((Object)virtualNic, (String)VNIC_IS_NOT_FOUND);
        return virtualNic;
    }

    public static EditBindToPnicPageModel createBindToPnicPageModel(VirtualNic virtualNic, ManagedObjectReference dvpgRef) {
        VirtualNic.Specification virtualNicSpec = virtualNic.getSpec();
        EditBindToPnicPageModel bindToPnicPageModel = new EditBindToPnicPageModel();
        if (virtualNicSpec == null) {
            return bindToPnicPageModel;
        }
        bindToPnicPageModel.opaqueNetworkSpec = virtualNicSpec.getOpaqueNetwork();
        bindToPnicPageModel.pinnedPnic = virtualNicSpec.getPinnedPnic();
        bindToPnicPageModel.portgroupRef = dvpgRef;
        return bindToPnicPageModel;
    }

    private static String toIpSettingsOption(IpConfig ipConfig) {
        if (ipConfig == null) {
            return IpSettingsOption.unset.name();
        }
        if (ipConfig.dhcp) {
            return IpSettingsOption.dhcp.name();
        }
        if (StringUtils.isEmpty((CharSequence)ipConfig.ipAddress)) {
            return IpSettingsOption.unset.name();
        }
        return IpSettingsOption.staticIp.name();
    }

    private static int getMtu(Integer mtuInBytes) {
        return mtuInBytes == null || mtuInBytes == 0 ? 1500 : mtuInBytes;
    }

    private static boolean isTrafficConfigurableOnNetStack(boolean isTcpIpStackSupported, String vnicNetStackInstanceKey, RuntimeInfo.NetStackInstanceRuntimeInfo[] netStackInstanceRuntimeInfos, String systemNetStackInstanceKey) {
        boolean isDefaultStack = !isTcpIpStackSupported || VnicUtils.isDefaultNetStackInstance(vnicNetStackInstanceKey);
        return isDefaultStack && !VnicUtils.isNetStackInUse(systemNetStackInstanceKey, netStackInstanceRuntimeInfos);
    }

    private static String getIpv4Gateway(EditHostVnicQueryBinding queryBinding, String vnicNetStackInstanceKey, VirtualNic.IpRouteSpec ipRouteSpec) {
        IpRouteConfig ipConfig = null;
        if (queryBinding.isTcpIpStackSupported) {
            NetStackInstance netStackInstance;
            if (ipRouteSpec != null && ipRouteSpec.ipRouteConfig != null && ipRouteSpec.ipRouteConfig.defaultGateway != null) {
                ipConfig = ipRouteSpec.ipRouteConfig;
            } else if (queryBinding.netStackInstance != null && (netStackInstance = NetStackUtil.getNetStackInstanceByKey(vnicNetStackInstanceKey, queryBinding.netStackInstance)) != null) {
                ipConfig = netStackInstance.ipRouteConfig;
            }
        } else {
            ipConfig = queryBinding.ipRouteConfig;
        }
        return ipConfig != null ? ipConfig.defaultGateway : null;
    }

    private static String getIpv6Gateway(EditHostVnicQueryBinding queryBinding, String vnicNetStackInstanceKey, VirtualNic.IpRouteSpec ipRouteSpec) {
        IpRouteConfig ipConfig = null;
        if (queryBinding.isTcpIpStackSupported) {
            NetStackInstance netStackInstance;
            if (ipRouteSpec != null && ipRouteSpec.ipRouteConfig != null && ipRouteSpec.ipRouteConfig.ipV6DefaultGateway != null) {
                ipConfig = ipRouteSpec.ipRouteConfig;
            } else if (queryBinding.netStackInstance != null && (netStackInstance = NetStackUtil.getNetStackInstanceByKey(vnicNetStackInstanceKey, queryBinding.netStackInstance)) != null) {
                ipConfig = netStackInstance.ipRouteConfig;
            }
        } else {
            ipConfig = queryBinding.ipRouteConfig;
        }
        return ipConfig != null ? ipConfig.ipV6DefaultGateway : null;
    }

    private static String[] getDnsServers(EditHostVnicQueryBinding queryBinding, String vnicNetStackInstanceKey) {
        if (!NetStackUtil.isDefaultNetStackInstance(vnicNetStackInstanceKey)) {
            return null;
        }
        DnsConfig dnsConfig = null;
        if (queryBinding.isTcpIpStackSupported) {
            NetStackInstance netStackInstance;
            if (queryBinding.netStackInstance != null && (netStackInstance = NetStackUtil.getNetStackInstanceByKey(vnicNetStackInstanceKey, queryBinding.netStackInstance)) != null) {
                dnsConfig = netStackInstance.dnsConfig;
            }
        } else {
            dnsConfig = queryBinding.dnsConfig;
        }
        ArrayList<String> ipv4Servers = new ArrayList<String>();
        if (dnsConfig != null && !ArrayUtils.isEmpty((Object[])dnsConfig.address)) {
            for (String address : dnsConfig.address) {
                if (!IpUtil.isIpv4Valid(address)) continue;
                ipv4Servers.add(address);
            }
        }
        return ipv4Servers.toArray(new String[ipv4Servers.size()]);
    }
}

