/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic.impl;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.host.vnic.impl.EditHostVnicModelAdapter;
import com.vmware.vsphere.client.h5.network.host.vnic.impl.EditHostVnicQueryBinding;
import com.vmware.vsphere.client.h5.network.host.vnic.impl.VnicMtuQueryBinding;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditBindToPnicPageModel;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditHostVnicModel;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditIpv4PageModel;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditIpv6PageModel;
import com.vmware.vsphere.client.h5.network.host.vnic.model.edit.EditPortPropertiesPageModel;
import org.apache.commons.lang.Validate;

public class EditHostVnicPropertyProvider
implements PropertyProviderBean {
    private static final String IS_NSX_PORTGROUP_PROPERTY = "isNsxPortgroup";
    private static final String PORTGROUP_KEY_PROPERTY = "key";
    private static final String PORTGROUP_DVS_UUID_PROPERTY = "dvsUuid";
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;

    public EditHostVnicPropertyProvider(QueryBindingService queryBindingService, QueryService queryService) {
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="editHostVnicModel")
    public EditHostVnicModel getEditHostVnicModel(ManagedObjectReference hostRef, String vnicDevice) {
        Validate.notNull((Object)vnicDevice, (String)"vnicDevice is null");
        EditHostVnicQueryBinding editHostVnicQueryBinding = (EditHostVnicQueryBinding)((Object)this._queryBindingService.prepare(EditHostVnicQueryBinding.class).fetch((Object)hostRef));
        VirtualNic virtualNic = EditHostVnicModelAdapter.findVirtualNicOrThrow(editHostVnicQueryBinding, vnicDevice);
        DvpgNsxData dvpgData = this.getDvpgNsxData(virtualNic);
        VnicMtuQueryBinding vnicMtuQueryBinding = null;
        if (dvpgData != null && dvpgData.dvpgRef != null) {
            vnicMtuQueryBinding = (VnicMtuQueryBinding)((Object)this._queryBindingService.prepare(VnicMtuQueryBinding.class).fetch((Object)dvpgData.dvpgRef));
        }
        EditPortPropertiesPageModel editPortPropertiesPageModel = EditHostVnicModelAdapter.createEditPortPropertiesPageModel(editHostVnicQueryBinding, vnicMtuQueryBinding, virtualNic);
        EditIpv4PageModel editIpv4PageModel = EditHostVnicModelAdapter.createIpv4PageModel(editHostVnicQueryBinding, virtualNic);
        EditIpv6PageModel editIpv6PageModel = EditHostVnicModelAdapter.createIpv6PageModel(editHostVnicQueryBinding, virtualNic);
        ManagedObjectReference dvpgRef = dvpgData != null && dvpgData.isNsxPortgroup ? dvpgData.dvpgRef : null;
        EditBindToPnicPageModel editBindToPnicPageModel = EditHostVnicModelAdapter.createBindToPnicPageModel(virtualNic, dvpgRef);
        EditHostVnicModel editHostVnicModel = new EditHostVnicModel();
        editHostVnicModel.editPortPropertiesPageModel = editPortPropertiesPageModel;
        editHostVnicModel.editIpv4PageModel = editIpv4PageModel;
        editHostVnicModel.editIpv6PageModel = editIpv6PageModel;
        editHostVnicModel.editBindToPnicPageModel = editBindToPnicPageModel;
        return editHostVnicModel;
    }

    private DvpgNsxData getDvpgNsxData(VirtualNic virtualNic) {
        if (virtualNic.spec != null && virtualNic.spec.distributedVirtualPort != null && virtualNic.spec.distributedVirtualPort.portgroupKey != null && virtualNic.spec.distributedVirtualPort.switchUuid != null) {
            DvpgNsxData dvpgNsxData = new DvpgNsxData();
            ResultSet dvpgResult = this._queryService.select(new String[]{"@modelKey", IS_NSX_PORTGROUP_PROPERTY}).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(PORTGROUP_KEY_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)virtualNic.spec.distributedVirtualPort.portgroupKey), new PropertyPredicate(PORTGROUP_DVS_UUID_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)virtualNic.spec.distributedVirtualPort.switchUuid)}).fetch();
            if (!dvpgResult.getItems().isEmpty()) {
                dvpgNsxData.isNsxPortgroup = (Boolean)((ResourceItem)dvpgResult.getItems().get(0)).get(IS_NSX_PORTGROUP_PROPERTY);
                dvpgNsxData.dvpgRef = (ManagedObjectReference)((ResourceItem)dvpgResult.getItems().get(0)).get("@modelKey");
            }
            return dvpgNsxData;
        }
        return null;
    }

    public class DvpgNsxData {
        public boolean isNsxPortgroup;
        public ManagedObjectReference dvpgRef;
    }
}

