/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic.impl;

import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.OpaqueNetworkInfo;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vim.host.VirtualNicManagerInfo;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvpg.api.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.dvportgroup.impl.DvPortgroupParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.DvPortgroupData;
import com.vmware.vsphere.client.h5.network.host.netstack.NetStackUtil;
import com.vmware.vsphere.client.h5.network.host.portgroup.PortGroupParser;
import com.vmware.vsphere.client.h5.network.host.vnic.VnicConnectionType;
import com.vmware.vsphere.client.h5.network.host.vnic.impl.VnicUtils;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostNetworkData;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostVnicItem;
import com.vmware.vsphere.client.h5.network.util.IpUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class VnicParser {
    private static final String OPAQUE_NETWORK_KEY_SEPARATOR = "-";
    private static final int VNIC_DEVICE_LENGTH = "vmk".length();

    public static List<HostVnicItem> parse(HostNetworkData hostNetworkData) {
        ArrayList<HostVnicItem> vnics = new ArrayList<HostVnicItem>();
        Map<String, String> opaqueNetworkToOpaqueSwitchNameMap = VnicParser.getOpaqueNetworkToOpaqueSwitchNameMap(hostNetworkData.networkInfo);
        if (hostNetworkData.networkInfo != null && hostNetworkData.networkInfo.vnic != null) {
            HashSet<String> nsxPortgroupKeys = new HashSet<String>();
            if (hostNetworkData.dvPortgroupData != null) {
                for (DvPortgroupData dvPortgroupData : hostNetworkData.dvPortgroupData) {
                    if (!dvPortgroupData.isNsxPortgroup || dvPortgroupData.dvsPolicyData == null) continue;
                    String dvpgIdentifier = VnicParser.getNsxPortgroupIdentifier(dvPortgroupData.key, dvPortgroupData.dvsPolicyData.dvsUuid);
                    nsxPortgroupKeys.add(dvpgIdentifier);
                }
            }
            for (DvPortgroupData dvPortgroupData : hostNetworkData.networkInfo.vnic) {
                HostVnicItem vnic = VnicParser.buildVnic((VirtualNic)dvPortgroupData, hostNetworkData, opaqueNetworkToOpaqueSwitchNameMap, nsxPortgroupKeys);
                vnics.add(vnic);
            }
        }
        VnicParser.sortVnicItems(vnics);
        return vnics;
    }

    public static HostNetworkDetailsData parseVnicDetails(HostNetworkData hostNetworkData, VirtualNic virtualNic) {
        if (virtualNic == null || hostNetworkData == null) {
            return null;
        }
        HostNetworkDetailsData result = new HostNetworkDetailsData();
        result.device = virtualNic.device;
        if (!(virtualNic.spec.distributedVirtualPort != null && virtualNic.spec.distributedVirtualPort.portgroupKey != null || VnicParser.isConnectedToOpaqueNetwork(virtualNic, hostNetworkData))) {
            PortGroup vnicPortGroup = PortGroupParser.getPortGroupByName(hostNetworkData.networkInfo.portgroup, virtualNic.portgroup);
            result.portPolicy = PortGroupParser.getPortPolicy(vnicPortGroup, hostNetworkData.networkInfo);
            result.showVlanId = true;
            result.vlanId = vnicPortGroup != null ? vnicPortGroup.spec.vlanId : 0;
        } else if (virtualNic.spec.distributedVirtualPort != null && virtualNic.spec.distributedVirtualPort.portgroupKey != null) {
            DvPortgroupData dvPortgroupData = DvPortgroupParser.getDistributedPortGroupData(virtualNic.spec.distributedVirtualPort.portgroupKey, virtualNic.spec.distributedVirtualPort.switchUuid, hostNetworkData.dvPortgroupData);
            result.portPolicy = DvPortgroupParser.getPortPolicy(dvPortgroupData);
            result.showVlanId = false;
            result.dvPortgroup = true;
        }
        if (hostNetworkData.hostVnicSupportedFeatures != null && hostNetworkData.hostVnicSupportedFeatures.isTcpIpStackSupported) {
            result.showNetworkStack = true;
            result.networkStack = VnicParser.extractNetworkStackName(virtualNic, hostNetworkData);
        } else {
            result.showNetworkStack = false;
        }
        result.networkLabel = VnicParser.extractNetworkLabel(virtualNic, hostNetworkData);
        result.pinnedPnic = VnicParser.extractPinnedPnic(virtualNic, hostNetworkData.dvPortgroupData);
        result.enabledServices = new HostNetworkDetailsData.EnabledServices();
        result.enabledServices.isManagementTrafficEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.management, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isVmotionEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.vmotion, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isFtEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.faultToleranceLogging, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isVsanEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.vsan, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isProvisioningNfcTrafficEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.vSphereProvisioning, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isVrTrafficEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.vSphereReplication, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isVrNfcTrafficEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.vSphereReplicationNFC, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isVsanWitnessTrafficEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.vsanWitness, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isVsphereBackupNfcTrafficEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.vSphereBackupNFC, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isNvmeTcpTrafficEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.nvmeTcp, hostNetworkData.vnicManagerInfo);
        result.enabledServices.isNvmeRdmaTrafficEnabled = VnicParser.isTrafficEnabled(virtualNic, VirtualNicManager.NicType.nvmeRdma, hostNetworkData.vnicManagerInfo);
        result.mac = virtualNic.spec.mac;
        result.mtu = virtualNic.spec.mtu != null ? virtualNic.spec.mtu : 0;
        result.ipProperties = VnicParser.getIpProperties(virtualNic, hostNetworkData);
        return result;
    }

    public static boolean isVsanWitnessTrafficSupported(VirtualNicManagerInfo virtualNicManagerInfo) {
        return VnicParser.isTrafficSupported(virtualNicManagerInfo, VirtualNicManager.NicType.vsanWitness);
    }

    public static boolean isVsphereBackupNfcTrafficSupported(VirtualNicManagerInfo virtualNicManagerInfo) {
        return VnicParser.isTrafficSupported(virtualNicManagerInfo, VirtualNicManager.NicType.vSphereBackupNFC);
    }

    public static boolean isNvmeTcpTrafficSupported(VirtualNicManagerInfo virtualNicManagerInfo) {
        return VnicParser.isTrafficSupported(virtualNicManagerInfo, VirtualNicManager.NicType.nvmeTcp);
    }

    public static boolean isNvmeRdmaTrafficSupported(VirtualNicManagerInfo virtualNicManagerInfo) {
        return VnicParser.isTrafficSupported(virtualNicManagerInfo, VirtualNicManager.NicType.nvmeRdma);
    }

    private static boolean isTrafficSupported(VirtualNicManagerInfo virtualNicManagerInfo, VirtualNicManager.NicType nicType) {
        if (virtualNicManagerInfo == null || virtualNicManagerInfo.netConfig == null) {
            return false;
        }
        for (VirtualNicManager.NetConfig netConfig : virtualNicManagerInfo.netConfig) {
            if (!netConfig.nicType.equals(nicType.name())) continue;
            return true;
        }
        return false;
    }

    private static HostNetworkDetailsData.IpProperties getIpProperties(VirtualNic vnic, HostNetworkData hostNetworkData) {
        HostNetworkDetailsData.IpProperties ipProperties = new HostNetworkDetailsData.IpProperties();
        ipProperties.hasIpv4Settings = IpUtil.hasAnyIpv4Settings(vnic.spec.ip);
        boolean bl = ipProperties.ipv4DhcpEnabled = !ipProperties.hasIpv4Settings || vnic.spec.ip.dhcp;
        if (vnic.spec.ip != null) {
            ipProperties.ipv4Address = vnic.spec.ip.ipAddress;
            ipProperties.subnetMask = vnic.spec.ip.subnetMask;
        }
        if (hostNetworkData.hostVnicSupportedFeatures != null && hostNetworkData.hostVnicSupportedFeatures.isTcpIpStackSupported) {
            String netStackInstanceKey = vnic.spec.netStackInstanceKey != null ? vnic.spec.netStackInstanceKey : NetStackInstance.SystemStackKey.defaultTcpipStack.toString();
            NetStackInstance netStackInstance = NetStackUtil.getNetStackInstanceByKey(netStackInstanceKey, hostNetworkData.netStackInstance);
            if (netStackInstance != null) {
                ipProperties.initDefaultGateways(netStackInstance.ipRouteConfig);
                if (netStackInstance.dnsConfig != null && NetStackUtil.isDefaultNetStackInstance(netStackInstance.key)) {
                    ipProperties.dnsServers = netStackInstance.dnsConfig.address;
                    ipProperties.shouldShowDnsServers = true;
                }
            }
            if (vnic.spec != null && vnic.spec.ipRouteSpec != null && vnic.spec.ipRouteSpec.ipRouteConfig != null) {
                if (vnic.spec.ipRouteSpec.ipRouteConfig.defaultGateway != null) {
                    ipProperties.ipv4DefaultGateway = vnic.spec.ipRouteSpec.ipRouteConfig.defaultGateway;
                }
                if (vnic.spec.ipRouteSpec.ipRouteConfig.ipV6DefaultGateway != null) {
                    ipProperties.ipv6DefaultGateway = vnic.spec.ipRouteSpec.ipRouteConfig.ipV6DefaultGateway;
                }
            }
        } else if (hostNetworkData.networkInfo != null) {
            ipProperties.initDefaultGateways(hostNetworkData.networkInfo.ipRouteConfig);
            if (hostNetworkData.networkInfo.dnsConfig != null) {
                ipProperties.dnsServers = hostNetworkData.networkInfo.dnsConfig.address;
                ipProperties.shouldShowDnsServers = true;
            }
        }
        ipProperties.hasIpv6Settings = BooleanUtils.toBoolean((Boolean)hostNetworkData.networkInfo.ipV6Enabled);
        if (ipProperties.hasIpv6Settings && vnic.spec.ip != null && vnic.spec.ip.ipV6Config != null) {
            ipProperties.ipv6DhcpEnabled = BooleanUtils.toBoolean((Boolean)vnic.spec.ip.ipV6Config.dhcpV6Enabled);
            ipProperties.ipv6AutoConfigEnabled = BooleanUtils.toBoolean((Boolean)vnic.spec.ip.ipV6Config.autoConfigurationEnabled);
            ipProperties.formattedIpv6Addresses = IpUtil.formatIpv6Addresses(vnic.spec.ip.ipV6Config.ipV6Address);
        }
        return ipProperties;
    }

    private static boolean isConnectedToOpaqueNetwork(VirtualNic virtualNic, HostNetworkData hostNetworkData) {
        if (virtualNic.spec.opaqueNetwork == null || hostNetworkData.networkInfo == null || hostNetworkData.networkInfo.opaqueNetwork == null) {
            return false;
        }
        String opaqueNetworkId = virtualNic.spec.opaqueNetwork.opaqueNetworkId;
        String opaqueNetworkType = virtualNic.spec.opaqueNetwork.opaqueNetworkType;
        for (OpaqueNetworkInfo opaqueNetwork : hostNetworkData.networkInfo.opaqueNetwork) {
            if (!opaqueNetworkId.equals(opaqueNetwork.opaqueNetworkId) || !opaqueNetworkType.equals(opaqueNetwork.opaqueNetworkType)) continue;
            return true;
        }
        return false;
    }

    private static HostVnicItem buildVnic(VirtualNic rawVnic, HostNetworkData hostNetworkData, Map<String, String> opaqueNetworkToOpaqueSwitchNameMap, Set<String> nsxPortgroupKeys) {
        if (rawVnic.spec == null) {
            return new HostVnicItem();
        }
        VirtualNicManagerInfo vnicInfo = hostNetworkData.vnicManagerInfo;
        HostVnicItem vnicItem = new HostVnicItem();
        vnicItem.device = rawVnic.device != null ? rawVnic.device : "";
        vnicItem.networkStackName = VnicParser.extractNetworkStackName(rawVnic, hostNetworkData);
        vnicItem.firstIpAddress = IpUtil.extractIpAddress(rawVnic);
        vnicItem.isManagementTrafficEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.management, vnicInfo);
        vnicItem.isVmotionEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.vmotion, vnicInfo);
        vnicItem.isFtEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.faultToleranceLogging, vnicInfo);
        vnicItem.isVsanEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.vsan, vnicInfo);
        vnicItem.isProvisioningNfcTrafficEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.vSphereProvisioning, vnicInfo);
        vnicItem.isVrTrafficEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.vSphereReplication, vnicInfo);
        vnicItem.isVrNfcTrafficEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.vSphereReplicationNFC, vnicInfo);
        vnicItem.isVsanWitnessTraficEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.vsanWitness, vnicInfo);
        vnicItem.isVsphereBackupNfcTrafficEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.vSphereBackupNFC, vnicInfo);
        vnicItem.isNvmeTcpTrafficEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.nvmeTcp, vnicInfo);
        vnicItem.isNvmeRdmaTrafficEnabled = VnicParser.isTrafficEnabled(rawVnic, VirtualNicManager.NicType.nvmeRdma, vnicInfo);
        vnicItem.networkLabel = VnicParser.extractNetworkLabel(rawVnic, hostNetworkData);
        if (rawVnic.spec.portgroup != null) {
            vnicItem.virtualSwitch = VnicParser.extractStandardSwitchName(rawVnic, hostNetworkData.networkInfo.getPortgroup());
            vnicItem.connectedTo = VnicConnectionType.STANDARD_NETWORK.toString();
        } else if (rawVnic.spec.distributedVirtualPort != null) {
            vnicItem.virtualSwitch = VnicParser.extractDVSwitchName(rawVnic, hostNetworkData.networkInfo.getProxySwitch());
            String dvpgIdentifier = VnicParser.getNsxPortgroupIdentifier(rawVnic.spec.distributedVirtualPort.portgroupKey, rawVnic.spec.distributedVirtualPort.switchUuid);
            boolean isNsxPort = nsxPortgroupKeys.contains(dvpgIdentifier);
            vnicItem.connectedTo = isNsxPort ? VnicConnectionType.NDVS.toString() : VnicConnectionType.DVS.toString();
            vnicItem.dvPortGroupVlanId = VnicParser.extractVlanIdForDvPortGroup(rawVnic, hostNetworkData);
        } else if (rawVnic.spec.opaqueNetwork != null) {
            vnicItem.virtualSwitch = VnicParser.getOpaqueSwitchName(rawVnic, opaqueNetworkToOpaqueSwitchNameMap);
            vnicItem.connectedTo = VnicConnectionType.OPAQUE_NETWORK.toString();
        }
        return vnicItem;
    }

    private static String extractNetworkLabel(VirtualNic rawVnic, HostNetworkData hostNetworkData) {
        if (rawVnic.spec.portgroup != null) {
            return rawVnic.spec.portgroup;
        }
        if (rawVnic.spec.distributedVirtualPort != null) {
            return VnicParser.getDistributedVirtualPortgroupName(rawVnic.spec.distributedVirtualPort.portgroupKey, rawVnic.spec.distributedVirtualPort.switchUuid, hostNetworkData.dvPortgroupData);
        }
        if (rawVnic.spec.opaqueNetwork != null) {
            return VnicParser.getOpaqueNetwork(rawVnic.spec.opaqueNetwork.opaqueNetworkId, rawVnic.spec.opaqueNetwork.opaqueNetworkType, hostNetworkData.networkInfo);
        }
        return "";
    }

    private static int extractVlanIdForDvPortGroup(VirtualNic rawVnic, HostNetworkData hostNetworkData) {
        DvPortgroupData dvPortgroupData;
        if (rawVnic.spec.portgroup != null) {
            return 0;
        }
        if (rawVnic.spec.distributedVirtualPort != null && (dvPortgroupData = DvPortgroupParser.getDistributedPortGroupData(rawVnic.spec.distributedVirtualPort.portgroupKey, rawVnic.spec.distributedVirtualPort.switchUuid, hostNetworkData.dvPortgroupData)) != null && dvPortgroupData.defaultPortConfig != null && dvPortgroupData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
            VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortgroupData.defaultPortConfig;
            return VnicParser.getDvPortGroupVlanId(vmwarePortConfig);
        }
        return 0;
    }

    private static int getDvPortGroupVlanId(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePortConfig) {
        if (vmwarePortConfig.vlan instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            VmwareDistributedVirtualSwitch.VlanIdSpec vlanIdSpec = (VmwareDistributedVirtualSwitch.VlanIdSpec)vmwarePortConfig.vlan;
            if (vlanIdSpec.vlanId == 0) {
                return 0;
            }
            return vlanIdSpec.vlanId;
        }
        return 0;
    }

    private static String extractPinnedPnic(VirtualNic virtualNic, DvPortgroupData[] dvPortgroupData) {
        if (virtualNic.spec == null) {
            return null;
        }
        if (virtualNic.spec.opaqueNetwork != null || VnicParser.isVnicAssignedToNsxPortgroup(virtualNic, dvPortgroupData)) {
            return virtualNic.spec.pinnedPnic;
        }
        return null;
    }

    private static boolean isVnicAssignedToNsxPortgroup(VirtualNic virtualNic, DvPortgroupData[] dvPortgroupData) {
        String portgroupKey;
        if (virtualNic.spec.distributedVirtualPort != null && dvPortgroupData != null && (portgroupKey = virtualNic.spec.distributedVirtualPort.portgroupKey) != null) {
            for (DvPortgroupData data : dvPortgroupData) {
                if (data == null || !data.isNsxPortgroup || !portgroupKey.equals(data.key)) continue;
                return true;
            }
        }
        return false;
    }

    private static Boolean isTrafficEnabled(VirtualNic rawVnic, VirtualNicManager.NicType nicType, VirtualNicManagerInfo vnicManagerInfo) {
        if (vnicManagerInfo == null || vnicManagerInfo.netConfig == null) {
            return false;
        }
        return VnicUtils.isTrafficEnabled(rawVnic.key, nicType, vnicManagerInfo.netConfig);
    }

    private static String getOpaqueNetwork(String vnicOpaqueNetworkId, String vnicOpaqueNetworkType, NetworkInfo hostNetworkInfo) {
        if (!ArrayUtils.isEmpty((Object[])hostNetworkInfo.opaqueNetwork)) {
            for (OpaqueNetworkInfo hostOpaqueNetwork : hostNetworkInfo.opaqueNetwork) {
                if (!hostOpaqueNetwork.opaqueNetworkId.equals(vnicOpaqueNetworkId) || !hostOpaqueNetwork.opaqueNetworkType.equals(vnicOpaqueNetworkType)) continue;
                return hostOpaqueNetwork.opaqueNetworkName;
            }
        }
        return "";
    }

    private static String getDistributedVirtualPortgroupName(String portgroupKey, String switchUuid, DvPortgroupData[] hostPortgroups) {
        DvPortgroupData dvPortgroupData = DvPortgroupParser.getDistributedPortGroupData(portgroupKey, switchUuid, hostPortgroups);
        return dvPortgroupData == null ? "" : MixedUtil.unescapeVimEntityNameSpecialChars((String)dvPortgroupData.name);
    }

    private static String extractDVSwitchName(VirtualNic rawVnic, HostProxySwitch[] proxySwitches) {
        String vnicDvpSwitchId = rawVnic.spec.distributedVirtualPort.switchUuid;
        if (proxySwitches == null) {
            return null;
        }
        for (HostProxySwitch proxySwitch : proxySwitches) {
            if (!proxySwitch.dvsUuid.equals(vnicDvpSwitchId)) continue;
            return MixedUtil.unescapeVimEntityNameSpecialChars((String)proxySwitch.dvsName);
        }
        return null;
    }

    private static String extractStandardSwitchName(VirtualNic rawVnic, PortGroup[] portGroups) {
        if (portGroups == null) {
            return null;
        }
        for (PortGroup portGroup : portGroups) {
            if (!rawVnic.spec.portgroup.equals(portGroup.spec.getName())) continue;
            return MixedUtil.unescapeVimEntityNameSpecialChars((String)portGroup.spec.getVswitchName());
        }
        return null;
    }

    public static String extractNetworkStackName(VirtualNic rawVnic, HostNetworkData hostNetworkData) {
        if (rawVnic == null || rawVnic.spec == null || hostNetworkData == null || hostNetworkData.hostVnicSupportedFeatures == null || !hostNetworkData.hostVnicSupportedFeatures.isTcpIpStackSupported) {
            return null;
        }
        String netStackInstanceKey = rawVnic.spec.netStackInstanceKey != null ? rawVnic.spec.netStackInstanceKey : NetStackInstance.SystemStackKey.defaultTcpipStack.toString();
        return NetStackUtil.getNetStackInstanceName(NetStackUtil.getNetStackInstanceByKey(netStackInstanceKey, hostNetworkData.netStackInstance));
    }

    private static Map<String, String> getOpaqueNetworkToOpaqueSwitchNameMap(NetworkInfo networkInfo) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (networkInfo == null || networkInfo.opaqueNetwork == null || networkInfo.opaqueSwitch == null) {
            return result;
        }
        block0: for (OpaqueNetworkInfo opaqueNetwork : networkInfo.opaqueNetwork) {
            for (OpaqueSwitch opaqueSwitch : networkInfo.opaqueSwitch) {
                if (!VnicParser.checkOpaqueSwitchOwnership(opaqueNetwork, opaqueSwitch)) continue;
                String opaqueNetworkKey = VnicParser.constructOpaqueNetworkKey(opaqueNetwork.opaqueNetworkId, opaqueNetwork.opaqueNetworkType);
                result.put(opaqueNetworkKey, opaqueSwitch.name);
                continue block0;
            }
        }
        return result;
    }

    private static boolean checkOpaqueSwitchOwnership(OpaqueNetworkInfo opaqueNetwork, OpaqueSwitch opaqueSwitch) {
        Object[] opaqueNetworkZoneIds = opaqueNetwork.pnicZone;
        Object[] opaqueSwitchZones = opaqueSwitch.pnicZone;
        if (ArrayUtils.isEmpty((Object[])opaqueNetworkZoneIds) || ArrayUtils.isEmpty((Object[])opaqueSwitchZones)) {
            return false;
        }
        for (Object opaqueNetworkZoneId : opaqueNetworkZoneIds) {
            boolean found = false;
            for (Object opaqueSwitchZone : opaqueSwitchZones) {
                if (!((String)opaqueNetworkZoneId).equals(((OpaqueSwitch.PhysicalNicZone)opaqueSwitchZone).key)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static String constructOpaqueNetworkKey(String opaqueNetworkId, String opaqueNetworkType) {
        return opaqueNetworkId + OPAQUE_NETWORK_KEY_SEPARATOR + opaqueNetworkType;
    }

    private static String getOpaqueSwitchName(VirtualNic vnic, Map<String, String> opaqueNetworkToOpaqueSwitchNameMap) {
        String opaqueNetworkKey = VnicParser.constructOpaqueNetworkKey(vnic.spec.opaqueNetwork.opaqueNetworkId, vnic.spec.opaqueNetwork.opaqueNetworkType);
        String result = opaqueNetworkToOpaqueSwitchNameMap.get(opaqueNetworkKey);
        if (result == null) {
            result = "";
        }
        return MixedUtil.unescapeVimEntityNameSpecialChars((String)result);
    }

    private static void sortVnicItems(List<HostVnicItem> vnics) {
        Collections.sort(vnics, new Comparator<HostVnicItem>(){

            @Override
            public int compare(HostVnicItem firstVnic, HostVnicItem secondVnic) {
                int vnic2;
                if (StringUtils.isEmpty((CharSequence)firstVnic.device) && StringUtils.isEmpty((CharSequence)secondVnic.device)) {
                    return 0;
                }
                if (StringUtils.isEmpty((CharSequence)firstVnic.device) && StringUtils.isNotEmpty((CharSequence)secondVnic.device)) {
                    return 1;
                }
                if (StringUtils.isNotEmpty((CharSequence)firstVnic.device) && StringUtils.isEmpty((CharSequence)secondVnic.device)) {
                    return -1;
                }
                int vnic1 = Integer.parseInt(firstVnic.device.substring(VNIC_DEVICE_LENGTH));
                return vnic1 < (vnic2 = Integer.parseInt(secondVnic.device.substring(VNIC_DEVICE_LENGTH))) ? -1 : (vnic1 == vnic2 ? 0 : 1);
            }
        });
    }

    private static String getNsxPortgroupIdentifier(String portgroupKey, String dvsUuid) {
        return String.format("%s_%s", portgroupKey, dvsUuid);
    }
}

