/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.wizard.addnetworking;

import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.HostVnicIpv4SettingsSpec;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.StandardNetworkLabelValidateSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VnicSettingsMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(VnicSettingsMutationProvider.class);
    private static final String HOST_PORTGROUPS_PROPERTY = "config.network.portgroup";
    private static final String HOST_VNICS_PROPERTY = "config.network.vnic";
    private final QueryExecutor _queryExecutor;

    public VnicSettingsMutationProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    public ValidationResult validate(ManagedObjectReference objRef, HostVnicIpv4SettingsSpec spec) throws Exception {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = objRef;
        if (StringUtils.isEmpty((CharSequence)spec.ipv4Address)) {
            return validationResult;
        }
        Object[] vnics = (VirtualNic[])this._queryExecutor.getProperty((Object)objRef, HOST_VNICS_PROPERTY);
        if (!ArrayUtils.isEmpty((Object[])vnics)) {
            for (Object vnic : vnics) {
                if (vnic == null || ((VirtualNic)vnic).device == null || ((VirtualNic)vnic).spec == null || ((VirtualNic)vnic).device.equals(spec.vnicName) || ((VirtualNic)vnic).spec.ip == null || ((VirtualNic)vnic).spec.ip.ipAddress == null || !((VirtualNic)vnic).spec.ip.ipAddress.equals(spec.ipv4Address)) continue;
                validationResult.result = this.getIpAddressValidationError(objRef, (VirtualNic)vnic);
                break;
            }
        }
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference hostRef, StandardNetworkLabelValidateSpec spec) throws Exception {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = hostRef;
        try {
            PortGroup[] portGroups = (PortGroup[])this._queryExecutor.getProperty((Object)hostRef, HOST_PORTGROUPS_PROPERTY);
            if (portGroups != null && spec.label != null) {
                for (PortGroup portGroup : portGroups) {
                    if (!spec.label.equals(portGroup.spec.name)) continue;
                    validationResult.result = NetworkStringUtil.getString("hostVnic.networkLabel.duplicateLabelError");
                    return validationResult;
                }
            }
        }
        catch (Exception ex) {
            validationResult.error = ex;
            _logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return validationResult;
    }

    private String getIpAddressValidationError(ManagedObjectReference objRef, VirtualNic vnic) throws Exception {
        if (objRef == null || vnic == null) {
            return null;
        }
        Object[] portgroups = (PortGroup[])this._queryExecutor.getProperty((Object)objRef, HOST_PORTGROUPS_PROPERTY);
        if (ArrayUtils.isEmpty((Object[])portgroups) || StringUtils.isEmpty((CharSequence)vnic.spec.portgroup) || vnic.spec.opaqueNetwork != null) {
            return NetworkStringUtil.getString("vnicData.alreadyUsedIpAddressDvsOrOpaque", vnic.device);
        }
        String portgroupName = StringUtils.trim((String)vnic.spec.portgroup);
        for (Object portgroup : portgroups) {
            if (((PortGroup)portgroup).spec == null || !portgroupName.equals(((PortGroup)portgroup).spec.name)) continue;
            return NetworkStringUtil.getString("vnicData.alreadyUsedIpAddressVswitch", portgroupName, ((PortGroup)portgroup).spec.vswitchName);
        }
        return null;
    }
}

