/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.impl;

import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.derivedproperty.DerivedPropertyProviderAdapter;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class NetworkTypeDerivedPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String OPAQUE_NETWORK_TYPE_PROP = "summary.opaqueNetworkType";
    private static final String NETWORK_TYPE_PROP = "networkType";
    private static final String NETWORK_TYPE_FORMATTED = "networkTypeFormatted";
    private static final String NSX_NETWORK_TYPE = "nsx.LogicalSwitch";
    private static final String HOST_NETWORK_TYPE = "HostNetwork";
    private static final String ANY_NETWORK_TYPE = "AnyNetwork";
    private static final int OPAQUE_NETWORK_TYPE_ORDER = 4;
    private static Map<Integer, String> networkTypesMap;

    public NetworkTypeDerivedPropertyProviderAdapter(DataServiceExtensionRegistry registry) {
        networkTypesMap = new HashMap<Integer, String>();
        networkTypesMap.put(1, NetworkStringUtil.getString("network.standard"));
        networkTypesMap.put(2, NetworkStringUtil.getString("network.distributed"));
        networkTypesMap.put(3, NetworkStringUtil.getString("network.uplink"));
        networkTypesMap.put(4, NetworkStringUtil.getString("network.opaque"));
        networkTypesMap.put(5, NetworkStringUtil.getString("network.nsxDistributed"));
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        DerivedPropertyInfo opaqueNetworkPropInfo = this.createDerivedPropertyInfo(new String[]{NETWORK_TYPE_PROP, OPAQUE_NETWORK_TYPE_PROP});
        DerivedPropertyInfo genericNetworkPropInfo = this.createDerivedPropertyInfo(new String[]{NETWORK_TYPE_PROP});
        TypeInfo opaqueNetworkTypeInfo = this.createTypeInfo(OpaqueNetwork.class.getSimpleName(), opaqueNetworkPropInfo);
        TypeInfo distributedPortgroupTypeInfo = this.createTypeInfo(DistributedVirtualPortgroup.class.getSimpleName(), genericNetworkPropInfo);
        TypeInfo standardNetworkTypeInfo = this.createTypeInfo(Network.class.getSimpleName(), genericNetworkPropInfo);
        TypeInfo anyNetworkTypeInfo = this.createTypeInfo(ANY_NETWORK_TYPE, genericNetworkPropInfo);
        TypeInfo hostNetworkTypeInfo = this.createTypeInfo(HOST_NETWORK_TYPE, genericNetworkPropInfo);
        return new TypeInfo[]{opaqueNetworkTypeInfo, standardNetworkTypeInfo, distributedPortgroupTypeInfo, anyNetworkTypeInfo, hostNetworkTypeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Object[] objects = propertyRequest.objects;
        if (ArrayUtils.isEmpty((Object[])objects)) {
            return null;
        }
        Set<String> requestedProperties = this.getRequestedProperties(propertyRequest);
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        if (sourcePropertyValues != null) {
            for (Object object : objects) {
                Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(object);
                if (sourcePropertyValuesMap == null) continue;
                ResultItem resultItem = new ResultItem();
                resultItem.resourceObject = object;
                ArrayList<PropertyValue> resultProperties = new ArrayList<PropertyValue>();
                if (requestedProperties.contains(NETWORK_TYPE_FORMATTED)) {
                    String formattedNetworkType = this.formatNetworkType(sourcePropertyValuesMap);
                    resultProperties.add(this.createPropertyValue(NETWORK_TYPE_FORMATTED, resultItem.resourceObject, formattedNetworkType));
                }
                resultItem.properties = resultProperties.toArray(new PropertyValue[resultProperties.size()]);
                resultItems.add(resultItem);
            }
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private PropertyValue createPropertyValue(String propertyName, Object resourceObject, String value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = propertyName;
        propertyValue.resourceObject = resourceObject;
        propertyValue.value = value;
        return propertyValue;
    }

    private Set<String> getRequestedProperties(PropertyRequestSpec propertyRequestSpec) {
        HashSet<String> requestedProperties = new HashSet<String>();
        if (ArrayUtils.isEmpty((Object[])propertyRequestSpec.properties)) {
            return requestedProperties;
        }
        for (PropertySpec propertySpec : propertyRequestSpec.properties) {
            if (propertySpec == null || ArrayUtils.isEmpty((Object[])propertySpec.propertyNames)) continue;
            requestedProperties.addAll(Arrays.asList(propertySpec.propertyNames));
        }
        return requestedProperties;
    }

    private String formatNetworkType(Map<String, Object> sourcePropertyValuesMap) {
        int networkType = (Integer)NetworkTypeDerivedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, NETWORK_TYPE_PROP);
        String formattedNetworkType = networkTypesMap.get(networkType);
        if (networkType == 4) {
            String opaqueNetworkType = (String)NetworkTypeDerivedPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, OPAQUE_NETWORK_TYPE_PROP);
            formattedNetworkType = NSX_NETWORK_TYPE.equals(opaqueNetworkType) ? NetworkStringUtil.getString("network.nsxOpaque") : formattedNetworkType;
        }
        return formattedNetworkType;
    }

    private DerivedPropertyInfo createDerivedPropertyInfo(String[] sourcePropertyNames) {
        DerivedPropertyInfo derivedPropertyInfo = new DerivedPropertyInfo();
        derivedPropertyInfo.propertyName = NETWORK_TYPE_FORMATTED;
        derivedPropertyInfo.sourcePropertyNames = sourcePropertyNames;
        return derivedPropertyInfo;
    }

    private TypeInfo createTypeInfo(String type2, DerivedPropertyInfo derivedPropertyInfo) {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = type2;
        typeInfo.properties = new String[]{NETWORK_TYPE_FORMATTED};
        typeInfo.derivedProperties = new DerivedPropertyInfo[]{derivedPropertyInfo};
        return typeInfo;
    }

    private static <T> T getPropertyValue(Map<String, Object> propertyValuesMap, String propName) {
        return (T)propertyValuesMap.get(propName);
    }
}

