/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.certificates;

import com.vmware.vim.binding.vim.CertificateManager;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationEffect;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.host.certificates.HostCertificateOpSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostCertificateOpManager {
    private static final Log _logger = LogFactory.getLog(HostCertificateOpManager.class);

    public static OperationResult[] applyCertificateOp(ManagedObjectReference[] hostRefs, HostCertificateOpSpec spec) {
        OperationResult result = null;
        if (ArrayUtils.isEmpty((Object[])hostRefs) || spec == null) {
            result = new OperationResult();
            String errorMsg = LocalizationUtil.getLocalizedMessage((String)"error.hostCertificateInputError");
            result.error = new IllegalArgumentException(errorMsg);
            return new OperationResult[]{result};
        }
        if (spec.certOpType == HostCertificateOpSpec.CertificateOpType.refresh) {
            result = HostCertificateOpManager.refresh(hostRefs);
        }
        if (spec.certOpType == HostCertificateOpSpec.CertificateOpType.refreshCACertificates) {
            result = HostCertificateOpManager.refreshCACertificates(hostRefs);
        }
        if (spec.certOpType == HostCertificateOpSpec.CertificateOpType.revoke) {
            result = HostCertificateOpManager.revoke(hostRefs);
        }
        return new OperationResult[]{result};
    }

    private static OperationResult refresh(ManagedObjectReference[] hostRefs) {
        OperationResult result = new OperationResult();
        result.effect = new OperationEffect();
        result.effect.affectedEntites = hostRefs;
        Map<String, List<ManagedObjectReference>> serverGuidToMorMap = HostCertificateOpManager.createServerGuidToMorMap(hostRefs);
        try {
            for (Map.Entry<String, List<ManagedObjectReference>> entry : serverGuidToMorMap.entrySet()) {
                String serverGuid = entry.getKey();
                List<ManagedObjectReference> hosts = entry.getValue();
                CertificateManager cm = HostCertificateOpManager.getCertificateManager(serverGuid);
                if (cm == null) continue;
                result.entity = cm._getRef();
                result.task = cm.refreshCertificates(hosts.toArray(new ManagedObjectReference[hosts.size()]));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Error occured while refreshing the host certificate. " + ex));
            result.error = ex;
        }
        return result;
    }

    private static OperationResult refreshCACertificates(ManagedObjectReference[] hostRefs) {
        OperationResult result = new OperationResult();
        result.effect = new OperationEffect();
        result.effect.affectedEntites = hostRefs;
        Map<String, List<ManagedObjectReference>> serverGuidToMorMap = HostCertificateOpManager.createServerGuidToMorMap(hostRefs);
        try {
            for (Map.Entry<String, List<ManagedObjectReference>> entry : serverGuidToMorMap.entrySet()) {
                String serverGuid = entry.getKey();
                List<ManagedObjectReference> hosts = entry.getValue();
                CertificateManager cm = HostCertificateOpManager.getCertificateManager(serverGuid);
                if (cm == null) continue;
                result.entity = cm._getRef();
                result.task = cm.refreshCACertificatesAndCRLs(hosts.toArray(new ManagedObjectReference[hosts.size()]));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Error occured while refreshing the host CA certificates. " + ex));
            result.error = ex;
        }
        return result;
    }

    private static OperationResult revoke(ManagedObjectReference[] hostRefs) {
        OperationResult result = new OperationResult();
        result.effect = new OperationEffect();
        result.effect.affectedEntites = hostRefs;
        Map<String, List<ManagedObjectReference>> serverGuidToMorMap = HostCertificateOpManager.createServerGuidToMorMap(hostRefs);
        try {
            for (Map.Entry<String, List<ManagedObjectReference>> entry : serverGuidToMorMap.entrySet()) {
                String serverGuid = entry.getKey();
                List<ManagedObjectReference> hosts = entry.getValue();
                CertificateManager cm = HostCertificateOpManager.getCertificateManager(serverGuid);
                if (cm != null) {
                    result.entity = cm._getRef();
                    result.task = cm.revokeCertificates(hosts.toArray(new ManagedObjectReference[hosts.size()]));
                    continue;
                }
                _logger.error((Object)"Certificate Manager was null.");
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Error occured while revoking the host certificate. " + ex));
            result.error = ex;
        }
        return result;
    }

    private static CertificateManager getCertificateManager(String serverGuid) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        if (vcService == null) {
            return null;
        }
        ServiceInstance serviceInstance = vcService.getServiceInstance();
        if (serviceInstance == null) {
            return null;
        }
        ServiceInstanceContent serviceContent = serviceInstance.retrieveContent();
        if (serviceContent == null || serviceContent.certificateManager == null) {
            return null;
        }
        return (CertificateManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.certificateManager);
    }

    private static Map<String, List<ManagedObjectReference>> createServerGuidToMorMap(ManagedObjectReference[] mors) {
        HashMap<String, List<ManagedObjectReference>> serverGuidToMorMap = new HashMap<String, List<ManagedObjectReference>>();
        for (ManagedObjectReference mor : mors) {
            String serverGuid = mor.getServerGuid();
            List morObjsForGuid = null;
            morObjsForGuid = serverGuidToMorMap.containsKey(serverGuid) ? (List)serverGuidToMorMap.get(serverGuid) : new ArrayList();
            morObjsForGuid.add(mor);
            serverGuidToMorMap.put(serverGuid, morObjsForGuid);
        }
        return serverGuidToMorMap;
    }
}

