/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.connection;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.ConnectSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationEffect;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.host.connection.api.HostConnectionStateSpec;
import com.vmware.vsphere.client.host.impl.DisconnectQueryObject;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostConnectionOpManager {
    private static final Log _logger = LogFactory.getLog(HostConnectionOpManager.class);
    private static final ValidationResult[] EMPTY_VALIDATION_RESULTS = new ValidationResult[0];

    public static OperationResult applyConnectionOp(ManagedObjectReference hostRef, HostConnectionStateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            result = HostConnectionOpManager.applyConnectionOp(host, spec, result);
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private static OperationResult applyConnectionOp(HostSystem host, HostConnectionStateSpec spec, OperationResult result) {
        try {
            if (spec.connectionOpType == HostConnectionStateSpec.ConnectionOpType.connect) {
                ConnectSpec connectSpec = null;
                if (spec.connectSpec == null) {
                    connectSpec = new ConnectSpec();
                } else {
                    connectSpec = spec.connectSpec;
                    if (StringUtils.isEmpty((CharSequence)connectSpec.password)) {
                        connectSpec.password = "";
                    }
                }
                result.task = host.reconnect(connectSpec, null);
            } else if (spec.connectionOpType == HostConnectionStateSpec.ConnectionOpType.disconnect) {
                result.task = host.disconnect();
            }
            result.effect = OperationEffect.newDelayedEffect();
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationResult[] validateOnMultiEntity(DataService dataService, ManagedObjectReference[] hostRefs, HostConnectionStateSpec spec) {
        assert (hostRefs != null);
        for (ManagedObjectReference hostRef : hostRefs) {
            assert (hostRef != null);
            assert (!HostSystem.class.getSimpleName().equals(hostRef.getType()));
        }
        assert (dataService != null);
        Class<DisconnectQueryObject> queryDataModel = DisconnectQueryObject.class;
        DataFetchCommand fetchService = DataFetchCommandFactory.getDataFetchCommand((DataService)dataService);
        Collection dataQueryResults = fetchService.execute(queryDataModel, (Object[])hostRefs);
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(hostRefs.length);
        for (DisconnectQueryObject queryResult : dataQueryResults) {
            ValidationResult validationResult = new ValidationResult();
            validationResult.entity = queryResult.provider;
            try {
                if (queryResult.clusterHaEnabled == null) {
                    validationResult.result = false;
                    continue;
                }
                validationResult.result = queryResult.clusterHaEnabled != false && queryResult.inMaintenanceMode == false;
            }
            catch (Exception e) {
                _logger.error((Object)"Error when validating host connection operation", (Throwable)e);
                validationResult.error = MixedUtil.getMethodFault((Throwable)e);
            }
            finally {
                validationResults.add(validationResult);
            }
        }
        return validationResults.toArray(EMPTY_VALIDATION_RESULTS);
    }
}

