/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.dsclusterconnectivity;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vsphere.client.host.dsclusterconnectivity.DatastoreClusterInfo;
import com.vmware.vsphere.client.host.dsclusterconnectivity.DatastoreInfo;
import com.vmware.vsphere.client.host.dsclusterconnectivity.HostDatastoreClusterConnectivityInfo;
import com.vmware.vsphere.client.host.dsclusterconnectivity.HostDatastoreClusterConnectivityInfoService;
import com.vmware.vsphere.client.host.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostDatastoreClusterConnectivityInfoServiceImpl
implements HostDatastoreClusterConnectivityInfoService {
    private static final Log _logger = LogFactory.getLog(HostDatastoreClusterConnectivityInfoServiceImpl.class);
    private static final String PROP_NAME_DATASTORES = "datastore";
    private static final String CLUSTER_DS_CLUSTERS_RELATION = "storagePod";
    private static final String PROP_NAME_DS_CLUSTER_DATASTORES = "childEntity";
    private static final String PROP_NAME_DS_CLUSTER_AND_DATASTORE_NAME = "name";
    private DataService _dataService;

    public HostDatastoreClusterConnectivityInfoServiceImpl(DataService _dataService) {
        this._dataService = _dataService;
    }

    @Override
    public HostDatastoreClusterConnectivityInfo[] getConnectivityInfoForHosts(ManagedObjectReference clusterRef, Object[] hostRefs) throws Exception {
        if (clusterRef == null) {
            _logger.error((Object)"Invalid clusterRef argument received");
            throw new IllegalArgumentException("null clusterRef argument received");
        }
        if (hostRefs == null || hostRefs.length == 0) {
            _logger.error((Object)"Invalid hostRefs argument received");
            throw new IllegalArgumentException("null hostRefs argument received");
        }
        HashSet<ManagedObjectReference> nonNullHostRefs = new HashSet<ManagedObjectReference>();
        for (Object morObj : hostRefs) {
            if (morObj == null || !(morObj instanceof ManagedObjectReference)) continue;
            nonNullHostRefs.add((ManagedObjectReference)morObj);
        }
        if (nonNullHostRefs.size() == 0) {
            throw new IllegalArgumentException("Invalid hostRefs argument received - all references are either null or are not ManagedObjectReference's");
        }
        try {
            DatastoreByHostMap datastoresByHost = this.getDatastoresByHost(nonNullHostRefs.toArray(new ManagedObjectReference[nonNullHostRefs.size()]));
            DatastoreByDsClusterMap datastoresByDsCluster = this.getDatastoresByDsCluster(clusterRef);
            DsClusterDatastoreByHostMap hostsNotConnectedToDsClusters = this.getHostsNotConnectedToDsClusters(datastoresByHost, datastoresByDsCluster);
            HashMap<ManagedObjectReference, String> dsClusterNames = new HashMap<ManagedObjectReference, String>();
            HashMap<ManagedObjectReference, String> datastoreNames = new HashMap<ManagedObjectReference, String>();
            this.populateEntityNames(hostsNotConnectedToDsClusters, dsClusterNames, datastoreNames);
            List<HostDatastoreClusterConnectivityInfo> result = this.getResult(hostsNotConnectedToDsClusters, dsClusterNames, datastoreNames);
            return result.toArray(new HostDatastoreClusterConnectivityInfo[result.size()]);
        }
        catch (Exception e) {
            _logger.error((Object)"Error occured during retrieving of cluster datastorecluster's datastores", (Throwable)e);
            Exception localizedEx = new Exception(Util.getLocalizedString("error.couldNotRetrieveDsClusterConnectivity"), e);
            throw localizedEx;
        }
    }

    private DatastoreByHostMap getDatastoresByHost(Object[] hostRefs) throws Exception {
        DatastoreByHostMap result = new DatastoreByHostMap();
        QuerySpec[] hostQuerySpecs = new QuerySpec[hostRefs.length];
        QuerySpec hostQuerySpec = QueryUtil.buildQuerySpec((Object[])hostRefs, (String[])new String[]{PROP_NAME_DATASTORES});
        RequestSpec hostDatastoresRequestSpec = new RequestSpec();
        hostDatastoresRequestSpec.querySpec = hostQuerySpecs;
        ResultSet hostResultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)hostQuerySpec);
        for (ResultItem item : hostResultSet.items) {
            for (PropertyValue propertyValue : item.properties) {
                ManagedObjectReference[] datastoreRefs = (ManagedObjectReference[])propertyValue.value;
                ManagedObjectReference hostRef = (ManagedObjectReference)propertyValue.resourceObject;
                DatastoreSet hostDatastores = (DatastoreSet)result.get(hostRef);
                if (hostDatastores == null) {
                    hostDatastores = new DatastoreSet();
                    result.put(hostRef, hostDatastores);
                }
                if (datastoreRefs == null) continue;
                Collections.addAll(hostDatastores, datastoreRefs);
            }
        }
        return result;
    }

    private DatastoreByDsClusterMap getDatastoresByDsCluster(ManagedObjectReference clusterRef) throws Exception {
        DatastoreByDsClusterMap datastoresByDsCluster = new DatastoreByDsClusterMap();
        Constraint dsClusterDatastoresConstraint = QueryUtil.createConstraintForRelationship((Object)clusterRef, (String)CLUSTER_DS_CLUSTERS_RELATION, (String)StoragePod.class.getSimpleName());
        QuerySpec dsClustersQuerySpec = QueryUtil.buildQuerySpec((Constraint)dsClusterDatastoresConstraint, (String[])new String[]{PROP_NAME_DS_CLUSTER_DATASTORES});
        ResultSet dsClusterDatastoresResultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)dsClustersQuerySpec);
        for (ResultItem item : dsClusterDatastoresResultSet.items) {
            for (PropertyValue propertyValue : item.properties) {
                ManagedObjectReference[] datastoreRefs = (ManagedObjectReference[])propertyValue.value;
                ManagedObjectReference dsClusterRef = (ManagedObjectReference)propertyValue.resourceObject;
                if (datastoreRefs == null) continue;
                DatastoreSet dsClusterDatastores = new DatastoreSet();
                Collections.addAll(dsClusterDatastores, datastoreRefs);
                datastoresByDsCluster.put(dsClusterRef, dsClusterDatastores);
            }
        }
        return datastoresByDsCluster;
    }

    private DsClusterDatastoreByHostMap getHostsNotConnectedToDsClusters(DatastoreByHostMap datastoresByHost, DatastoreByDsClusterMap datastoresByDsCluster) {
        DsClusterDatastoreByHostMap hostsNotConnectedToDsClusters = new DsClusterDatastoreByHostMap();
        for (ManagedObjectReference hostRef : datastoresByHost.keySet()) {
            DatastoreSet hostDatastores = (DatastoreSet)datastoresByHost.get(hostRef);
            for (ManagedObjectReference dsClusterRef : datastoresByDsCluster.keySet()) {
                DatastoreSet dsClusterDatastores = (DatastoreSet)datastoresByDsCluster.get(dsClusterRef);
                for (ManagedObjectReference dsClusterDatastoreRef : dsClusterDatastores) {
                    DatastoreSet nonConnectedDatastores;
                    if (hostDatastores.contains(dsClusterDatastoreRef)) continue;
                    DatastoreByDsClusterMap nonConnectedDsClusterDatastores = (DatastoreByDsClusterMap)hostsNotConnectedToDsClusters.get(hostRef);
                    if (nonConnectedDsClusterDatastores == null) {
                        nonConnectedDsClusterDatastores = new DatastoreByDsClusterMap();
                        hostsNotConnectedToDsClusters.put(hostRef, nonConnectedDsClusterDatastores);
                    }
                    if (!nonConnectedDsClusterDatastores.containsKey(dsClusterRef)) {
                        nonConnectedDatastores = new DatastoreSet();
                        nonConnectedDsClusterDatastores.put(dsClusterRef, nonConnectedDatastores);
                    } else {
                        nonConnectedDatastores = (DatastoreSet)nonConnectedDsClusterDatastores.get(dsClusterRef);
                    }
                    nonConnectedDatastores.add(dsClusterDatastoreRef);
                }
            }
        }
        return hostsNotConnectedToDsClusters;
    }

    private void populateEntityNames(DsClusterDatastoreByHostMap hostMissingDsClusterConnectivity, Map<ManagedObjectReference, String> dsClusterNames, Map<ManagedObjectReference, String> datastoreNames) throws Exception {
        PropertyValue[] names;
        HashSet entityRefs = new HashSet();
        for (ManagedObjectReference hostRef : hostMissingDsClusterConnectivity.keySet()) {
            Set dsClusterRefs = ((DatastoreByDsClusterMap)hostMissingDsClusterConnectivity.get(hostRef)).keySet();
            Collections.addAll(entityRefs, dsClusterRefs.toArray(new ManagedObjectReference[dsClusterRefs.size()]));
            for (ManagedObjectReference dsClusterRef : dsClusterRefs) {
                Set dsClusterDatastoreRefs = (Set)((DatastoreByDsClusterMap)hostMissingDsClusterConnectivity.get(hostRef)).get(dsClusterRef);
                Collections.addAll(entityRefs, dsClusterDatastoreRefs.toArray(new ManagedObjectReference[dsClusterDatastoreRefs.size()]));
            }
        }
        if (entityRefs.size() == 0) {
            return;
        }
        for (PropertyValue entityName : names = QueryUtil.getProperty((DataService)this._dataService, (Object[])entityRefs.toArray(new ManagedObjectReference[entityRefs.size()]), (String)PROP_NAME_DS_CLUSTER_AND_DATASTORE_NAME)) {
            ManagedObjectReference entityRef = (ManagedObjectReference)entityName.resourceObject;
            if (StoragePod.class.getSimpleName().equals(entityRef.getType())) {
                dsClusterNames.put(entityRef, (String)entityName.value);
                continue;
            }
            if (Datastore.class.getSimpleName().equals(entityRef.getType())) {
                datastoreNames.put(entityRef, (String)entityName.value);
                continue;
            }
            _logger.warn((Object)("An unexpected property received provided from " + entityName.resourceObject));
        }
    }

    private List<HostDatastoreClusterConnectivityInfo> getResult(DsClusterDatastoreByHostMap hostMissingDsClusterConnectivity, Map<ManagedObjectReference, String> dsClusterNames, Map<ManagedObjectReference, String> datastoreNames) {
        ArrayList<HostDatastoreClusterConnectivityInfo> result = new ArrayList<HostDatastoreClusterConnectivityInfo>();
        for (ManagedObjectReference hostRef : hostMissingDsClusterConnectivity.keySet()) {
            HostDatastoreClusterConnectivityInfo info = new HostDatastoreClusterConnectivityInfo();
            info.hostRef = hostRef;
            ArrayList<DatastoreClusterInfo> hostDatastoreClustersList = new ArrayList<DatastoreClusterInfo>();
            DatastoreByDsClusterMap hostDatastoreClusters = (DatastoreByDsClusterMap)hostMissingDsClusterConnectivity.get(hostRef);
            for (ManagedObjectReference dsClusterRef : hostDatastoreClusters.keySet()) {
                DatastoreClusterInfo dsClusterInfo = new DatastoreClusterInfo();
                dsClusterInfo.name = dsClusterNames.get(dsClusterRef);
                dsClusterInfo.ref = dsClusterRef;
                ArrayList<DatastoreInfo> hostDsClusterDatastoresList = new ArrayList<DatastoreInfo>();
                Set hostDsClusterDatastores = (Set)hostDatastoreClusters.get(dsClusterRef);
                for (ManagedObjectReference datastoreRef : hostDsClusterDatastores) {
                    DatastoreInfo datastoreInfo = new DatastoreInfo();
                    datastoreInfo.name = datastoreNames.get(datastoreRef);
                    datastoreInfo.ref = datastoreRef;
                    hostDsClusterDatastoresList.add(datastoreInfo);
                }
                dsClusterInfo.nonConnectedDatastores = hostDsClusterDatastoresList.toArray(new DatastoreInfo[hostDsClusterDatastoresList.size()]);
                hostDatastoreClustersList.add(dsClusterInfo);
            }
            info.nonConnectedDatastoreClusters = hostDatastoreClustersList.toArray(new DatastoreClusterInfo[hostDatastoreClustersList.size()]);
            result.add(info);
        }
        return result;
    }

    private class DsClusterDatastoreByHostMap
    extends HashMap<ManagedObjectReference, DatastoreByDsClusterMap> {
        private static final long serialVersionUID = 1L;

        private DsClusterDatastoreByHostMap() {
        }
    }

    private class DatastoreByDsClusterMap
    extends HashMap<ManagedObjectReference, DatastoreSet> {
        private static final long serialVersionUID = 1L;

        private DatastoreByDsClusterMap() {
        }
    }

    private class DatastoreByHostMap
    extends HashMap<ManagedObjectReference, DatastoreSet> {
        private static final long serialVersionUID = 1L;

        private DatastoreByHostMap() {
        }
    }

    private class DatastoreSet
    extends HashSet<ManagedObjectReference> {
        private static final long serialVersionUID = 1L;

        private DatastoreSet() {
        }
    }
}

