/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.host.ActiveDirectoryAuthentication;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vsphere.client.host.DecodePemFileSpec;
import com.vmware.vsphere.client.host.DomainSettingSpec;
import com.vmware.vsphere.client.host.ImportCertificateInfo;
import com.vmware.vsphere.client.host.SmartCardAuthSettingsSpec;
import com.vmware.vsphere.client.host.util.Util;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthServicesMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(AuthServicesMutationProvider.class);
    private static final String SHA1 = ActiveDirectoryAuthentication.CertificateDigest.SHA1.name();
    private final QueryExecutor _queryExecutor;

    public AuthServicesMutationProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    public ValidationResult validate(ManagedObjectReference ref, DecodePemFileSpec spec) {
        ValidationResult result = new ValidationResult();
        X509Certificate cert = CertificateUtil.decodeCertificate((byte[])spec.file);
        LinkedList<X509Spec> resultList = new LinkedList<X509Spec>();
        X509Spec certSpec = new X509Spec(cert);
        resultList.add(certSpec);
        result.result = resultList;
        return result;
    }

    public OperationResult apply(ManagedObjectReference hostRef, SmartCardAuthSettingsSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        ActiveDirectoryAuthentication ada = null;
        try {
            ada = Util.getActiveDirectoryAuthentication(hostRef, this._queryExecutor);
            if (ada == null) {
                _logger.warn((Object)"Unable to retrieve ActiveDirectoryAuthentication instace.");
                String error = Util.getLocalizedString("error.objectNotFound");
                result.error = MixedUtil.getRuntimeFault((String)error);
                _logger.error((Object)error);
                return result;
            }
        }
        catch (Exception e) {
            _logger.error((Object)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
        LinkedList<MethodFault> errors = new LinkedList<MethodFault>();
        try {
            if (spec.enable != null) {
                if (spec.enable.booleanValue()) {
                    ada.enableSmartCardAuthentication();
                } else {
                    ada.disableSmartCardAuthentication();
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            errors.add(MixedUtil.getMethodFault((Throwable)exception));
        }
        if (!ArrayUtils.isEmpty((Object[])spec.removeCertificates)) {
            for (X509Spec x509Spec : spec.removeCertificates) {
                try {
                    String algorithm = this.parseCertificateAlgorithm(x509Spec.algorithm);
                    ada.removeSmartCardTrustAnchorByFingerprint(x509Spec.thumbprint, algorithm);
                }
                catch (Exception e) {
                    _logger.error((Object)e);
                    errors.add(MixedUtil.getMethodFault((Throwable)e));
                }
            }
        }
        if (!ArrayUtils.isEmpty((Object[])spec.addCertificates)) {
            for (String string : spec.addCertificates) {
                try {
                    ada.installSmartCardTrustAnchor(string);
                }
                catch (Exception e) {
                    _logger.error((Object)e);
                    errors.add(MixedUtil.getMethodFault((Throwable)e));
                }
            }
        }
        if (errors.size() > 0) {
            if (errors.size() != 1) {
                String string = Util.getLocalizedString("authServiceMutationProvider.multipleErrors");
                result.error = MixedUtil.getRuntimeFault((String)string);
            } else {
                result.error = (Exception)errors.get(0);
            }
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference hostRef, ImportCertificateInfo spec) {
        OperationResult or = new OperationResult();
        or.entity = hostRef;
        try {
            ActiveDirectoryAuthentication ada = Util.getActiveDirectoryAuthentication(hostRef, this._queryExecutor);
            if (ada == null) {
                _logger.warn((Object)"Unable to retrieve ActiveDirectoryAuthentication instace.");
                String error = Util.getLocalizedString("error.objectNotFound");
                or.error = MixedUtil.getRuntimeFault((String)error);
                _logger.error((Object)error);
                return or;
            }
            or.task = ada.importCertificateForCAM(spec.certPath, spec.serverIp);
        }
        catch (Exception e) {
            or.error = MixedUtil.getMethodFault((Throwable)e);
            _logger.error((Object)e);
        }
        return or;
    }

    public OperationResult apply(ManagedObjectReference hostRef, DomainSettingSpec spec) {
        OperationResult or = new OperationResult();
        or.entity = hostRef;
        ActiveDirectoryAuthentication activeDirAuth = null;
        try {
            activeDirAuth = Util.getActiveDirectoryAuthentication(hostRef, this._queryExecutor);
        }
        catch (Exception e) {
            or.error = MixedUtil.getMethodFault((Throwable)e);
            _logger.error((Object)e);
            return or;
        }
        if (activeDirAuth == null) {
            _logger.warn((Object)"Unable to retrieve ActiveDirectoryAuthentication instace.");
            String error = Util.getLocalizedString("error.objectNotFound");
            or.error = MixedUtil.getRuntimeFault((String)error);
            _logger.error((Object)error);
            return or;
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)spec.domain)) {
                if (StringUtils.isEmpty((CharSequence)spec.camServer) && StringUtils.isEmpty((CharSequence)spec.username)) {
                    String error = Util.getLocalizedString("error.authenticationInfoMissing");
                    or.error = MixedUtil.getRuntimeFault((String)error);
                    _logger.error((Object)error);
                    return or;
                }
                or.task = StringUtils.isNotEmpty((CharSequence)spec.camServer) ? activeDirAuth.joinDomainWithCAM(spec.domain, spec.camServer) : activeDirAuth.joinDomain(spec.domain, spec.username, spec.password);
            } else {
                or.task = activeDirAuth.leaveCurrentDomain(true);
            }
        }
        catch (Exception e) {
            or.error = MixedUtil.getMethodFault((Throwable)e);
            _logger.error((Object)e);
        }
        return or;
    }

    private String parseCertificateAlgorithm(String algorithm) {
        if (StringUtils.isEmpty((CharSequence)algorithm)) {
            throw new IllegalArgumentException("algorithm must have value.");
        }
        if (!"SHA-1".equals("SHA-1")) {
            _logger.error((Object)"Default digest algorithm changed, Smart Card trust anchor remove is broken");
        }
        return SHA1;
    }
}

