/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.host.BootDeviceSystem;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.host.config.BootDeviceConfigSpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BootDeviceConfigMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(BootDeviceConfigMutationProvider.class);

    public OperationResult apply(ManagedObjectReference hostRef, BootDeviceConfigSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        try {
            if (spec.rebootAfterApply.booleanValue() && StringUtils.isEmpty((CharSequence)spec.rebootReason)) {
                throw new IllegalArgumentException("Edit boot device options: missing reboot reason");
            }
            this.logRebootReason(hostRef, spec.rebootReason);
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            ConfigManager configManager = host.getConfigManager();
            BootDeviceSystem bootDeviceSystem = (BootDeviceSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)configManager.bootDeviceSystem);
            if (bootDeviceSystem != null) {
                bootDeviceSystem.updateBootDevice(spec.bootDeviceKey);
                if (spec.rebootAfterApply.booleanValue()) {
                    host.reboot(true);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Boot device mutation failed", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private void logRebootReason(ManagedObjectReference hostRef, String reason) throws Exception {
        if (StringUtils.isEmpty((CharSequence)reason)) {
            _logger.info((Object)"Reboot reason is null or empty");
            return;
        }
        VcService vc = VimSessionUtil.getService((String)hostRef.getServerGuid());
        ManagedObjectReference emRef = vc.getServiceInstanceContent().eventManager;
        if (emRef == null) {
            return;
        }
        EventManager em = (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)emRef);
        em.logUserEvent(hostRef, reason);
    }
}

