/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.fault.DvsOperationBulkFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.common.error.ErrorReportService;
import com.vmware.vsphere.client.common.error.ErrorStack;
import com.vmware.vsphere.client.common.error.ErrorStackResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FaultOnHostErrorStackResolver
implements ErrorStackResolver {
    private static final Log _logger = LogFactory.getLog(FaultOnHostErrorStackResolver.class);
    private static String[] _typeNames = new String[]{DvsOperationBulkFault.FaultOnHost.class.getName()};
    private ErrorReportService _errorReportService;
    private DataService _ds;

    public FaultOnHostErrorStackResolver(ErrorReportService errorReportService, DataService ds) {
        this._errorReportService = errorReportService;
        this._ds = ds;
    }

    public String[] getHandledTypeNames() {
        return _typeNames;
    }

    public ErrorStack resolve(VcService s, Object obj) {
        if (obj instanceof DvsOperationBulkFault.FaultOnHost) {
            DvsOperationBulkFault.FaultOnHost faultOnHost = (DvsOperationBulkFault.FaultOnHost)obj;
            ErrorStack errorStack = this._errorReportService.toErrorStack(s, (Object)faultOnHost.fault);
            errorStack.entity = faultOnHost.host;
            errorStack.entityDescription = "Host";
            errorStack.entityName = FaultOnHostErrorStackResolver.getName(this._ds, faultOnHost.host);
            return errorStack;
        }
        return null;
    }

    private static String getName(DataService ds, ManagedObjectReference moRef) {
        QuerySpec query = QueryUtil.buildQuerySpec((Object)moRef, (String[])new String[]{"name"});
        ResultSet result = null;
        try {
            result = QueryUtil.getData((DataService)ds, (QuerySpec)query);
        }
        catch (Exception exp) {
            _logger.error((Object)exp);
        }
        if (result == null || result.items.length == 0) {
            return null;
        }
        Object resultItem = result.items[0].resourceObject;
        if (resultItem instanceof String) {
            return (String)resultItem;
        }
        return null;
    }
}

