/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.host.BootDeviceSystem;
import com.vmware.vim.binding.vim.host.CpuSchedulerSystem;
import com.vmware.vim.binding.vim.host.DateTimeSystem;
import com.vmware.vim.binding.vim.host.DnsConfig;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.ImageConfigManager;
import com.vmware.vim.binding.vim.host.MemoryManagerSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.host.HostDataRetriever;
import com.vmware.vsphere.client.host.HostDataRetrieverException;
import org.apache.commons.lang3.ArrayUtils;

class HostDataRetrieverDsImpl
implements HostDataRetriever {
    private DataService dataService;
    private ManagedObjectReference host;

    public HostDataRetrieverDsImpl(DataService dataService, ManagedObjectReference host) {
        this.host = host;
        this.dataService = dataService;
    }

    @Override
    public DnsConfig getDnsConfig() throws HostDataRetrieverException {
        try {
            return (DnsConfig)this.getHostRelatedProp("configManager.networkSystem", "NetworkSystem", "dnsConfig");
        }
        catch (Exception e) {
            throw (HostDataRetrieverException)new HostDataRetrieverException().initCause(e);
        }
    }

    @Override
    public EnvironmentBrowser getEnvironmentBrowser() throws HostDataRetrieverException {
        try {
            PropertyValue[] props = QueryUtil.getPropertiesForRelatedObjects((DataService)this.dataService, (Object)this.host, (String)"parent", (String)"ComputeResource", (String[])new String[]{"environmentBrowser"});
            ManagedObjectReference ebMor = (ManagedObjectReference)props[0].value;
            return (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)ebMor);
        }
        catch (Exception e) {
            throw (HostDataRetrieverException)new HostDataRetrieverException().initCause(e);
        }
    }

    @Override
    public CpuSchedulerSystem.HyperThreadScheduleInfo getHyperThreadScheduleInfo() throws HostDataRetrieverException {
        try {
            return (CpuSchedulerSystem.HyperThreadScheduleInfo)this.getHostRelatedProp("configManager.cpuScheduler", "CpuSchedulerSystem", "hyperthreadInfo");
        }
        catch (Exception e) {
            throw (HostDataRetrieverException)new HostDataRetrieverException().initCause(e);
        }
    }

    @Override
    public DateTimeSystem getDateTimeSystem() throws HostDataRetrieverException {
        try {
            return (DateTimeSystem)this.getHostMoProp("configManager.dateTimeSystem");
        }
        catch (Exception e) {
            throw (HostDataRetrieverException)new HostDataRetrieverException().initCause(e);
        }
    }

    @Override
    public ImageConfigManager getImageConfigManager() throws HostDataRetrieverException {
        try {
            return (ImageConfigManager)this.getHostMoProp("configManager.imageConfigManager");
        }
        catch (Exception e) {
            throw (HostDataRetrieverException)new HostDataRetrieverException().initCause(e);
        }
    }

    @Override
    public FileSystemMountInfo[] getFileSystemMountInfo() throws HostDataRetrieverException {
        try {
            return (FileSystemMountInfo[])this.getHostRelatedProp("configManager.storageSystem", "StorageSystem", "fileSystemVolumeInfo.mountInfo");
        }
        catch (Exception e) {
            throw (HostDataRetrieverException)new HostDataRetrieverException().initCause(e);
        }
    }

    @Override
    public BootDeviceSystem getBootDeviceSystem() throws HostDataRetrieverException {
        try {
            return (BootDeviceSystem)this.getHostMoProp("configManager.bootDeviceSystem");
        }
        catch (Exception e) {
            throw (HostDataRetrieverException)new HostDataRetrieverException().initCause(e);
        }
    }

    @Override
    public MemoryManagerSystem.ServiceConsoleReservationInfo getServiceConsoleReservationInfo() throws HostDataRetrieverException {
        try {
            MemoryManagerSystem.ServiceConsoleReservationInfo consoleInfo = (MemoryManagerSystem.ServiceConsoleReservationInfo)QueryUtil.getProperty((DataService)this.dataService, (Object)this.host, (String)"config.consoleReservation");
            return consoleInfo;
        }
        catch (Exception e) {
            throw (HostDataRetrieverException)new HostDataRetrieverException().initCause(e);
        }
    }

    private <Type> Type getHostMoProp(String propertyName) throws Exception {
        ManagedObjectReference propMor = (ManagedObjectReference)QueryUtil.getProperty((DataService)this.dataService, (Object)this.host, (String)propertyName);
        return (Type)ManagedObjectUtil.getManagedObject((ManagedObjectReference)propMor);
    }

    private <Type> Type getHostRelatedProp(String relationship, String targetType, String propName) throws Exception {
        Object[] props = QueryUtil.getPropertiesForRelatedObjects((DataService)this.dataService, (Object)this.host, (String)relationship, (String)targetType, (String[])new String[]{propName});
        if (ArrayUtils.isEmpty((Object[])props)) {
            return null;
        }
        return (Type)((PropertyValue)props[0]).value;
    }
}

