/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vim.host.MemoryManagerSystem;
import com.vmware.vim.binding.vim.host.Summary;
import com.vmware.vsphere.client.host.util.Util;
import java.util.HashMap;
import java.util.Map;

public class MemoryConfigFormatter {
    private static final int BYTES_IN_MEGABYTE = 0x100000;
    private ResourceConfigSpec _configSpec = null;
    private Summary.HardwareSummary _hardware = null;
    private MemoryManagerSystem.ServiceConsoleReservationInfo _console = null;
    private MemoryManagerSystem.VirtualMachineReservationInfo _vmReservationInfo = null;

    private MemoryConfigFormatter(Summary.HardwareSummary hardware, ResourceConfigSpec configSpec, MemoryManagerSystem.ServiceConsoleReservationInfo console, MemoryManagerSystem.VirtualMachineReservationInfo vmReservation) {
        this._hardware = hardware;
        this._configSpec = configSpec;
        this._console = console;
        this._vmReservationInfo = vmReservation;
    }

    public static MemoryConfigFormatter newInstance(Summary.HardwareSummary hardware, ResourceConfigSpec configSpec, MemoryManagerSystem.ServiceConsoleReservationInfo console, MemoryManagerSystem.VirtualMachineReservationInfo vmReservation) {
        return new MemoryConfigFormatter(hardware, configSpec, console, vmReservation);
    }

    public Long systemMemory() {
        if (this._hardware == null || this._configSpec == null || this._configSpec.memoryAllocation.reservation == null) {
            return null;
        }
        long consoleReservedInBytes = 0L;
        if (this._console != null) {
            consoleReservedInBytes = this._console.serviceConsoleReserved;
        }
        long totalMemoryInBytes = this._hardware.memorySize;
        long systemMemoryInBytes = totalMemoryInBytes - this._configSpec.memoryAllocation.reservation * 0x100000L - consoleReservedInBytes;
        return systemMemoryInBytes;
    }

    public Long totalMemory() {
        if (this._hardware == null) {
            return null;
        }
        return this._hardware.memorySize;
    }

    public Long vmMemory() {
        if (this._vmReservationInfo != null) {
            return this._vmReservationInfo.virtualMachineReserved;
        }
        if (this._configSpec != null && this._configSpec.memoryAllocation.reservation != null) {
            return this._configSpec.memoryAllocation.reservation * 0x100000L;
        }
        return null;
    }

    public Map<String, Object> consoleMemory() {
        if (this._console == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("consoleReserved", this._console.serviceConsoleReserved);
        result.put("consoleReservedOnRestart", this._console.serviceConsoleReservedCfg);
        return result;
    }

    public String vmAllocationPolicy() {
        if (this._vmReservationInfo == null) {
            return null;
        }
        String result = null;
        if (this._vmReservationInfo.allocationPolicy == "swapMost") {
            result = Util.getLocalizedString("memoryConfig.AllocationPolicy.SwapMost");
        } else if (this._vmReservationInfo.allocationPolicy == "swapNone") {
            result = Util.getLocalizedString("memoryConfig.AllocationPolicy.SwapNone");
        } else if (this._vmReservationInfo.allocationPolicy == "swapSome") {
            result = Util.getLocalizedString("memoryConfig.AllocationPolicy.SwapSome");
        }
        return result;
    }
}

