/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.MemoryManagerSystem;
import com.vmware.vim.binding.vim.host.Summary;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.mutation.MutationMapping;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.host.impl.MemoryConfigFormatter;
import com.vmware.vsphere.client.host.util.Util;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryConfigProvider
implements PropertyProviderBean,
MutationProvider {
    private DataService _dataService;
    private LegacyAuthorizationService _authService;
    private static final Log _logger = LogFactory.getLog(MemoryConfigProvider.class);

    public MemoryConfigProvider(DataService dataService, LegacyAuthorizationService authService) {
        this._dataService = dataService;
        this._authService = authService;
    }

    @type(value="HostSystem")
    public DynamicObject getMemoryConfig(ManagedObjectReference hostRef) throws Exception {
        Summary.HardwareSummary hardware = null;
        ResourceConfigSpec configSpec = null;
        MemoryManagerSystem.ServiceConsoleReservationInfo console = null;
        MemoryManagerSystem.VirtualMachineReservationInfo vmReservation = null;
        PropertyValue[] props = QueryUtil.getProperties((DataService)this._dataService, (Object)hostRef, (String[])new String[]{"summary.hardware", "systemResources.config", "config.consoleReservation", "config.virtualMachineReservation"});
        for (int i = 0; i < props.length; ++i) {
            PropertyValue prop = props[i];
            if ("summary.hardware".equals(prop.propertyName)) {
                hardware = (Summary.HardwareSummary)prop.value;
                continue;
            }
            if ("systemResources.config".equals(prop.propertyName)) {
                configSpec = (ResourceConfigSpec)prop.value;
                continue;
            }
            if ("config.consoleReservation".equals(prop.propertyName)) {
                console = (MemoryManagerSystem.ServiceConsoleReservationInfo)prop.value;
                continue;
            }
            if (!"config.virtualMachineReservation".equals(prop.propertyName)) continue;
            vmReservation = (MemoryManagerSystem.VirtualMachineReservationInfo)prop.value;
        }
        DynamicObject result = new DynamicObject();
        MemoryConfigFormatter formatter = MemoryConfigFormatter.newInstance(hardware, configSpec, console, vmReservation);
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        MemoryConfigProvider.addNonNullValueToList(list, "totalPhysicalMemory", formatter.totalMemory());
        MemoryConfigProvider.addNonNullValueToList(list, "systemPhysicalMemory", formatter.systemMemory());
        MemoryConfigProvider.addNonNullValueToList(list, "vmPhysicalMemory", formatter.vmMemory());
        if (console != null) {
            MemoryConfigProvider.addNonNullValueToList(list, "consolePhysicalMemory", formatter.consoleMemory());
        }
        MemoryConfigProvider.addNonNullValueToList(list, "vmAllocationPhysicalMemory", formatter.vmAllocationPolicy());
        result.properties = list.toArray(new NameValuePair[list.size()]);
        return result;
    }

    @type(value="HostSystem")
    public DynamicObject getPMemConfig(ManagedObjectReference hostRef) throws Exception {
        Long totalPMem = 0L;
        Long availablePMem = 0L;
        PropertyValue[] props = QueryUtil.getProperties((DataService)this._dataService, (Object)hostRef, (String[])new String[]{"hardware.persistentMemoryInfo.capacityInMB", "availablePMem"});
        for (int i = 0; i < props.length; ++i) {
            PropertyValue prop = props[i];
            if ("hardware.persistentMemoryInfo.capacityInMB".equals(prop.propertyName)) {
                totalPMem = (Long)prop.value;
                continue;
            }
            if (!"availablePMem".equals(prop.propertyName)) continue;
            availablePMem = (Long)prop.value;
        }
        DynamicObject result = new DynamicObject();
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        MemoryConfigProvider.addNonNullValueToList(list, "totalPMem", totalPMem);
        MemoryConfigProvider.addNonNullValueToList(list, "availablePMem", availablePMem);
        result.properties = list.toArray(new NameValuePair[list.size()]);
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, property="memoryConfig.@info.immutable")
    public boolean getMemoryConfigImmutable(ManagedObjectReference hostRef) {
        boolean immutable;
        boolean bl = immutable = !Util.checkHostAvailability(hostRef, new String[]{"Host.Config.Memory"}, this._dataService, this._authService);
        if (!immutable) {
            MemoryManagerSystem.ServiceConsoleReservationInfo console = null;
            try {
                console = (MemoryManagerSystem.ServiceConsoleReservationInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"config.consoleReservation");
            }
            catch (Exception ex) {
                _logger.fatal((Object)("Exception caught when retrieving data for " + hostRef.getValue()), (Throwable)ex);
            }
            immutable = console == null;
        }
        return immutable;
    }

    @MutationMapping(type="HostSystem", property="memoryConfig")
    public OperationResult applyMemoryConfig(ManagedObjectReference hostRef, DynamicObject args) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        try {
            Object consolePhysicalMemory = null;
            for (int i = 0; i < args.properties.length; ++i) {
                if (!args.properties[i].name.equals("consolePhysicalMemory")) continue;
                consolePhysicalMemory = args.properties[i].value;
                break;
            }
            if (consolePhysicalMemory == null) {
                _logger.error((Object)"Can't get consolePhysicalMemory property value.");
                return result;
            }
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            ConfigManager configManager = host.getConfigManager();
            MemoryManagerSystem memoryManager = null;
            if (configManager.memoryManager != null) {
                memoryManager = (MemoryManagerSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)configManager.memoryManager);
            }
            long byteValue = 0L;
            byteValue = consolePhysicalMemory instanceof Integer ? (long)((Integer)consolePhysicalMemory).intValue() : ((Double)consolePhysicalMemory).longValue();
            if (memoryManager != null) {
                memoryManager.reconfigureServiceConsoleReservation(byteValue);
            }
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private static void addNonNullValueToList(ArrayList<NameValuePair> list, String key, Object value) {
        if (value == null) {
            return;
        }
        list.add(new NameValuePair(key, value));
    }
}

