/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.host.CpuSchedulerSystem;
import com.vmware.vim.binding.vim.host.Summary;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.host.util.Util;
import java.util.HashMap;
import java.util.Map;

public class ProcessorGeneralConfigFormatter {
    private Summary.HardwareSummary _hardware = null;
    private CpuSchedulerSystem.HyperThreadScheduleInfo _hyper = null;
    private boolean ignoreHtConfig = false;

    private ProcessorGeneralConfigFormatter(Summary.HardwareSummary hardware, CpuSchedulerSystem.HyperThreadScheduleInfo hyper, boolean ignoreHtConfig) {
        this._hardware = hardware;
        this._hyper = hyper;
        this.ignoreHtConfig = ignoreHtConfig;
    }

    public static ProcessorGeneralConfigFormatter newInstance(Summary.HardwareSummary hardware, CpuSchedulerSystem.HyperThreadScheduleInfo hyper, boolean ignoreHtConfig) throws Exception {
        return new ProcessorGeneralConfigFormatter(hardware, hyper, ignoreHtConfig);
    }

    public String cpuModel() {
        if (this._hardware == null) {
            return "";
        }
        return this._hardware.cpuModel;
    }

    public String processorSpeed() {
        if (this._hardware == null) {
            return "";
        }
        String gHz = FormatUtil.getFrequencyFormatted((Number)this._hardware.cpuMhz, (int)2, (long)1000000L, (long)-1L, (boolean)true);
        return gHz;
    }

    public String processorSockets() {
        if (this._hardware == null) {
            return "";
        }
        return Short.toString(this._hardware.numCpuPkgs);
    }

    public String processorCoresPerSocket() {
        if (this._hardware == null) {
            return "";
        }
        if (this._hardware.numCpuPkgs == 0) {
            throw new IllegalArgumentException("HardwareSummary.numCpuPkgs is zero");
        }
        return Short.toString((short)(this._hardware.numCpuCores / this._hardware.numCpuPkgs));
    }

    public String logicalProcessors() {
        if (this._hardware == null) {
            return "";
        }
        return Short.toString(this._hardware.numCpuThreads);
    }

    public Map<String, Object> hyperthreading(ManagedObjectReference hostRef) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (this._hyper == null) {
            return null;
        }
        result.put("htAvailable", this._hyper.available);
        result.put("ht", this._hyper.active);
        result.put("htOnRestart", this._hyper.config && !this.ignoreHtConfig);
        result.put("cpuPolicy", Util.getCpuSchedulerInfoPolicy(hostRef));
        return result;
    }
}

