/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.perfstats;

import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.util.QueryUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class MemoryAvailableForVmRetriever {
    private static final int INSTANCE_INTERVAL = 20;
    private final DataService _dataService;

    public MemoryAvailableForVmRetriever(DataService dataService) {
        Validate.notNull((Object)dataService);
        this._dataService = dataService;
    }

    public double getMemoryAvailableForVm(PerformanceManager perfManager, ManagedObjectReference hostRef) throws Exception {
        Object[] entityMetrics;
        Validate.notNull((Object)hostRef);
        Validate.notNull((Object)perfManager);
        double result = -1.0;
        int counterId = this.getResourceMemConsumedCounterId(perfManager);
        if (counterId != -1 && !ArrayUtils.isEmpty((Object[])(entityMetrics = perfManager.queryStats(new PerformanceManager.QuerySpec[]{this.buildPerfQuerySpec(hostRef, counterId)})))) {
            long systemConsumedMemKB = -1L;
            long vimConsumedMemKB = -1L;
            for (PerformanceManager.MetricSeries s : ((PerformanceManager.EntityMetric)entityMetrics[0]).getValue()) {
                PerformanceManager.IntSeries series = (PerformanceManager.IntSeries)s;
                long latestValue = series.value[series.value.length - 1];
                if (series.getId().getInstance().equals("host/system")) {
                    systemConsumedMemKB = latestValue;
                    continue;
                }
                if (!series.getId().getInstance().equals("host/vim")) continue;
                vimConsumedMemKB = latestValue;
            }
            if (systemConsumedMemKB != -1L && vimConsumedMemKB != -1L) {
                long totalHostMemoryB = ((Number)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"hardware.memorySize")).longValue();
                long availableForVmMemB = totalHostMemoryB - (systemConsumedMemKB + vimConsumedMemKB) * 1024L;
                result = availableForVmMemB / 0x100000L;
            }
        }
        return result;
    }

    private int getResourceMemConsumedCounterId(PerformanceManager perfManager) {
        int counterId = -1;
        for (PerformanceManager.CounterInfo counterInfo : perfManager.getPerfCounter()) {
            if (!counterInfo.getNameInfo().getKey().equals("resourceMemConsumed")) continue;
            counterId = counterInfo.getKey();
            break;
        }
        return counterId;
    }

    private PerformanceManager.QuerySpec buildPerfQuerySpec(ManagedObjectReference hostRef, int counterId) {
        PerformanceManager.QuerySpec querySpec = new PerformanceManager.QuerySpec();
        querySpec.setEntity(hostRef);
        querySpec.setIntervalId(Integer.valueOf(20));
        querySpec.setMetricId(new PerformanceManager.MetricId[]{new PerformanceManager.MetricId(counterId, "host/system"), new PerformanceManager.MetricId(counterId, "host/vim")});
        return querySpec;
    }
}

