/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.h5.impl;

import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.data.uri.resolve.DefaultUriSchemeUtil;
import com.vmware.vsphere.client.common.data.DataProviderAdapterBase;
import com.vmware.vsphere.client.vcextension.common.ExtensionUriSpec;
import com.vmware.vsphere.client.vcextension.util.VcExtensionUtil;
import java.net.URI;
import java.util.ArrayList;

@type(value="VcExtensionEvent")
public class VcExtensionEventSearchProvider
extends DataProviderAdapterBase {
    private final QueryExecutor _queryExecutor;

    public VcExtensionEventSearchProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    protected ResultSet processQuery(CompositeConstraint constraint, QuerySpec parentQuery) throws Exception {
        if (!this.isValidQuery(constraint)) {
            return ResultUtil.newEmptyResultSet();
        }
        ArrayList<PropertyConstraint> clonedConstraints = new ArrayList<PropertyConstraint>(constraint.nestedConstraints.length);
        for (Constraint c : constraint.nestedConstraints) {
            PropertyConstraint pc = (PropertyConstraint)c.clone();
            pc.targetType = Event.class.getSimpleName();
            if (!"info.entity".equals(pc.propertyName)) {
                clonedConstraints.add(pc);
                continue;
            }
            ExtensionUriSpec extensionUri = new ExtensionUriSpec((URI)pc.comparableValue);
            pc.comparableValue = VcExtensionUtil.getVcFolder(extensionUri.getServerGuid());
            clonedConstraints.add(pc);
            pc = new PropertyConstraint();
            pc.propertyName = "info.userList";
            pc.comparator = Comparator.EQUALS;
            pc.comparableValue = new String[]{extensionUri.getKey()};
            pc.targetType = Event.class.getSimpleName();
            clonedConstraints.add(pc);
        }
        CompositeConstraint cc = new CompositeConstraint();
        cc.conjoiner = constraint.conjoiner;
        cc.nestedConstraints = clonedConstraints.toArray(new Constraint[0]);
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = parentQuery.name + "-VcExtensionEventSearchProvider";
        querySpec.resultSpec = parentQuery.resultSpec;
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.constraint = cc;
        querySpec.resourceSpec.propertySpecs = parentQuery.resourceSpec.propertySpecs;
        return this._queryExecutor.getData(querySpec);
    }

    private boolean isValidQuery(CompositeConstraint constraint) {
        if (constraint.nestedConstraints == null || constraint.nestedConstraints.length == 0) {
            return false;
        }
        for (Constraint c : constraint.nestedConstraints) {
            if (!(c instanceof PropertyConstraint)) {
                return false;
            }
            PropertyConstraint pc = (PropertyConstraint)c;
            if (!"VcExtensionEvent".equals(pc.targetType)) {
                return false;
            }
            if (!"info.entity".equals(pc.propertyName)) continue;
            if (!(pc.comparableValue instanceof URI)) {
                return false;
            }
            if (this.isVcExtensionURI((URI)pc.comparableValue)) continue;
            return false;
        }
        return true;
    }

    private boolean isVcExtensionURI(URI uri) {
        if (!uri.toString().startsWith("urn:vri:")) {
            return false;
        }
        String targetType = DefaultUriSchemeUtil.getType((URI)uri);
        return "VcExtension".equals(targetType);
    }
}

