/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vcenter.apigw.api.sso.SsoServiceLocator;
import com.vmware.vim.binding.sso.admin.AuthenticationAccountInfo;
import com.vmware.vim.binding.sso.admin.CertificateManager;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.Domain;
import com.vmware.vim.binding.sso.admin.ExternalDomainSchemaDetails;
import com.vmware.vim.binding.sso.admin.IdentitySource;
import com.vmware.vim.binding.sso.admin.IdentitySourceManagementService;
import com.vmware.vim.binding.sso.admin.IdentitySources;
import com.vmware.vim.binding.sso.admin.LdapIdentitySource;
import com.vmware.vim.binding.sso.admin.LdapIdentitySourceDetails;
import com.vmware.vim.binding.sso.admin.fault.ADIDSAlreadyExistFault;
import com.vmware.vim.binding.sso.admin.fault.DirectoryServiceConnectionFault;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.DomainManagementService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import com.vmware.vsphere.client.sso.admin.model.AuthenticationSpec;
import com.vmware.vsphere.client.sso.admin.model.DomainSpec;
import com.vmware.vsphere.client.sso.admin.model.ExternalDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.LocalOSDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.NativeAdDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.X509UsageSpec;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.encoders.Base64;

public class IdentitySourceDomainManagementService
extends AdminServiceBase
implements DomainManagementService {
    private static final String X_509_CERTIFICATE = "X.509";
    private static final Log _logger = LogFactory.getLog(IdentitySourceDomainManagementService.class);
    public static final String UNKNOWN_DOMAIN = "?";
    private static final String AUTHENTICATION_TYPE_PASSWORD = LdapIdentitySource.AuthenticationType.password.toString();
    private static final String LDAPS_REGEX = "[lL][dD][aA][pP][sS]";
    private ConfigurationService _configurationService;

    public IdentitySourceDomainManagementService(SsoServiceLocator ssoServiceLocator, SsoServiceManager ssoServiceManager, BackendExceptionTransformer transformer, ConfigurationService configurationService) {
        super(ssoServiceLocator, ssoServiceManager, transformer);
        this._configurationService = configurationService;
    }

    public IdentitySourceDomainManagementService(SsoServiceLocator ssoServiceLocator, SsoServiceManager ssoServiceManager, Boolean useSolutionUser, BackendExceptionTransformer transformer) {
        super(ssoServiceLocator, ssoServiceManager, useSolutionUser, transformer);
    }

    public IdentitySourceDomainManagementService(SsoAdminService presetAdminService, ConfigurationService configurationService) {
        super(presetAdminService);
        this._configurationService = configurationService;
    }

    @Override
    public List<DomainSpec> getIdentitySources(boolean populateDefaultDomains) throws Exception {
        try {
            IdentitySource localSource;
            IdentitySources sources = this.getIdentitySourcesInternal();
            LinkedList<DomainSpec> specs = new LinkedList<DomainSpec>();
            IdentitySource systemSource = sources.getSystem();
            if (systemSource != null && systemSource.getName() != null) {
                DomainSpec sysDomainSpec = new DomainSpec();
                sysDomainSpec.domainName = systemSource.getName();
                specs.add(sysDomainSpec);
            }
            if ((localSource = sources.getLocalOS()) != null && localSource.getName() != null) {
                LocalOSDomainSpec localOSDomain = new LocalOSDomainSpec();
                localOSDomain.domainName = localSource.getName();
                specs.add(localOSDomain);
            }
            if (sources.getNativeAD() != null) {
                NativeAdDomainSpec nativeAdDomain = new NativeAdDomainSpec();
                nativeAdDomain.friendlyName = sources.getNativeAD().getName();
                nativeAdDomain.domainName = sources.getNativeAD().getName();
                nativeAdDomain.domainAlias = this.findAliasFor(sources.getNativeAD());
                AuthenticationAccountInfo account = this.getManagementService().getActiveDirectoryAuthnAccountInfo();
                nativeAdDomain.useMachineAccount = account.isUseMachineAccount();
                nativeAdDomain.servicePrincipalName = account.getSpn();
                nativeAdDomain.authenticationSpec = new AuthenticationSpec();
                nativeAdDomain.authenticationSpec.username = account.getUserName();
                specs.add(nativeAdDomain);
            }
            if (sources.getLdaps() != null) {
                for (LdapIdentitySource source : sources.getLdaps()) {
                    ExternalDomainSpec extDomainSpec = IdentitySourceDomainManagementService.createLdapSpec(source);
                    specs.add(extDomainSpec);
                }
            }
            if (populateDefaultDomains) {
                this.updateDefaultDomainInfo(specs);
            }
            return specs;
        }
        catch (Exception e) {
            _logger.error((Object)("Error retrieving domains : " + e.getMessage()), (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    private String findAliasFor(IdentitySource source) {
        String sourceName = source.getName();
        for (Domain domain : source.domains) {
            if (!sourceName.equals(domain.getName())) continue;
            return domain.getAlias();
        }
        return sourceName;
    }

    @Override
    public List<DomainSpec> getDomains() throws Exception {
        try {
            IdentitySources sources = this.getIdentitySourcesInternal();
            LinkedList<DomainSpec> specs = new LinkedList<DomainSpec>();
            IdentitySource systemSource = sources.getSystem();
            if (systemSource != null && systemSource.getName() != null) {
                for (Domain systemDomain : systemSource.domains) {
                    if (!StringUtils.isNotEmpty((CharSequence)systemDomain.getName())) continue;
                    DomainSpec sysDomainSpec = new DomainSpec();
                    sysDomainSpec.domainName = systemDomain.getName();
                    specs.add(sysDomainSpec);
                }
            }
            IdentitySource localSource = sources.getLocalOS();
            if (!this.isGatewayMode() && localSource != null && localSource.getName() != null) {
                LocalOSDomainSpec localOSDomain = new LocalOSDomainSpec();
                localOSDomain.domainName = localSource.getName();
                specs.add(localOSDomain);
            }
            if (sources.getNativeAD() != null) {
                IdentitySource nativeAd = sources.getNativeAD();
                for (Domain domain : nativeAd.domains) {
                    NativeAdDomainSpec nativeAdDomain = new NativeAdDomainSpec();
                    nativeAdDomain.domainName = domain.getName();
                    specs.add(nativeAdDomain);
                }
            }
            if (sources.getLdaps() != null) {
                for (LdapIdentitySource source : sources.getLdaps()) {
                    ExternalDomainSpec extDomainSpec = new ExternalDomainSpec();
                    extDomainSpec.domainName = source.getName();
                    specs.add(extDomainSpec);
                }
            }
            return specs;
        }
        catch (Exception e) {
            _logger.error((Object)("Error retrieving domains : " + e.getMessage()), (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    private void updateDefaultDomainInfo(List<DomainSpec> specs) throws Exception {
        List<String> defaultDomains = this.getDefaultDomains();
        for (DomainSpec spec : specs) {
            spec.isDefault = defaultDomains.contains(spec.domainName);
        }
    }

    private IdentitySources getIdentitySourcesInternal() throws NotAuthenticated, InvalidCredentials, SsoServiceException, ADIDSAlreadyExistFault {
        IdentitySources sources = null;
        try {
            sources = this.getManagementService().get();
        }
        catch (NoPermission e) {
            String systemDomainName = this.getManagementService().getSystemDomainName();
            sources = new IdentitySources();
            sources.system = new IdentitySource(systemDomainName, new Domain[]{new Domain(systemDomainName, systemDomainName)});
        }
        return sources;
    }

    @Override
    public void registerLdapDomain(ExternalDomainSpec domainSpec) throws Exception {
        if (domainSpec == null) {
            throw new IllegalArgumentException("domainSpec");
        }
        try {
            String domainAlias;
            LdapIdentitySourceDetails details = this.createLdapIdsDetails(domainSpec);
            IdentitySourceManagementService.AuthenticationCredentials authCredentials = null;
            if (domainSpec.authenticationSpec != null) {
                authCredentials = this.createAuthenticationCredentails(domainSpec.authenticationSpec);
            }
            if ((domainAlias = domainSpec.domainAlias) != null && domainAlias.trim().isEmpty()) {
                domainAlias = null;
            }
            this.getManagementService().registerLdap(domainSpec.serverType, domainSpec.domainName, domainAlias, details, domainSpec.authenticationSpec.authenticationType, authCredentials);
        }
        catch (Exception e) {
            _logger.error((Object)("Error adding LDAP domains : " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public String[] getExternalDomainsCertificates() throws InvalidCredentials, SsoServiceException {
        HttpSession session = SessionUtil.getHttpSession();
        SsoAdminService adminService = this.getAdminService(session);
        ManagedObjectReference mor = this.getManagementService().getSslCertificateManager();
        CertificateManager certManager = (CertificateManager)adminService.getManagedObject(CertificateManager.class, mor);
        String[] result = certManager.getAllCertificates();
        return result;
    }

    @Override
    public void probeConnectivity(String url, AuthenticationSpec authSpec) throws Exception {
        if (authSpec == null) {
            throw new IllegalArgumentException("authSpec");
        }
        try {
            IdentitySourceManagementService.AuthenticationCredentials authCredentials = this.createAuthenticationCredentails(authSpec);
            this.getManagementService().probeConnectivity(new URI(url), authSpec.authenticationType, authCredentials);
        }
        catch (Exception e) {
            _logger.error((Object)("Error probing connectivity : " + e.getMessage()), (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void removeDomain(String domain) throws Exception {
        try {
            this.getManagementService().delete(domain);
        }
        catch (Exception e) {
            _logger.error((Object)("Error removing domain:" + e.getMessage()), (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void updateActiveDirectoryDomain(NativeAdDomainSpec domainSpec) throws Exception {
        if (domainSpec == null) {
            throw new IllegalArgumentException("The provided NativeAdDomainSpec could not be null");
        }
        try {
            IdentitySourceManagementService service = this.getManagementService();
            String domainName = domainSpec.domainName;
            boolean useMachineAccount = domainSpec.useMachineAccount;
            String username = "";
            String password = "";
            String spn = null;
            if (!useMachineAccount) {
                username = domainSpec.authenticationSpec.username;
                password = domainSpec.authenticationSpec.password;
                spn = domainSpec.servicePrincipalName;
            }
            IdentitySourceManagementService.AuthenticationCredentials authCredentials = new IdentitySourceManagementService.AuthenticationCredentials(username, password, Boolean.valueOf(useMachineAccount), spn);
            service.updateActiveDirectory(domainName, authCredentials, new ExternalDomainSchemaDetails());
        }
        catch (Exception e) {
            _logger.error((Object)("Error updating native AD domain: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateExternalDomain(ExternalDomainSpec domainSpec) throws Exception {
        if (domainSpec == null) {
            throw new IllegalArgumentException("domainSpec");
        }
        try {
            IdentitySourceManagementService service = this.getManagementService();
            if (domainSpec.authenticationSpec != null) {
                IdentitySourceManagementService.AuthenticationCredentials authCredentials = this.createAuthenticationCredentails(domainSpec.authenticationSpec);
                service.updateLdapAuthnType(domainSpec.domainName, domainSpec.authenticationSpec.authenticationType, authCredentials);
            }
            LdapIdentitySourceDetails details = this.createLdapIdsDetails(domainSpec);
            service.updateLdap(domainSpec.domainName, details);
        }
        catch (Exception e) {
            _logger.error((Object)("Error updating LDAP domain: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addExternalDomainCertificate(String certificate) throws Exception {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate");
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(certificate.getBytes());
            CertificateFactory cf = CertificateFactory.getInstance(X_509_CERTIFICATE);
            Certificate c = cf.generateCertificate(stream);
            String content = new String(Base64.encode((byte[])c.getEncoded()));
            HttpSession session = SessionUtil.getHttpSession();
            SsoAdminService adminService = this.getAdminService(session);
            ManagedObjectReference moRef = this.getManagementService().getSslCertificateManager();
            CertificateManager certManager = (CertificateManager)adminService.getManagedObject(CertificateManager.class, moRef);
            certManager.addCertificate(content);
        }
        catch (Exception e) {
            _logger.error((Object)("Error adding LDAP certificate : " + e.getMessage()), (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    public boolean removeExternalDomainCertificate(String thumbprint) throws Exception {
        _logger.debug((Object)("removeExternalDomainCertificate: " + thumbprint));
        try {
            HttpSession session = SessionUtil.getHttpSession();
            SsoAdminService adminService = this.getAdminService(session);
            ManagedObjectReference moRef = this.getManagementService().getSslCertificateManager();
            CertificateManager certManager = (CertificateManager)adminService.getManagedObject(CertificateManager.class, moRef);
            boolean result = certManager.deleteCertificate(thumbprint);
            _logger.debug((Object)("removeExternalDomainCertificate result = " + (result ? "true" : "false")));
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)("Error removing LDAP certificate : " + e.getMessage()), (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public List<String> getDefaultDomains() throws Exception {
        try {
            String[] domains = this.getManagementService().getDefaultDomains();
            if (domains != null) {
                return Arrays.asList(domains);
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            _logger.error((Object)("Error getting default domains : " + e.getMessage()), (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void setDefaultDomains(String[] domainNames) throws Exception {
        try {
            this.getManagementService().setDefaultDomains(domainNames);
        }
        catch (Exception e) {
            _logger.error((Object)("Error setting default domain : " + e.getMessage()), (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void registerLocalOSDomain(String domainName) throws Exception {
        try {
            this.getManagementService().registerLocalOS(domainName);
        }
        catch (Exception e) {
            _logger.error((Object)("Error registering local domain : " + e.getMessage()), (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void registerNativeAd(NativeAdDomainSpec spec) throws Exception {
        String domainName = spec.domainName;
        boolean useMachineAccount = spec.useMachineAccount;
        String username = "";
        String password = "";
        String spn = "";
        if (!useMachineAccount) {
            username = spec.authenticationSpec.username;
            password = spec.authenticationSpec.password;
            spn = spec.servicePrincipalName;
        }
        IdentitySourceManagementService.AuthenticationCredentials authCredentials = new IdentitySourceManagementService.AuthenticationCredentials(username, password, Boolean.valueOf(useMachineAccount), spn);
        try {
            this.getManagementService().registerActiveDirectory(domainName, authCredentials, new ExternalDomainSchemaDetails());
        }
        catch (Exception e) {
            _logger.error((Object)("Error registering local domain : " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public Map<String, String> getExternalDomainsCertificateUsage(X509UsageSpec[] certificateSpecs) throws SsoServiceException, NotAuthenticated, NoPermission, InvalidCredentials, ADIDSAlreadyExistFault {
        HashMap<String, String> domainByThumb = new HashMap<String, String>();
        IdentitySources sources = this.getManagementService().get();
        if (ArrayUtils.isEmpty((Object[])sources.ldaps)) {
            return domainByThumb;
        }
        X509Certificate[] maybeUsedCertificates = this.getExternalDomainCertificates(certificateSpecs);
        String errorToReport = null;
        for (LdapIdentitySource ldapIdentitySource : sources.ldaps) {
            URI domainUri = ldapIdentitySource.getDetails().getPrimaryUrl();
            String scheme = domainUri.getScheme();
            if (!scheme.matches(LDAPS_REGEX)) continue;
            try {
                X509Certificate[] matchingCerts;
                String host = domainUri.getHost();
                int port = domainUri.getPort();
                ConfigurationManagementService.CertificateChain serverChain = this.getManagementService().getSslIdentity(host, port);
                for (X509Certificate x509cert : matchingCerts = this.findValidatingCertificates(maybeUsedCertificates, serverChain.certificates)) {
                    String thumb = CertificateUtil.getThumbprint((Certificate)x509cert);
                    domainByThumb.put(thumb, ldapIdentitySource.getName());
                }
            }
            catch (Exception e) {
                errorToReport = e.getLocalizedMessage();
                _logger.warn((Object)("Error getting LDAP domain certificate usage:" + e.getMessage()));
            }
        }
        if (StringUtils.isEmpty(errorToReport)) {
            return domainByThumb;
        }
        for (X509UsageSpec x509UsageSpec : certificateSpecs) {
            if (domainByThumb.containsKey(x509UsageSpec.thumbprint)) continue;
            domainByThumb.put(x509UsageSpec.thumbprint, UNKNOWN_DOMAIN);
        }
        domainByThumb.put("error", errorToReport);
        return domainByThumb;
    }

    public ConfigurationManagementService.CertificateChain getSslIdentity(URI uri) throws NotAuthenticated, NoPermission, InvalidCredentials, DirectoryServiceConnectionFault, SsoServiceException {
        return this.getManagementService().getSslIdentity(uri.getHost(), uri.getPort());
    }

    public Set<String> getSystemDomains() throws Exception {
        HashSet<String> systemDomainNames = new HashSet<String>();
        try {
            Domain[] systemDomains;
            IdentitySources sources = this.getIdentitySourcesInternal();
            IdentitySource systemSource = sources.getSystem();
            for (Domain systemDomain : systemDomains = systemSource.getDomains()) {
                String systemDomainName = systemDomain.getName();
                String systemDomainAlias = systemDomain.getAlias();
                if (StringUtils.isNotEmpty((CharSequence)systemDomainName)) {
                    systemDomainNames.add(systemDomainName);
                }
                if (!StringUtils.isNotEmpty((CharSequence)systemDomainAlias)) continue;
                systemDomainNames.add(systemDomainAlias);
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error retrieving system domains : " + e.getMessage()), (Throwable)e);
            throw this.transformBackendException(e);
        }
        return systemDomainNames;
    }

    private X509Certificate[] findValidatingCertificates(X509Certificate[] maybeUsedCertificates, String[] serverChain) throws UnsupportedEncodingException, CertificateException, NoSuchAlgorithmException {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        for (String base64cert : serverChain) {
            X509Certificate serverCertificate = (X509Certificate)CertificateUtil.generateCertificate((String)base64cert);
            for (X509Certificate maybeUsedCert : maybeUsedCertificates) {
                if (serverCertificate.equals(maybeUsedCert)) {
                    result.add(maybeUsedCert);
                    continue;
                }
                try {
                    serverCertificate.verify(maybeUsedCert.getPublicKey());
                    result.add(maybeUsedCert);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result.toArray(new X509Certificate[result.size()]);
    }

    private static ExternalDomainSpec createLdapSpec(LdapIdentitySource source) {
        ExternalDomainSpec result = new ExternalDomainSpec();
        result.serverType = source.getType();
        result.domainName = source.getName();
        result.domainAlias = source.getDomains()[0].getAlias();
        if (source.details != null) {
            result.friendlyName = source.getDetails().getFriendlyName();
            result.userBaseDn = source.getDetails().getUserBaseDn();
            result.groupBaseDn = source.getDetails().getGroupBaseDn();
            result.searchTimeoutSeconds = source.getDetails().getSearchTimeoutSeconds();
            if (source.getDetails().getPrimaryUrl() != null) {
                result.primaryUrl = source.getDetails().getPrimaryUrl().toString();
            }
            if (source.getDetails().getFailoverUrl() != null) {
                result.failoverUrl = source.getDetails().getFailoverUrl().toString();
            }
        }
        if (source.authenticationDetails != null) {
            result.authenticationSpec = IdentitySourceDomainManagementService.createAuthenticationSpec(source.getAuthenticationDetails());
        }
        if (source.details.certificates != null) {
            result.certificates = IdentitySourceDomainManagementService.convertCertificates(source.details.certificates);
        }
        return result;
    }

    private static List<X509Spec> convertCertificates(String[] certificates) {
        ArrayList<X509Spec> results = new ArrayList<X509Spec>();
        for (String rawCertificate : certificates) {
            try {
                X509Certificate certificate = CertificateUtil.decodeCertificate((String)rawCertificate);
                X509Spec spec = new X509Spec(certificate);
                results.add(spec);
            }
            catch (UnsupportedEncodingException e) {
                _logger.warn((Object)"Unable to decode certificate returned from server", (Throwable)e);
            }
        }
        return results;
    }

    private static AuthenticationSpec createAuthenticationSpec(LdapIdentitySource.AuthenticationDetails authenticationDetails) {
        AuthenticationSpec result = new AuthenticationSpec();
        result.authenticationType = authenticationDetails.getAuthenticationType();
        result.username = authenticationDetails.getUsername();
        return result;
    }

    private LdapIdentitySourceDetails createLdapIdsDetails(ExternalDomainSpec domainSpec) throws URISyntaxException {
        String userBaseDn = domainSpec.userBaseDn;
        String groupBaseDn = domainSpec.groupBaseDn;
        if (userBaseDn != null && userBaseDn.trim().isEmpty()) {
            userBaseDn = null;
        }
        if (groupBaseDn != null && groupBaseDn.trim().isEmpty()) {
            groupBaseDn = null;
        }
        URI primaryUrl = null;
        URI failoverUrl = null;
        if (this.isNotEmpty(domainSpec.primaryUrl)) {
            primaryUrl = new URI(domainSpec.primaryUrl);
        }
        if (this.isNotEmpty(domainSpec.failoverUrl)) {
            failoverUrl = new URI(domainSpec.failoverUrl);
        }
        List<X509Spec> certificates = domainSpec.certificates;
        ArrayList<String> rawCertificates = new ArrayList<String>();
        if (certificates != null && !certificates.isEmpty()) {
            for (X509Spec spec : certificates) {
                String certificate = CertificateUtil.trimCertificateMarkers((String)spec.certificateAsString);
                rawCertificates.add(certificate);
            }
        }
        return new LdapIdentitySourceDetails(domainSpec.friendlyName, userBaseDn, groupBaseDn, primaryUrl, failoverUrl, domainSpec.searchTimeoutSeconds, Boolean.valueOf(domainSpec.siteAffinityEnabled), rawCertificates.toArray(new String[rawCertificates.size()]));
    }

    private boolean isNotEmpty(String value) {
        return value != null && !value.trim().isEmpty();
    }

    private IdentitySourceManagementService.AuthenticationCredentials createAuthenticationCredentails(AuthenticationSpec authenticationSpec) {
        if (!AUTHENTICATION_TYPE_PASSWORD.equals(authenticationSpec.authenticationType)) {
            return null;
        }
        String username = authenticationSpec.username;
        String password = authenticationSpec.password;
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        return new IdentitySourceManagementService.AuthenticationCredentials(username, password, Boolean.valueOf(false), "placeholder");
    }

    private X509Certificate[] getExternalDomainCertificates(X509UsageSpec[] certificateSpecs) {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        try {
            String[] allExternalCertificates;
            for (String base64cert : allExternalCertificates = this.getExternalDomainsCertificates()) {
                X509Certificate x509cert = CertificateUtil.decodeCertificate((String)base64cert);
                String x509thumb = CertificateUtil.getThumbprint((Certificate)x509cert);
                if (!this.hasMatchingCertificate(certificateSpecs, x509thumb)) continue;
                result.add(x509cert);
            }
        }
        catch (Exception e) {
            _logger.warn((Object)("Cannot construct IdS X509Certificate objects:" + e.getMessage()));
        }
        return result.toArray(new X509Certificate[result.size()]);
    }

    private boolean hasMatchingCertificate(X509UsageSpec[] maybeUsedCertificates, String thumb) {
        for (X509UsageSpec maybeUsedCert : maybeUsedCertificates) {
            if (!thumb.equalsIgnoreCase(maybeUsedCert.thumbprint)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setLogonBannerTitle(String logonBannerTitle) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getDomainManagementService().setLogonBannerTitle(logonBannerTitle);
        }
        catch (Exception e) {
            _logger.error((Object)("Error getting login banner title: " + e.getMessage()), (Throwable)e);
            throw new SsoServiceException((Throwable)e);
        }
    }

    @Override
    public String getLogonBannerTitle() throws Exception {
        String logonBannerTitle = null;
        try {
            HttpSession session = SessionUtil.getHttpSession();
            logonBannerTitle = this.getAdminService(session).getDomainManagementService().getLogonBannerTitle();
        }
        catch (Exception e) {
            _logger.error((Object)("Error getting login banner title: " + e.getMessage()), (Throwable)e);
            throw new SsoServiceException((Throwable)e);
        }
        return logonBannerTitle;
    }

    @Override
    public void setLogonBannerContent(String logonBannerContent) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getDomainManagementService().setLogonBannerContent(logonBannerContent);
        }
        catch (Exception e) {
            _logger.error((Object)("Error setting login banner content: " + e.getMessage()), (Throwable)e);
            throw new SsoServiceException((Throwable)e);
        }
    }

    @Override
    public String getLogonBannerContent() throws Exception {
        String logonBannerContent = null;
        try {
            HttpSession session = SessionUtil.getHttpSession();
            logonBannerContent = this.getAdminService(session).getDomainManagementService().getLogonBannerContent();
        }
        catch (Exception e) {
            _logger.error((Object)("Error getting login banner content: " + e.getMessage()), (Throwable)e);
            throw new SsoServiceException((Throwable)e);
        }
        return logonBannerContent;
    }

    @Override
    public void setLogonBannerCheckboxFlag(boolean status) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getDomainManagementService().setLogonBannerCheckboxFlag(Boolean.valueOf(status));
        }
        catch (Exception e) {
            _logger.error((Object)("Error setting login banner content: " + e.getMessage()), (Throwable)e);
            throw new SsoServiceException((Throwable)e);
        }
    }

    @Override
    public boolean getLogonBannerCheckboxFlag() throws Exception {
        boolean status = false;
        try {
            HttpSession session = SessionUtil.getHttpSession();
            status = this.getAdminService(session).getDomainManagementService().getLogonBannerCheckboxFlag();
        }
        catch (Exception e) {
            _logger.error((Object)("Error getting login banner content: " + e.getMessage()), (Throwable)e);
            throw new SsoServiceException((Throwable)e);
        }
        return status;
    }

    @Override
    public void disableLogonBanner() throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getDomainManagementService().disableLogonBanner();
        }
        catch (Exception e) {
            _logger.error((Object)("Error setting login banner content: " + e.getMessage()), (Throwable)e);
            throw new SsoServiceException((Throwable)e);
        }
    }

    @Override
    public boolean getLogonBannerStatus() throws Exception {
        boolean status = false;
        try {
            HttpSession session = SessionUtil.getHttpSession();
            status = this.getAdminService(session).getDomainManagementService().isLogonBannerDisabled() == false;
        }
        catch (Exception e) {
            _logger.error((Object)("Error getting login banner content: " + e.getMessage()), (Throwable)e);
            throw new SsoServiceException((Throwable)e);
        }
        return status;
    }

    private IdentitySourceManagementService getManagementService() throws SsoServiceException {
        HttpSession session = SessionUtil.getHttpSession();
        SsoAdminService adminService = this.getAdminService(session);
        return adminService.getIdentitySourceManagementService();
    }

    private boolean isGatewayMode() {
        return PropertyUtil.getBooleanProperty((ConfigurationService)this._configurationService, (String)"vmc.gateway.mode", (boolean)false);
    }
}

