/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.notifications;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.vim.commons.notifications.NotificationData;
import com.vmware.vise.vim.commons.notifications.NotificationsDataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfPasswordExpirationNotificationProvider
implements NotificationsDataProvider {
    private static final String OBJECT_ID = "id";
    private static final String SSO_PRINCIPAL_MANAGER_GUID = "urn:vri:sso:PrincipalManager:pm-0";
    private static final String SELF_PASSWORD_EXPIRATION_PROPERTY = "vsphere:selfPasswordExpiration";
    private static final int FIRST_RESULT_ITEM_INDEX = 0;
    private static final Log _logger = LogFactory.getLog(NotificationsDataProvider.class);
    private final ObjectReferenceService _objectReferenceService;
    private final QueryService _queryService;

    public SelfPasswordExpirationNotificationProvider(QueryServiceFactory queryServiceFactory, ObjectReferenceService objectRefService) {
        this._queryService = queryServiceFactory.getQueryService();
        this._objectReferenceService = objectRefService;
    }

    public List<NotificationData> getNotificationData() {
        ArrayList<NotificationData> resultList = new ArrayList<NotificationData>();
        Object ref = this._objectReferenceService.getReference(SSO_PRINCIPAL_MANAGER_GUID, true);
        ArrayList<PropertyPredicate> filter = new ArrayList<PropertyPredicate>();
        filter.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(ref)));
        String[] resourceModels = new String[]{this._objectReferenceService.getResourceObjectType(ref)};
        String[] props = new String[]{SELF_PASSWORD_EXPIRATION_PROPERTY};
        try {
            ResultSet resultSet = this._queryService.select(props).from(resourceModels).where(LogicalOperator.AND, filter).opId("password-expiration-notification").fetch();
            Map<String, Object> result = this.transformResultSet(resultSet);
            NotificationData notification = new NotificationData();
            notification.type = "password-expiration-notification";
            notification.notification = result;
            resultList.add(notification);
        }
        catch (Exception e) {
            _logger.error((Object)"Error while retrieving self password expiration property for notification", (Throwable)e);
        }
        return resultList;
    }

    private Map<String, Object> transformResultSet(ResultSet resultSet) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (resultSet.getItems().isEmpty()) {
            return result;
        }
        ResourceItem resourceItem = (ResourceItem)resultSet.getItems().get(0);
        result.put(OBJECT_ID, this._objectReferenceService.getUid(resourceItem.getKey(), true));
        result.put(SELF_PASSWORD_EXPIRATION_PROPERTY, resourceItem.get(SELF_PASSWORD_EXPIRATION_PROPERTY));
        return result;
    }
}

