/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.util;

import com.vmware.vim.binding.sso.admin.SolutionUser;
import com.vmware.vim.binding.sso.admin.fault.PasswordPolicyViolationFault;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vsphere.client.sso.admin.exception.PasswordRequiredException;
import com.vmware.vsphere.client.sso.admin.model.ApplicationUser;
import java.io.UnsupportedEncodingException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoAdminUtil {
    private static final String RESOURCE_BUNDLE_NAME = "ssoadminservice";
    private static final Log _logger = LogFactory.getLog(SsoAdminUtil.class);

    public static ApplicationUser toApplicationUser(SolutionUser user) {
        ApplicationUser result = new ApplicationUser();
        result.id = user.id;
        result.alias = user.alias;
        result.disabled = user.disabled;
        if (user.details == null) {
            return result;
        }
        result.description = user.details.description;
        if (user.details.certificate == null) {
            return result;
        }
        try {
            Certificate c = CertificateUtil.generateCertificate((String)user.details.certificate);
            result.certificate = new X509Spec((X509Certificate)c);
        }
        catch (UnsupportedEncodingException e) {
            _logger.error((Object)"Certificate data encoding is wrong:", (Throwable)e);
        }
        catch (CertificateException e) {
            _logger.error((Object)"Certificate data decoding failed:", (Throwable)e);
        }
        return result;
    }

    public static Exception getOperationResultError(Exception e) {
        if (e instanceof PasswordPolicyViolationFault || e instanceof PasswordRequiredException) {
            return e;
        }
        ServiceFault result = new ServiceFault();
        result.setMessage(e.getMessage());
        result.setStackTrace(e.getStackTrace());
        if (e instanceof ServiceFault) {
            ServiceFault serviceFault = (ServiceFault)e;
            result.setFaultCause(serviceFault.getFaultCause());
            result.setFaultMessage(serviceFault.getFaultMessage());
        }
        return result;
    }

    public static String getString(String key, String ... parameters) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (String[])parameters, (ClassLoader)SsoAdminUtil.class.getClassLoader());
    }
}

