/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data;

import com.vmware.vise.data.ParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class PropertySpec
implements Cloneable {
    public String type;
    public String relation;
    public String[] propertyNames;
    public ParameterSpec[] parameters;

    public String toString() {
        return "[type: " + this.type + ", relation: " + this.relation + ", propertyNames: " + Arrays.toString(this.propertyNames) + ", parameters: " + Arrays.toString(this.parameters) + "]";
    }

    public PropertySpec clone() throws CloneNotSupportedException {
        int i;
        PropertySpec copy = (PropertySpec)super.clone();
        copy.type = this.type;
        copy.relation = this.relation;
        if (this.propertyNames != null) {
            copy.propertyNames = new String[this.propertyNames.length];
            for (i = 0; i < this.propertyNames.length; ++i) {
                copy.propertyNames[i] = this.propertyNames[i];
            }
        }
        if (this.parameters != null) {
            copy.parameters = new ParameterSpec[this.parameters.length];
            for (i = 0; i < this.parameters.length; ++i) {
                copy.parameters[i] = this.parameters[i].clone();
            }
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertySpec)) {
            return false;
        }
        PropertySpec that = (PropertySpec)obj;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(PropertySpec.normalizeRelation(this.relation), PropertySpec.normalizeRelation(that.relation))) {
            return false;
        }
        if (!PropertySpec.toSet(this.propertyNames).equals(PropertySpec.toSet(that.propertyNames))) {
            return false;
        }
        return PropertySpec.toSet(this.parameters).equals(PropertySpec.toSet(that.parameters));
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.type);
        result = 31 * result + Objects.hashCode(PropertySpec.normalizeRelation(this.relation));
        result = 31 * result + Arrays.hashCode(this.propertyNames);
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    private static String normalizeRelation(String relation) {
        if ("".equals(relation)) {
            return null;
        }
        return relation;
    }

    private static <T> Set<T> toSet(T[] arr) {
        return arr == null ? Collections.emptySet() : new HashSet<T>(Arrays.asList(arr));
    }
}

