/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.common.compositecommand;

import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.BaseCommand;
import com.vmware.vsphere.client.common.compositecommand.CommandDebugUtil;
import com.vmware.vsphere.client.common.compositecommand.CommandState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TaskCommand
extends BaseCommand {
    private static final Log _logger = LogFactory.getLog(TaskCommand.class);
    private static final int MAX_MISSING_TASK_INFO_COUNT = 10;
    private Task _task;
    private int _missingTaskInfoCount = 0;

    public Task getTask() {
        return this._task;
    }

    public void updateRuntimeInfo(TaskInfo taskInfo) {
        if (taskInfo == null) {
            ++this._missingTaskInfoCount;
            if (this._missingTaskInfoCount >= 10) {
                this.succeedCommandDueToMissingTaskInfo();
            }
            return;
        }
        this._missingTaskInfoCount = 0;
        this.setTaskState(taskInfo);
        if (taskInfo.progress != null) {
            this.runtimeInfo.progress = taskInfo.progress;
            this.runtimeInfo.state = CommandState.IN_PROGRESS;
        } else if (taskInfo.state == TaskInfo.State.success) {
            this.runtimeInfo.progress = 100;
            if (taskInfo.result != null && taskInfo.result instanceof ManagedObjectReference) {
                this.runtimeInfo.createdMor = (ManagedObjectReference)taskInfo.result;
            }
        }
    }

    @Override
    public final void run() throws Exception {
        if (_logger.isDebugEnabled()) {
            String className = this.getClass().getCanonicalName();
            String specDump = CommandDebugUtil.dumpCommandSpec(this.getCommandSpec(), false);
            _logger.debug((Object)String.format("Running task command %s for spec:\n%s", className, specDump));
        }
        this._task = this.launch();
    }

    protected abstract Task launch() throws Exception;

    private void setTaskState(TaskInfo taskInfo) {
        if (taskInfo == null || taskInfo.state == null) {
            return;
        }
        switch (taskInfo.state) {
            case success: {
                this.runtimeInfo.state = CommandState.SUCCEEDED;
                break;
            }
            case error: {
                this.runtimeInfo.state = CommandState.FAILED;
                this.runtimeInfo.error = taskInfo.error;
                break;
            }
            case queued: {
                this.runtimeInfo.state = CommandState.NOT_STARTED;
                break;
            }
            case running: {
                this.runtimeInfo.state = CommandState.IN_PROGRESS;
            }
        }
    }

    private void succeedCommandDueToMissingTaskInfo() {
        _logger.info((Object)String.format("Task %s was missing taskInfo for %d times in a row. Assuming command is success!\n--> commandSpec =  %s", this._task != null && this._task._getRef() != null ? this._task._getRef() : this._task, this._missingTaskInfoCount, ObjectUtil.prettyPrint(this.getCommandSpec())));
        this.runtimeInfo.state = CommandState.SUCCEEDED;
    }
}

