/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.data.util;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang.ArrayUtils;

public class DataUtil {
    public static ResultSet toResultSet(Collection<ResultItem> items) {
        ResultSet result = new ResultSet();
        result.items = items.toArray(new ResultItem[items.size()]);
        return result;
    }

    public static String[] extractPropertyNames(PropertyRequestSpec propertyRequest) {
        PropertySpec[] specs = propertyRequest.properties;
        Object[] result = new String[]{};
        for (PropertySpec spec : specs) {
            result = (String[])ArrayUtils.addAll((Object[])result, (Object[])spec.propertyNames);
        }
        return result;
    }

    public static String[] extractSupportedProperties(PropertySpec[] specs, String[] supportedProperties, ManagedObjectReference targetObject) {
        LinkedList<String> result = new LinkedList<String>();
        for (PropertySpec spec : specs) {
            String targetType = DataUtil.getType(targetObject);
            if (targetType != null && !targetType.equals(spec.type)) continue;
            for (String propName : spec.propertyNames) {
                if (!ArrayUtils.contains((Object[])supportedProperties, (Object)propName)) continue;
                result.add(propName);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String getType(ManagedObjectReference moRef) {
        Class morClass = ManagedObjectUtil.getType((ManagedObjectReference)moRef);
        if (morClass == null) {
            return null;
        }
        return morClass.getSimpleName();
    }

    public static ManagedObjectReference[] extractObjectRefs(PropertyRequestSpec propertyRequest) {
        LinkedList<ManagedObjectReference> result = new LinkedList<ManagedObjectReference>();
        for (Object object : propertyRequest.objects) {
            if (!(object instanceof ManagedObjectReference)) continue;
            result.add((ManagedObjectReference)object);
        }
        return result.toArray(new ManagedObjectReference[result.size()]);
    }
}

