/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.error.transform;

import com.vmware.vapi.std.errors.Error;
import com.vmware.vim.binding.vmodl.MethodFault;

public final class ErrorTransformUtil {
    private static final Class<?>[] EXPECTED_EXCEPTIONS = new Class[]{MethodFault.class, Error.class};

    public static Exception convertError(String errMsg) {
        if (errMsg == null) {
            return null;
        }
        return ErrorTransformUtil.convertError(new Exception(errMsg));
    }

    public static Exception convertError(Exception ex) {
        if (ex == null) {
            return null;
        }
        for (Class<?> cls : EXPECTED_EXCEPTIONS) {
            if (!cls.isAssignableFrom(ex.getClass())) continue;
            return ex;
        }
        MethodFault newException = new MethodFault();
        newException.setFaultCause(ex);
        newException.setMessage(ex.getLocalizedMessage());
        return newException;
    }
}

