/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vapi.impl;

import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vise.vim.commons.vapi.ResourceModelTypeProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class MapBasedResourceModelTypeProvider
implements ResourceModelTypeProvider {
    private static final String PACKAGE_DELIMITER = ".";
    private final HashMap<String, StructType> canonicalNameToStructTypeMap;
    private final Set<String> packageNames;

    public MapBasedResourceModelTypeProvider(HashMap<String, StructType> canonicalNameToStructTypeMap) {
        Validate.notNull(canonicalNameToStructTypeMap);
        this.canonicalNameToStructTypeMap = canonicalNameToStructTypeMap;
        this.packageNames = new HashSet<String>();
        for (String canonicalName : canonicalNameToStructTypeMap.keySet()) {
            int lastIndexOfPackageDelimiter = canonicalName.lastIndexOf(PACKAGE_DELIMITER);
            if (lastIndexOfPackageDelimiter == -1) continue;
            String packageName = canonicalName.substring(0, lastIndexOfPackageDelimiter);
            this.packageNames.add(packageName);
        }
    }

    public StructType getResourceModelType(String canonicalName) {
        StructType structType = this.canonicalNameToStructTypeMap.get(canonicalName);
        return structType;
    }

    public Set<String> getPackageNames() {
        return this.packageNames;
    }
}

