/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.file;

import com.vmware.h5.sdk.plugin.migration.config.Configuration;
import com.vmware.h5.sdk.plugin.migration.file.SpriteImageCreationException;
import com.vmware.h5.sdk.plugin.migration.utils.PluginMigrationUtils;
import com.vmware.vise.plugin.manifest.model.i18n.LanguageTag;
import com.vmware.vise.plugin.manifest.model.icon.SpriteSheetIconDefinition;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;

public class ResourceDefinitionManager {
    private static final List<String> EXCLUDE_FOLDERS_LIST = Arrays.asList("target", "META-INF", "WEB-INF", "dist", "node_modules");
    private final Configuration configuration;

    public ResourceDefinitionManager(Configuration configuration) {
        this.configuration = configuration;
    }

    public Map<String, Properties> getLocalePropertiesMap(String resourceFolderName, String baseResourceFileName) {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        try {
            File localesDir;
            List<Path> paths = this.getResourceFolderPaths(resourceFolderName);
            Path resourceFolderPath = this.getResourceFolderContainingFilesWithSuffix(paths, "properties");
            if (resourceFolderPath != null && (localesDir = resourceFolderPath.toFile()).isDirectory()) {
                File[] files;
                for (File file : files = localesDir.listFiles()) {
                    try {
                        String localePropertiesName;
                        if (!file.getName().endsWith(".properties")) continue;
                        Properties properties = new Properties();
                        properties.load(new FileReader(file));
                        String fileName = file.getName();
                        String locale = fileName.substring(baseResourceFileName.length(), fileName.indexOf(".")).replace("_", "-");
                        String string = localePropertiesName = PluginMigrationUtils.isStringEmpty(locale) ? "en-US" : this.getFullLocaleString(locale.substring(1));
                        if (localePropertiesName == null) continue;
                        propertiesMap.put(localePropertiesName, properties);
                    }
                    catch (IOException ex) {
                        System.out.printf("Unable to read file %s%n", file.getName());
                    }
                }
            }
        }
        catch (IOException ex) {
            System.out.printf("Unable to find resource folder %s%n", resourceFolderName);
        }
        return propertiesMap;
    }

    public BufferedImage buildSpriteImage(Map<String, SpriteSheetIconDefinition> iconDefinitionMap, String placeholderIconImageName) throws SpriteImageCreationException {
        BufferedImage spriteImage = null;
        if (iconDefinitionMap.isEmpty()) {
            System.out.println("Unable to build a sprite image. No icon definitions found.");
            return spriteImage;
        }
        BufferedImage placeholderIconImage = this.getClassPathImage(placeholderIconImageName);
        if (placeholderIconImage == null) {
            throw new SpriteImageCreationException("Unable to get the placeholder icon: " + placeholderIconImageName);
        }
        short maxHeight = 0;
        short maxWidth = 0;
        for (SpriteSheetIconDefinition spriteSheetIconDefinition : iconDefinitionMap.values()) {
            if (spriteSheetIconDefinition.getY() > maxHeight) {
                maxHeight = spriteSheetIconDefinition.getY();
            }
            if (spriteSheetIconDefinition.getX() <= maxWidth) continue;
            maxWidth = spriteSheetIconDefinition.getX();
        }
        spriteImage = new BufferedImage(maxWidth += 32, maxHeight += 32, 2);
        Graphics spritesheetImageGraphics = spriteImage.getGraphics();
        for (SpriteSheetIconDefinition spriteSheetIconDefinition : iconDefinitionMap.values()) {
            spritesheetImageGraphics.drawImage(placeholderIconImage, spriteSheetIconDefinition.getX(), spriteSheetIconDefinition.getY(), null);
        }
        return spriteImage;
    }

    public void createSpriteImage(BufferedImage spriteImage, String spriteName) {
        try {
            ImageIO.write((RenderedImage)spriteImage, "png", Paths.get(this.configuration.getOutputDir(), spriteName).toFile());
            System.out.printf("%s sprite image file is generated in the directory %s%n", spriteName, this.configuration.getOutputDir());
        }
        catch (IOException e) {
            System.out.printf("Unable to create sprite sheet \"%s\"", spriteName);
        }
    }

    private String getFullLocaleString(String locale) {
        for (LanguageTag tag : LanguageTag.values()) {
            String localeString = tag.getLocaleString();
            if (!localeString.equals(locale) && !localeString.startsWith(locale + "-")) continue;
            return localeString;
        }
        return null;
    }

    private BufferedImage getClassPathImage(String imageName) {
        BufferedImage bufferedImage = null;
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("images/" + imageName);){
            if (in != null) {
                bufferedImage = ImageIO.read(in);
            }
        }
        catch (IOException e) {
            System.out.printf("Unable to get the buffered image \"%s\".", imageName);
        }
        return bufferedImage;
    }

    private Path getResourceFolderContainingFilesWithSuffix(List<Path> paths, String suffix) {
        if (paths != null) {
            if (paths.size() == 1) {
                return paths.get(0);
            }
            for (Path path : paths) {
                File[] listOfFiles;
                File file = path.toFile();
                if (!file.isDirectory()) continue;
                for (File propFile : listOfFiles = file.listFiles()) {
                    if (!propFile.getName().endsWith("." + suffix)) continue;
                    return path;
                }
            }
        }
        return null;
    }

    private List<Path> getResourceFolderPaths(String filePath) throws IOException {
        String[] filePaths = filePath.split("/");
        return this.getPaths(Paths.get(this.configuration.getProjectDir(), new String[0]), filePaths, true);
    }

    private List<Path> getPaths(Path rootPath, final String[] folderPath, final boolean matchAllPaths) throws IOException {
        if (folderPath == null || folderPath.length == 0) {
            return null;
        }
        final ArrayList paths = new ArrayList();
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
                String fileName = path.getFileName().toString();
                if (EXCLUDE_FOLDERS_LIST.contains(fileName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (folderPath[0].equals(fileName)) {
                    paths.add(path);
                    if (!matchAllPaths) {
                        return FileVisitResult.TERMINATE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        ArrayList<Path> resolvedPaths = new ArrayList<Path>();
        String[] subPaths = Arrays.copyOfRange(folderPath, 1, folderPath.length);
        for (Path path : paths) {
            if (folderPath.length > 1) {
                try {
                    Path childPath = Paths.get(path.toString(), subPaths);
                    if (childPath == null) continue;
                    resolvedPaths.add(childPath);
                }
                catch (InvalidPathException invalidPathException) {}
                continue;
            }
            resolvedPaths.add(path);
        }
        return resolvedPaths;
    }
}

